/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import tlc2.tool.Action;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import util.UniqueString;

public class CounterExample
extends RecordValue {
    private static final UniqueString STATES = UniqueString.of("state");
    private static final UniqueString ACTIONS = UniqueString.of("action");

    public CounterExample() {
        this(new ArrayList<TLCStateInfo>(0), Action.UNKNOWN, 0);
    }

    public CounterExample(List<TLCStateInfo> trace) {
        this(trace, Action.UNKNOWN, 0);
    }

    public CounterExample(List<TLCStateInfo> trace, int loopOrdinal) {
        this(trace, Action.UNKNOWN, loopOrdinal);
    }

    public CounterExample(List<TLCStateInfo> trace, Action action, int loopOrdinal) {
        super(new UniqueString[]{ACTIONS, STATES}, new Value[2], false);
        int loopIdx = loopOrdinal - 1;
        assert (loopIdx < trace.size());
        LinkedList<TupleValue> states = new LinkedList<TupleValue>();
        ArrayList<TupleValue> actions = new ArrayList<TupleValue>();
        int i = 0;
        while (i < trace.size()) {
            TLCStateInfo info = trace.get(i);
            TupleValue r = new TupleValue(new Value[]{IntValue.gen(info.getStateNumber()), info.toRecordValue()});
            if (i > 0) {
                TupleValue edge = new TupleValue(new Value[]{(Value)states.getLast(), new RecordValue(info.getAction()), r});
                actions.add(edge);
            }
            states.add(r);
            ++i;
        }
        if (loopOrdinal > 0) {
            Value last = (Value)states.getLast();
            Value back = (Value)states.get(loopIdx);
            TupleValue edge = new TupleValue(new Value[]{last, new RecordValue(action), back});
            actions.add(edge);
        }
        this.values[0] = new SetEnumValue((Value[])actions.toArray(Value[]::new), false);
        this.values[1] = new SetEnumValue((Value[])states.toArray(Value[]::new), false);
    }

    public CounterExample(TLCState initialState) {
        this(Arrays.asList(new TLCStateInfo(initialState)), Action.UNKNOWN, 0);
    }

    public Value toTrace() {
        SetEnumValue set = (SetEnumValue)this.select(new StringValue(STATES));
        Value[] v = new Value[set.elems.size()];
        int i = 0;
        while (i < v.length) {
            TupleValue tv = (TupleValue)set.elems.elementAt(i);
            v[((IntValue)tv.getElem((int)0)).val - 1] = (Value)tv.getElem(1);
            ++i;
        }
        return new TupleValue(v);
    }
}

