/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.util.Vector;
import tla2tex.BuiltInSymbols;
import tla2tex.Misc;
import tla2tex.Position;

public class Token {
    public String string;
    public int column;
    public int type;
    public static final int BUILTIN = 1;
    public static final int NUMBER = 2;
    public static final int STRING = 3;
    public static final int IDENT = 4;
    public static final int COMMENT = 5;
    public static final int DASHES = 6;
    public static final int END_MODULE = 7;
    public static final int PROLOG = 8;
    public static final int EPILOG = 9;
    public static final int PF_STEP = 12;
    public static final int PCAL_LABEL = 13;
    public Position aboveAlign = new Position();
    public float preSpace = 0.0f;
    public boolean subscript = false;
    public Position belowAlign = new Position();
    public boolean isAlignmentPoint = false;
    public float distFromMargin = 0.0f;

    public Token(String str, int col, int typ) {
        this.string = str;
        this.column = col;
        this.type = typ;
    }

    public Token() {
        this.string = "";
        this.column = 0;
        this.type = 0;
    }

    public int getWidth() {
        if (this.string == null) {
            return 0;
        }
        if (this.type == 3) {
            return this.string.length() + 2;
        }
        return this.string.length();
    }

    static void FindPfStepTokens(Token[][] toks) {
        int k = 0;
        while (k < toks.length) {
            Token[] input = toks[k];
            Vector<Token> outputVec = new Vector<Token>(input.length);
            int i = 0;
            while (i < input.length) {
                if (i < input.length - 2 && input[i].string.equals("<") && input[i + 1].column == input[i].column + 1 && input[i + 1].type == 2 && input[i + 2].string.equals(">") && input[i + 2].column == input[i + 1].column + input[i + 1].getWidth()) {
                    int numOfToks = 3;
                    boolean needsSpace = true;
                    String str = "<" + input[i + 1].string + ">";
                    if (i < input.length - 3 && input[i + 3].column == input[i + 2].column + 1 && (input[i + 3].type == 2 || input[i + 3].type == 4)) {
                        str = String.valueOf(str) + input[i + 3].string;
                        numOfToks = 4;
                        if (i < input.length - 4 && input[i + 4].column == input[i + 3].column + input[i + 3].getWidth() && input[i + 4].string.equals(".")) {
                            str = String.valueOf(str) + ".";
                            numOfToks = 5;
                        }
                    }
                    if (i < input.length - numOfToks && input[i + numOfToks].type == 1 && (BuiltInSymbols.GetBuiltInSymbol((String)input[i + numOfToks].string, (boolean)true).symbolType == 1 || BuiltInSymbols.GetBuiltInSymbol((String)input[i + numOfToks].string, (boolean)true).symbolType == 8)) {
                        needsSpace = false;
                    }
                    outputVec.addElement(new PfStepToken(str, input[i].column, needsSpace));
                    i += numOfToks;
                    continue;
                }
                outputVec.addElement(input[i]);
                ++i;
            }
            if (outputVec.size() != input.length) {
                toks[k] = new Token[outputVec.size()];
                i = 0;
                while (i < outputVec.size()) {
                    toks[k][i] = (Token)outputVec.elementAt(i);
                    ++i;
                }
            }
            ++k;
        }
    }

    public String mostOfString() {
        String typeName = "";
        switch (this.type) {
            case 1: {
                typeName = "BUILTIN";
                break;
            }
            case 2: {
                typeName = "NUMBER";
                break;
            }
            case 3: {
                typeName = "STRING";
                break;
            }
            case 12: {
                typeName = "PF_STEP";
                break;
            }
            case 4: {
                typeName = "IDENT";
                break;
            }
            case 5: {
                typeName = "COMMENT";
                break;
            }
            case 6: {
                typeName = "DASHES";
                break;
            }
            case 7: {
                typeName = "END_MODULE";
                break;
            }
            case 8: {
                typeName = "PROLOG";
                break;
            }
            case 9: {
                typeName = "EPILOG";
                break;
            }
            case 13: {
                typeName = "PCAL_LABEL";
            }
        }
        String str = "\"" + this.string + "\"";
        if (this.string == null) {
            str = "null";
        }
        String result = "[str |-> " + str + ",\t type |-> " + typeName + ",\t col |-> " + this.column + ",\t width |-> " + this.getWidth();
        if (this.aboveAlign.line != -1) {
            result = String.valueOf(result) + ",\t above |-> " + this.aboveAlign.toString();
        }
        if (this.belowAlign.line != -1) {
            result = String.valueOf(result) + ",\t below |-> " + this.belowAlign.toString();
        }
        if (this.preSpace != 0.0f) {
            result = String.valueOf(result) + ", space |-> " + this.preSpace;
        }
        if (this.isAlignmentPoint) {
            result = String.valueOf(result) + ", align |-> true";
        }
        if (this.distFromMargin != 0.0f) {
            result = String.valueOf(result) + ", dist |-> " + this.distFromMargin;
        }
        if (this.subscript) {
            result = String.valueOf(result) + ", sub |-> true";
        }
        return result;
    }

    public String toString() {
        return Misc.BreakLine(String.valueOf(this.mostOfString()) + "]");
    }

    public static class PfStepToken
    extends Token {
        public boolean needsSpace;

        public PfStepToken(String str, int col, boolean space) {
            super(str, col, 12);
            this.needsSpace = space;
        }
    }
}

