/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import tlc2.util.FP64;
import tlc2.value.RandomEnumerableValues;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.SubsetValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueVec;

@State(value=Scope.Benchmark)
public class EnumerateSubsetBenchmark {
    @Param(value={"0", "1", "2", "3", "4", "8", "10", "12", "14", "16", "18", "19"})
    public int numOfElements;

    static {
        RandomEnumerableValues.setSeed(15041980L);
        RandomEnumerableValues.reset();
        FP64.Init();
    }

    @Benchmark
    public Enumerable elementsAlwaysNormalized() {
        Value elem;
        IntervalValue inner = new IntervalValue(1, this.numOfElements);
        SubsetValue subset = new SubsetValue(inner);
        ValueVec vals = new ValueVec(subset.size());
        ValueEnumeration Enum2 = subset.elementsNormalized();
        while ((elem = Enum2.nextElement()) != null) {
            vals.addElement(elem);
        }
        return (Enumerable)((Object)new SetEnumValue(vals, true).normalize());
    }

    @Benchmark
    public Enumerable kElementsNotNormalized() {
        IntervalValue inner = new IntervalValue(1, this.numOfElements);
        SubsetValue subset = new SubsetValue(inner);
        ValueVec vec = new ValueVec(subset.size());
        int i = 0;
        while (i <= inner.size()) {
            Value elem;
            ValueEnumeration Enum2 = subset.kElements(i);
            while ((elem = Enum2.nextElement()) != null) {
                vec.addElement(elem);
            }
            ++i;
        }
        return new SetEnumValue(vec, false);
    }

    @Benchmark
    public Enumerable kElementsNormalized() {
        IntervalValue inner = new IntervalValue(1, this.numOfElements);
        SubsetValue subset = new SubsetValue(inner);
        ValueVec vec = new ValueVec(subset.size());
        int i = 0;
        while (i <= inner.size()) {
            Value elem;
            ValueEnumeration Enum2 = subset.kElements(i);
            while ((elem = Enum2.nextElement()) != null) {
                vec.addElement(elem);
            }
            ++i;
        }
        return (Enumerable)((Object)new SetEnumValue(vec, false).normalize());
    }

    @Benchmark
    public Enumerable elementsNotNormalized() {
        Value elem;
        IntervalValue inner = new IntervalValue(1, this.numOfElements);
        SubsetValue subset = new SubsetValue(inner);
        ValueVec vals = new ValueVec(subset.size());
        ValueEnumeration Enum2 = subset.elementsLexicographic();
        while ((elem = Enum2.nextElement()) != null) {
            vals.addElement(elem);
        }
        return new SetEnumValue(vals, false);
    }

    @Benchmark
    public Enumerable elementsNormalized() {
        Value elem;
        IntervalValue inner = new IntervalValue(1, this.numOfElements);
        SubsetValue subset = new SubsetValue(inner);
        ValueVec vals = new ValueVec(subset.size());
        ValueEnumeration Enum2 = subset.elementsLexicographic();
        while ((elem = Enum2.nextElement()) != null) {
            vals.addElement(elem);
        }
        return (Enumerable)((Object)new SetEnumValue(vals, false).normalize());
    }
}

