/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import tla2sany.output.SanyOutput;
import tla2sany.output.SilentSanyOutput;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.parser.TLAplusParser;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.Errors;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.Generator;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.Location;
import tlc2.tool.impl.SpecProcessor;
import util.ToolIO;

public abstract class TLCDebuggerExpression {
    private TLCDebuggerExpression() {
    }

    public static OpDefNode process(SpecProcessor processor, ModuleNode semanticRoot, Location location, String conditionExpr) {
        Set<String> paramNames = TLCDebuggerExpression.getScopedIdentifiers(semanticRoot, location);
        return TLCDebuggerExpression.process(processor, semanticRoot, paramNames, conditionExpr);
    }

    public static OpDefNode process(SpecProcessor processor, ModuleNode semanticRoot, String conditionExpr) {
        return TLCDebuggerExpression.process(processor, semanticRoot, new HashSet<String>(), conditionExpr);
    }

    private static OpDefNode process(SpecProcessor processor, ModuleNode semanticRoot, Set<String> paramNames, String conditionExpr) {
        if (conditionExpr == null || conditionExpr.isBlank()) {
            return null;
        }
        String rootModName = semanticRoot.getName().toString();
        String bpModName = semanticRoot.generateUnusedName("__DebuggerModule__%s");
        String bpOpName = semanticRoot.generateUnusedName("__DebuggerExpr__%s");
        String params = paramNames.size() > 0 ? "(" + String.join((CharSequence)", ", paramNames) + ")" : "";
        String bpOpDef = String.valueOf(bpOpName) + params;
        String wrapper = "---- MODULE %s ----\nEXTENDS %s\n%s == %s\n====";
        String wrappedConditionExpr = String.format("---- MODULE %s ----\nEXTENDS %s\n%s == %s\n====", bpModName, rootModName, bpOpDef, conditionExpr);
        byte[] wrappedConditionExprBytes = wrappedConditionExpr.getBytes(StandardCharsets.UTF_8);
        TLAplusParser parser = new TLAplusParser((SanyOutput)new SilentSanyOutput(), wrappedConditionExprBytes);
        boolean syntaxParseSuccess = parser.parse();
        SyntaxTreeNode syntaxRoot = parser.ParseTree;
        if (!syntaxParseSuccess || syntaxRoot == null) {
            ToolIO.err.println("Syntax error while parsing breakpoint expression \"" + conditionExpr + "\"");
            return null;
        }
        Errors semanticLog = new Errors();
        Generator semanticChecker = new Generator(processor.getModuleTbl(), semanticLog);
        ModuleNode bpModule = null;
        try {
            bpModule = semanticChecker.generate(syntaxRoot);
        }
        catch (AbortException e) {
            ToolIO.err.print(e.toString());
            ToolIO.err.println("Semantic error while parsing breakpoint expression \"" + conditionExpr + "\"");
            return null;
        }
        if (bpModule == null || semanticLog.isFailure()) {
            ToolIO.err.print(semanticLog.toString());
            ToolIO.err.println("Semantic error while parsing breakpoint expression \"" + conditionExpr + "\"");
            return null;
        }
        Errors levelCheckingErrors = new Errors();
        boolean levelCheckingSuccess = bpModule.levelCheck(levelCheckingErrors);
        if (!levelCheckingSuccess || levelCheckingErrors.isFailure() || !bpModule.levelCorrect) {
            ToolIO.err.println(levelCheckingErrors.toString());
            ToolIO.err.println("Level-checking error while parsing breakpoint expression \"" + conditionExpr + "\"");
            return null;
        }
        OpDefNode bpOp = bpModule.getOpDef(bpOpName);
        if (bpOp == null) {
            ToolIO.err.println("ERROR: unable to find debugger expression op " + bpOpName);
            return null;
        }
        if (bpOp.getLevel() != 0 && 1 != bpOp.getLevel() && 2 != bpOp.getLevel()) {
            ToolIO.err.println("ERROR: Debug expressions must be action-level or below; actual level: " + SemanticNode.levelToString(bpOp.getLevel()));
            return null;
        }
        processor.processConstantsDynamicExtendee(bpModule);
        ToolIO.out.println("Processed debugger expression \"" + conditionExpr + "\"");
        return bpOp;
    }

    static Set<String> getScopedIdentifiers(ModuleNode semanticRoot, Location location) {
        HashSet<String> identifiers = new HashSet<String>();
        LinkedList<SemanticNode> path = semanticRoot.pathTo(location, false);
        for (SemanticNode current : path) {
            SymbolNode opSymbol;
            LevelNode node;
            if (current instanceof LetInNode) {
                node = (LetInNode)current;
                OpDefNode[] opDefNodeArray = ((LetInNode)node).getLets();
                int n = opDefNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OpDefNode def = opDefNodeArray[n2];
                    identifiers.add(def.getName().toString());
                    ++n2;
                }
                continue;
            }
            if (current instanceof OpDefNode) {
                node = (OpDefNode)current;
                if (semanticRoot.getOpDef(((SymbolNode)node).getName()) == null) {
                    identifiers.add(((SymbolNode)node).getName().toString());
                }
                FormalParamNode[] formalParamNodeArray = ((OpDefNode)node).getParams();
                int n = formalParamNodeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    FormalParamNode param = formalParamNodeArray[n3];
                    identifiers.add(param.getName().toString());
                    ++n3;
                }
                continue;
            }
            if (current instanceof OpApplNode) {
                node = (OpApplNode)current;
                for (FormalParamNode param : ((OpApplNode)node).getQuantSymbolLists()) {
                    identifiers.add(param.getName().toString());
                }
                continue;
            }
            if (!(current instanceof OpArgNode) || !((opSymbol = ((OpArgNode)(node = (OpArgNode)current)).getOp()) instanceof OpDefNode)) continue;
            OpDefNode op = (OpDefNode)opSymbol;
            FormalParamNode[] formalParamNodeArray = op.getParams();
            int n = formalParamNodeArray.length;
            int n4 = 0;
            while (n4 < n) {
                FormalParamNode param = formalParamNodeArray[n4];
                identifiers.add(param.getName().toString());
                ++n4;
            }
        }
        return identifiers;
    }
}

