/*
 * Decompiled with CFR 0.152.
 */
package tlc2.output;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import tla2sany.drivers.FrontEndException;
import tla2sany.drivers.SANY;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.output.SilentSanyOutput;
import tlc2.model.Formula;
import tlc2.model.MCState;
import tlc2.model.TraceExpressionInformationHolder;
import tlc2.output.SpecTraceExpressionWriter;

public class SpecTraceExpressionWriterTest {
    private static final String TRIVIAL_TWO_STATE_DEADLOCK_PREAMBLE = "VARIABLE x, y\nXIncr == (x' = x * 2)\n            /\\ (x < 8)\n            /\\ UNCHANGED y\nYIncr == (y' = x + y)\n            /\\ (y < 15)\n            /\\ UNCHANGED x\n";
    private static final String[] TRIVIAL_TWO_STATE_DEADLOCK_INIT = new String[]{"TestInit", "TestInit == x \\in 1 .. 10 /\\ y \\in 1 .. 10\n"};
    private static final String[] TRIVIAL_TWO_STATE_DEADLOCK_NEXT = new String[]{"TestNext", "TestNext == YIncr \\/ XIncr\n"};
    private static final String ERROR_STATE_IP = "1: <Initial predicate>\n/\\ x = 8\n/\\ y = 7\n";
    private static final String ERROR_STATE_1 = "2: <YIncr line 8, col 10 to line 10, col 26 of module Bla>\n/\\ x = 8\n/\\ y = 15\n";
    private SpecTraceExpressionWriter writer;
    private File tlaFile;
    private File cfgFile;

    @Before
    public void setUp() throws IOException {
        this.tlaFile = File.createTempFile("sptewt_", ".tla");
        this.tlaFile.deleteOnExit();
        this.cfgFile = File.createTempFile("sptewt_", ".cfg");
        this.cfgFile.deleteOnExit();
        String tlaFilename = this.tlaFile.getName();
        int baseNameLength = tlaFilename.length() - ".tla".length();
        String specName = tlaFilename.substring(0, baseNameLength);
        this.writer = new SpecTraceExpressionWriter();
        this.writer.addPrimer(specName, "Naturals");
        this.writer.appendContentToBuffers(TRIVIAL_TWO_STATE_DEADLOCK_PREAMBLE, null);
    }

    private void concludeTest() throws FrontEndException, IOException {
        this.writer.writeFiles(this.tlaFile, this.cfgFile);
        SpecObj so = new SpecObj(this.tlaFile.getAbsolutePath(), null);
        int result = SANY.frontEndMain(so, this.tlaFile.getAbsolutePath(), new SilentSanyOutput());
        if (result != 0) {
            throw new FrontEndException("Parsing returned a non-zero success code (" + result + ")");
        }
    }

    private List<MCState> generateStatesForDeadlockCondition() {
        ArrayList<MCState> states = new ArrayList<MCState>();
        states.add(MCState.parseState(ERROR_STATE_IP));
        states.add(MCState.parseState(ERROR_STATE_1));
        return states;
    }

    @Test
    public void testInitNextWithNoError() throws Exception {
        this.writer.addInitNextDefinitions(TRIVIAL_TWO_STATE_DEADLOCK_INIT, TRIVIAL_TWO_STATE_DEADLOCK_NEXT, "writerTestInit", "writerTextNext");
        this.concludeTest();
    }

    @Test
    public void testInitNextWithError() throws Exception {
        List<MCState> trace = this.generateStatesForDeadlockCondition();
        StringBuilder tempCFGBuffer = new StringBuilder();
        StringBuilder[] tlaBuffers = SpecTraceExpressionWriter.addInitNextToBuffers(tempCFGBuffer, trace, null, "STEWInit", "STEWNext", "STEWAC", TRIVIAL_TWO_STATE_DEADLOCK_NEXT[0], true);
        this.writer.appendContentToBuffers(tlaBuffers[0].toString(), tempCFGBuffer.toString());
        this.writer.addTraceFunction(trace);
        this.writer.appendContentToBuffers(tlaBuffers[1].toString(), null);
        this.concludeTest();
    }

    @Test
    public void testInitNextWithErrorAndTraceExpression() throws Exception {
        List<MCState> trace = this.generateStatesForDeadlockCondition();
        this.writer.addTraceFunction(trace);
        ArrayList<Formula> expressions = new ArrayList<Formula>();
        expressions.add(new Formula("ENABLED XIncr"));
        expressions.add(new Formula("y # 7"));
        TraceExpressionInformationHolder[] traceExpressions = this.writer.createAndAddVariablesAndDefinitions(expressions, "writerTestTraceExpressions");
        this.writer.addInitNext(trace, traceExpressions, "STEWInit", "STEWNext", "STEWAC", TRIVIAL_TWO_STATE_DEADLOCK_NEXT[0]);
        this.concludeTest();
    }

    @Test
    public void testMultilineTraceExpression() throws Exception {
        throw new Error("Unresolved compilation problem: \n\tThe method assertTrue(boolean) is undefined for the type SpecTraceExpressionWriterTest\n");
    }
}

