/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.io.Serializable;
import java.util.Vector;
import pcal.PCalLocation;
import pcal.Region;

public class MappingObject
implements Serializable {
    private static final long serialVersionUID = 8620480075506527787L;
    private int type;
    public static final int LEFT_PAREN = 0;
    public static final int RIGHT_PAREN = 1;
    public static final int BEGIN_TLATOKEN = 2;
    public static final int END_TLATOKEN = 3;
    public static final int SOURCE_TOKEN = 4;
    public static final int BREAK = 5;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public MappingObject(int type) {
        this.type = type;
    }

    public static void shiftMappingVector(Vector mvec, int shift) {
        int i = 0;
        while (i < mvec.size()) {
            Vector line = (Vector)mvec.elementAt(i);
            int j = 0;
            while (j < line.size()) {
                MappingObject obj;
                MappingObject mobj = (MappingObject)line.elementAt(j);
                if (mobj.type == 2) {
                    obj = (BeginTLAToken)mobj;
                    ((BeginTLAToken)obj).setColumn(((BeginTLAToken)obj).getColumn() + shift);
                } else if (mobj.type == 3) {
                    obj = (EndTLAToken)mobj;
                    ((EndTLAToken)obj).setColumn(((EndTLAToken)obj).getColumn() + shift);
                } else if (mobj.type == 4) {
                    obj = (SourceToken)mobj;
                    ((SourceToken)obj).setBeginColumn(((SourceToken)obj).getBeginColumn() + shift);
                    ((SourceToken)obj).setEndColumn(((SourceToken)obj).getEndColumn() + shift);
                }
                ++j;
            }
            ++i;
        }
    }

    public static void printMappingVector(Vector mvec) {
        int i = 0;
        while (i < mvec.size()) {
            Vector line = (Vector)mvec.elementAt(i);
            System.out.print("line " + i + ":");
            int j = 0;
            while (j < line.size()) {
                MappingObject mobj = (MappingObject)line.elementAt(j);
                System.out.print("  " + mobj.toString());
                ++j;
            }
            System.out.println("");
            ++i;
        }
    }

    public static void printMapping(MappingObject[][] mapping) {
        int i = 0;
        while (i < mapping.length) {
            MappingObject[] line = mapping[i];
            System.out.print("line " + i + ":");
            int j = 0;
            while (j < line.length) {
                MappingObject mobj = line[j];
                System.out.print("  " + mobj.toString());
                ++j;
            }
            System.out.println("");
            ++i;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MappingObject other = (MappingObject)obj;
        return this.type == other.type;
    }

    public static class BeginTLAToken
    extends MappingObject {
        private static final long serialVersionUID = 3737867780161818714L;
        private int column;

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public BeginTLAToken(int column) {
            super(2);
            this.column = column;
        }

        public String toString() {
            return "[" + this.column;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.column;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BeginTLAToken other = (BeginTLAToken)obj;
            return this.column == other.column;
        }
    }

    public static class Break
    extends MappingObject {
        private static final long serialVersionUID = 3197403974334483558L;
        private int depth;

        public int getDepth() {
            return this.depth;
        }

        public Break(int depth) {
            super(5);
            this.depth = depth;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.depth;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Break other = (Break)obj;
            return this.depth == other.depth;
        }
    }

    public static class EndTLAToken
    extends MappingObject {
        private static final long serialVersionUID = -2173558662370032149L;
        private int column;

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public EndTLAToken(int column) {
            super(3);
            this.column = column;
        }

        public String toString() {
            return String.valueOf(this.column) + "]";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.column;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EndTLAToken other = (EndTLAToken)obj;
            return this.column == other.column;
        }
    }

    public static class LeftParen
    extends MappingObject {
        private static final long serialVersionUID = 5476753619018204229L;
        private PCalLocation location;

        public LeftParen(PCalLocation location) {
            super(0);
            this.location = location;
        }

        public String toString() {
            return "((-" + this.location.toString();
        }

        public PCalLocation getLocation() {
            return this.location;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LeftParen other = (LeftParen)obj;
            return !(this.location == null ? other.location != null : !this.location.equals(other.location));
        }
    }

    public static class RightParen
    extends MappingObject {
        private static final long serialVersionUID = 1313886393528667584L;
        private PCalLocation location;

        public RightParen(PCalLocation location) {
            super(1);
            this.location = location;
        }

        public String toString() {
            return String.valueOf(this.location.toString()) + "-))";
        }

        public PCalLocation getLocation() {
            return this.location;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RightParen other = (RightParen)obj;
            return !(this.location == null ? other.location != null : !this.location.equals(other.location));
        }
    }

    public static class SourceToken
    extends MappingObject {
        private static final long serialVersionUID = 6438346684127312114L;
        private int beginColumn;
        private int endColumn;
        private Region origin;

        public int getBeginColumn() {
            return this.beginColumn;
        }

        public void setBeginColumn(int beginColumn) {
            this.beginColumn = beginColumn;
        }

        public int getEndColumn() {
            return this.endColumn;
        }

        public void setEndColumn(int endColumn) {
            this.endColumn = endColumn;
        }

        public Region getOrigin() {
            return this.origin;
        }

        public SourceToken(int beginCol, int endCol, Region origin) {
            super(4);
            this.setBeginColumn(beginCol);
            this.setEndColumn(endCol);
            this.origin = origin;
        }

        public String toString() {
            return "((-" + this.origin.getBegin().toString() + "[" + this.beginColumn + "--" + this.endColumn + "]" + this.origin.getEnd().toString() + "-))";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.beginColumn;
            result = 31 * result + this.endColumn;
            result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceToken other = (SourceToken)obj;
            if (this.beginColumn != other.beginColumn) {
                return false;
            }
            if (this.endColumn != other.endColumn) {
                return false;
            }
            return !(this.origin == null ? other.origin != null : !this.origin.equals(other.origin));
        }
    }
}

