/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.util.Random;
import tlc2.tool.FingerprintException;
import tlc2.tool.coverage.CostModel;
import tlc2.util.FP64;
import tlc2.value.IMVPerm;
import tlc2.value.IStringValue;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.TLCVariable;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;
import util.UniqueString;

public class StringValue
extends Value {
    public final UniqueString val;

    public StringValue(String str) {
        this.val = UniqueString.uniqueStringOf(str);
    }

    public StringValue(UniqueString var) {
        this.val = var;
    }

    public StringValue(UniqueString var, CostModel cm) {
        this(var);
        this.cm = cm;
    }

    @Override
    public final byte getKind() {
        return 3;
    }

    public final UniqueString getVal() {
        return this.val;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            if (obj instanceof StringValue) {
                return this.val.compareTo(((StringValue)obj).val);
            }
            if (obj instanceof IStringValue) {
                return this.val.compareTo(((IStringValue)obj).getUniqueString());
            }
            if (!(obj instanceof ModelValue)) {
                Assert.fail("Attempted to compare string " + Values.ppr(this.toString()) + " with non-string:\n" + Values.ppr(obj.toString()), this.getSource());
            }
            return ((ModelValue)obj).modelValueCompareTo(this);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (obj instanceof StringValue) {
                return this.val.equals(((StringValue)obj).getVal());
            }
            if (obj instanceof IStringValue) {
                return this.val.equals(((IStringValue)obj).getUniqueString());
            }
            if (!(obj instanceof ModelValue)) {
                Assert.fail("Attempted to check equality of string " + Values.ppr(this.toString()) + " with non-string:\n" + Values.ppr(obj.toString()), this.getSource());
            }
            return ((ModelValue)obj).modelValueEquals(this);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if the value:\n" + Values.ppr(elem.toString()) + "\nis an element of the string " + Values.ppr(this.toString()), this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Assert.fail("Attempted to check if the string " + Values.ppr(this.toString()) + " is a finite set.", this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT construct to the string " + Values.ppr(this.toString()) + ".", this.getSource());
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT construct to the string " + Values.ppr(this.toString()) + ".", this.getSource());
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            Assert.fail("Attempted to compute the number of elements in the string " + Values.ppr(this.toString()) + ".", this.getSource());
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public boolean mutates() {
        return false;
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final Value normalize() {
        return this;
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    public final int length() {
        try {
            return this.val.length();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public void write(IValueOutputStream vos) throws IOException {
        int index = vos.put(this);
        if (index == -1) {
            vos.writeByte((byte)3);
            this.val.write(vos.getOutputStream());
        } else {
            vos.writeByte((byte)26);
            vos.writeNat(index);
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            fp = FP64.Extend(fp, (byte)3);
            fp = FP64.Extend(fp, this.val.length());
            fp = FP64.Extend(fp, this.val.toString());
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        return this;
    }

    final String PrintVersion(String str) {
        try {
            StringBuffer buf = new StringBuffer(str.length());
            int i = 0;
            while (i < str.length()) {
                switch (str.charAt(i)) {
                    case '\"': {
                        buf.append("\\\"");
                        break;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        break;
                    }
                    case '\t': {
                        buf.append("\\t");
                        break;
                    }
                    case '\n': {
                        buf.append("\\n");
                        break;
                    }
                    case '\f': {
                        buf.append("\\f");
                        break;
                    }
                    case '\r': {
                        buf.append("\\r");
                        break;
                    }
                    default: {
                        buf.append(str.charAt(i));
                    }
                }
                ++i;
            }
            return buf.toString();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public TLCVariable toTLCVariable(TLCVariable variable, Random rnd) {
        TLCVariable stringVar = super.toTLCVariable(variable, rnd);
        stringVar.setValue(this.toUnquotedString());
        return stringVar;
    }

    @Override
    public StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            return sb.append("\"" + this.PrintVersion(this.val.toString()) + "\"");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final String toUnquotedString() {
        return this.PrintVersion(this.val.toString());
    }

    public static IValue createFrom(IValueInputStream vos) throws IOException {
        UniqueString str = UniqueString.read(vos.getInputStream());
        StringValue res = new StringValue(str);
        int index = vos.getIndex();
        vos.assign(res, index);
        return res;
    }

    public static IValue createFromExternal(IValueInputStream vos) throws IOException {
        UniqueString str = UniqueString.readExternal(vos.getInputStream());
        StringValue res = new StringValue(str);
        int index = vos.getIndex();
        vos.assign(res, index);
        return res;
    }
}

