/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import tlc2.util.FP64;
import tlc2.value.RandomEnumerableValues;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.ValueVec;

@State(value=Scope.Benchmark)
public class SetEnumValueBenchmark {
    @Param(value={"10", "12", "14", "16"})
    public int numOfElements;
    @Param(value={"16", "18", "20", "22"})
    public int size;
    public Enumerable setEnumValue;

    static {
        RandomEnumerableValues.setSeed(15041980L);
        RandomEnumerableValues.reset();
        FP64.Init();
    }

    private static ValueVec getValues(int from, int to) {
        ValueVec vec = new ValueVec(to - from);
        int i = from;
        while (i <= to) {
            vec.addElement(IntValue.gen(i));
            ++i;
        }
        return vec;
    }

    @Setup(value=Level.Invocation)
    public void setup() {
        this.setEnumValue = (Enumerable)((Object)new SetEnumValue(SetEnumValueBenchmark.getValues(1, 1 << this.size), false).normalize());
    }

    @Benchmark
    public Enumerable randomSubset() {
        return this.setEnumValue.getRandomSubset(1 << this.numOfElements);
    }
}

