/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Objects;

public final class ChildFirstClassLoader
extends URLClassLoader {
    private static final String[] PARENT_FIRST_PREFIXES = new String[]{"java.", "javax.", "jdk.", "sun.", "com.sun.", "org.w3c.", "org.xml."};
    private static final String[] CHILD_FIRST_PREFIXES = new String[]{"tlc2.", "tla2sany.", "pcal.", "model.", "util.", "org.lamport."};

    public ChildFirstClassLoader(URL[] urls, ClassLoader parent) {
        super(Objects.requireNonNull(urls, "urls"), Objects.requireNonNull(parent, "parent"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                if (ChildFirstClassLoader.shouldLoadChildFirst(name)) {
                    try {
                        clazz = this.findClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (clazz == null) {
                    return super.loadClass(name, resolve);
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    private static boolean shouldLoadChildFirst(String className) {
        String prefix;
        String[] stringArray = PARENT_FIRST_PREFIXES;
        int n = PARENT_FIRST_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            prefix = stringArray[n2];
            if (className.startsWith(prefix)) {
                return false;
            }
            ++n2;
        }
        stringArray = CHILD_FIRST_PREFIXES;
        n = CHILD_FIRST_PREFIXES.length;
        n2 = 0;
        while (n2 < n) {
            prefix = stringArray[n2];
            if (className.startsWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

