/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.simulation;

import java.io.File;
import java.io.IOException;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import tla2sany.modanalyzer.SpecObj;
import tlc2.tool.Simulator;
import tlc2.util.RandomGenerator;
import util.SimpleFilenameToStream;
import util.ToolIO;

@State(value=Scope.Benchmark)
public class SimulatorBenchmark {
    @Param(value={"1", "2", "3", "4", "5", "6"})
    public int nWorkers;
    Simulator simulator;
    SpecObj specObj;
    RandomGenerator rng = new RandomGenerator(0L);
    long seed = 0L;

    @Setup
    public void up() throws IOException {
        ToolIO.setUserDir("test-model" + File.separator + "simulation" + File.separator + "BenchmarkSpec");
    }

    @Setup(value=Level.Iteration)
    public void reseedIter() {
        ++this.seed;
        this.rng.setSeed(this.seed);
    }

    @Setup(value=Level.Trial)
    public void reseed() {
        this.rng.setSeed(0L);
        this.seed = 0L;
    }

    public void simulatorBenchmark(int nWorkers) {
        try {
            int maxTraceDepth = 20;
            Simulator simulator = new Simulator("BenchmarkSpec", "MCInv", null, false, maxTraceDepth, Long.MAX_VALUE, this.rng, 0L, new SimpleFilenameToStream(), nWorkers);
            simulator.simulate();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void SimulatorWorkers() {
        this.simulatorBenchmark(this.nWorkers);
    }
}

