/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateVec;
import tlc2.tool.WorkerException;
import tlc2.tool.distributed.DistApp;
import tlc2.tool.distributed.InternRMI;
import tlc2.tool.distributed.NextStateResult;
import tlc2.tool.distributed.RMIFilenameToStreamResolver;
import tlc2.tool.distributed.TLCApp;
import tlc2.tool.distributed.TLCServer;
import tlc2.tool.distributed.TLCServerRMI;
import tlc2.tool.distributed.TLCTimerTask;
import tlc2.tool.distributed.TLCWorkerRMI;
import tlc2.tool.distributed.fp.IFPSetManager;
import tlc2.util.BitVector;
import tlc2.util.Cache;
import tlc2.util.FP64;
import tlc2.util.LongVec;
import tlc2.util.SimpleCache;
import util.Assert;
import util.ToolIO;
import util.UniqueString;

public class TLCWorker
extends UnicastRemoteObject
implements TLCWorkerRMI {
    private static final boolean unsorted = Boolean.getBoolean(String.valueOf(TLCWorker.class.getName()) + ".unsorted");
    private static Timer keepAliveTimer;
    private static RMIFilenameToStreamResolver fts;
    private static final ExecutorService executorService;
    private static TLCWorkerRunnable[] runnables;
    private static volatile CountDownLatch cdl;
    private DistApp work;
    private IFPSetManager fpSetManager;
    private final URI uri;
    private volatile boolean computing = false;
    private long lastInvocation;
    private long overallStatesComputed;
    private final Cache cache;

    static {
        executorService = Executors.newCachedThreadPool();
        runnables = new TLCWorkerRunnable[0];
    }

    public TLCWorker(int threadId, DistApp work, IFPSetManager fpSetManager, String aHostname) throws RemoteException {
        this.work = work;
        this.fpSetManager = fpSetManager;
        this.uri = URI.create("rmi://" + aHostname + ":" + this.getPort() + "/" + threadId);
        this.cache = new SimpleCache();
    }

    private Set<Holder> getSet() {
        if (unsorted) {
            return new HashSet<Holder>();
        }
        return new TreeSet<Holder>();
    }

    @Override
    public synchronized NextStateResult getNextStates(TLCState[] states) throws WorkerException, RemoteException {
        this.computing = true;
        this.lastInvocation = System.currentTimeMillis();
        long statesComputed = 0L;
        TLCState state1 = null;
        TLCState state2 = null;
        try {
            Set<Holder> treeSet = this.getSet();
            int i = 0;
            while (i < states.length) {
                state1 = states[i];
                TLCState[] nstates = this.work.getNextStates(state1);
                statesComputed += (long)nstates.length;
                int j = 0;
                while (j < nstates.length) {
                    long fp = nstates[j].fingerPrint();
                    if (!this.cache.hit(fp)) {
                        treeSet.add(new Holder(fp, nstates[j], state1));
                    }
                    ++j;
                }
                ++i;
            }
            this.overallStatesComputed += statesComputed;
            int fpServerCnt = this.fpSetManager.numOfServers();
            TLCStateVec[] pvv = new TLCStateVec[fpServerCnt];
            TLCStateVec[] nvv = new TLCStateVec[fpServerCnt];
            LongVec[] fpvv = new LongVec[fpServerCnt];
            int i2 = 0;
            while (i2 < fpServerCnt) {
                pvv[i2] = new TLCStateVec();
                nvv[i2] = new TLCStateVec();
                fpvv[i2] = new LongVec();
                ++i2;
            }
            long last = Long.MIN_VALUE;
            for (Holder holder : treeSet) {
                long fp = holder.getFp();
                Assert.check(last < fp, 1000);
                last = fp;
                int fpIndex = this.fpSetManager.getFPSetIndex(fp);
                pvv[fpIndex].addElement(holder.getParentState());
                nvv[fpIndex].addElement(holder.getNewState());
                fpvv[fpIndex].addElement(fp);
            }
            BitVector[] visited = this.fpSetManager.containsBlock(fpvv, executorService);
            TLCStateVec[] newStates = new TLCStateVec[fpServerCnt];
            LongVec[] newFps = new LongVec[fpServerCnt];
            int i3 = 0;
            while (i3 < fpServerCnt) {
                newStates[i3] = new TLCStateVec();
                newFps[i3] = new LongVec();
                ++i3;
            }
            i3 = 0;
            while (i3 < fpServerCnt) {
                int index;
                BitVector.Iter iter = new BitVector.Iter(visited[i3]);
                while ((index = iter.next()) != -1) {
                    state1 = pvv[i3].elementAt(index);
                    state2 = nvv[i3].elementAt(index);
                    this.work.checkState(state1, state2);
                    if (!this.work.isInModel(state2) || !this.work.isInActions(state1, state2)) continue;
                    state2.uid = state1.uid;
                    newStates[i3].addElement(state2);
                    newFps[i3].addElement(fpvv[i3].elementAt(index));
                }
                ++i3;
            }
            long computationTime = System.currentTimeMillis() - this.lastInvocation;
            NextStateResult nextStateResult = new NextStateResult(newStates, newFps, computationTime, statesComputed);
            return nextStateResult;
        }
        catch (WorkerException e) {
            throw e;
        }
        catch (OutOfMemoryError e) {
            throw new RemoteException("OutOfMemoryError occurred at worker: " + this.uri.toASCIIString(), e);
        }
        catch (RejectedExecutionException e) {
            throw new RemoteException("Executor rejected task at worker: " + this.uri.toASCIIString(), e);
        }
        catch (Throwable e) {
            throw new WorkerException(e.getMessage(), e, state1, state2, true);
        }
        finally {
            this.computing = false;
        }
    }

    @Override
    public void exit() throws NoSuchObjectException {
        ToolIO.out.println(String.valueOf(this.uri.getHost()) + ", work completed at: " + new Date() + " Computed: " + this.overallStatesComputed + " and a cache hit ratio of " + this.cache.getHitRatioAsString() + ", Thank you!");
        executorService.shutdown();
        keepAliveTimer.cancel();
        UnicastRemoteObject.unexportObject(this, true);
        cdl.countDown();
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    @Override
    public URI getURI() throws RemoteException {
        return this.uri;
    }

    @Override
    public double getCacheRateRatio() throws RemoteException {
        return this.cache.getHitRatio();
    }

    private int getPort() {
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            Class<?> unicastRefClass = cl.loadClass("sun.rmi.server.UnicastRef");
            Method method = unicastRefClass.getMethod("getLiveRef", null);
            Object liveRef = method.invoke((Object)this.getRef(), null);
            Class<?> liveRefClass = cl.loadClass("sun.rmi.transport.LiveRef");
            method = liveRefClass.getMethod("getPort", null);
            return (Integer)method.invoke(liveRef, null);
        }
        catch (SecurityException e) {
            MP.printError(1000, "trying to get a port for a worker", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            MP.printError(1000, "trying to get a port for a worker", (Throwable)e);
        }
        catch (ClassCastException e) {
            MP.printError(1000, "trying to get a port for a worker", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            MP.printError(7005, e);
        }
        catch (IllegalAccessException e) {
            MP.printError(7005, e);
        }
        catch (InvocationTargetException e) {
            MP.printError(7005, e);
        }
        catch (ClassNotFoundException e) {
            MP.printError(7005, e);
        }
        return 0;
    }

    long getLastInvocation() {
        return this.lastInvocation;
    }

    boolean isComputing() {
        return this.computing;
    }

    public static void main(String[] args) {
        ToolIO.out.println("TLC Worker " + TLCGlobals.versionOfTLC);
        if (args.length != 1) {
            TLCWorker.printErrorMsg("Error: Missing hostname of the TLC server to be contacted.");
            return;
        }
        String serverName = args[0];
        int numCores = Integer.getInteger(String.valueOf(TLCWorker.class.getName()) + ".threadCount", Runtime.getRuntime().availableProcessors());
        cdl = new CountDownLatch(numCores);
        try {
            String url = "//" + serverName + ":" + TLCServer.Port + "/" + "TLCServerWORKER";
            int i = 1;
            TLCServerRMI server = null;
            while (true) {
                try {
                    server = (TLCServerRMI)Naming.lookup(url);
                }
                catch (java.rmi.ConnectException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ConnectException) {
                        long sleep = (long)Math.sqrt(i);
                        ToolIO.out.println("Server " + serverName + " unreachable, sleeping " + sleep + "s for server to come online...");
                        Thread.sleep(sleep * 1000L);
                        i *= 2;
                        continue;
                    }
                    throw e;
                }
                catch (NotBoundException e) {
                    long sleep = (long)Math.sqrt(i);
                    ToolIO.out.println("Server " + serverName + " reachable but not ready yet, sleeping " + sleep + "s for server to come online...");
                    Thread.sleep(sleep * 1000L);
                    i *= 2;
                    continue;
                }
                break;
            }
            long irredPoly = server.getIrredPolyForFP();
            FP64.Init(irredPoly);
            UniqueString.setSource((InternRMI)((Object)server));
            if (fts == null) {
                fts = new RMIFilenameToStreamResolver();
            }
            fts.setTLCServer(server);
            TLCApp work = new TLCApp(server.getSpecFileName(), server.getConfigFileName(), server.getCheckDeadlock(), fts);
            IFPSetManager fpSetManager = server.getFPSetManager();
            runnables = new TLCWorkerRunnable[numCores];
            int j = 0;
            while (j < numCores) {
                TLCWorker.runnables[j] = new TLCWorkerRunnable(j, server, fpSetManager, work);
                Thread t = new Thread((Runnable)runnables[j], "TLCWorkerThread-" + String.format("%03d", j));
                t.start();
                ++j;
            }
            keepAliveTimer = new Timer("TLCWorker KeepAlive Timer", true);
            keepAliveTimer.schedule((TimerTask)new TLCTimerTask(keepAliveTimer, runnables, url), 10000L, 60000L);
            ToolIO.out.println("TLC worker with " + numCores + " threads ready at: " + new Date());
        }
        catch (Throwable e) {
            MP.printError(1000, e);
            ToolIO.out.println("Error: Failed to start worker  for server " + serverName + ".\n" + e.getMessage());
        }
        ToolIO.out.flush();
    }

    private static void printErrorMsg(String msg) {
        ToolIO.out.println(msg);
        ToolIO.out.println("Usage: java " + TLCWorker.class.getName() + " host");
    }

    public static void setFilenameToStreamResolver(RMIFilenameToStreamResolver aFTS) {
        fts = aFTS;
    }

    public static void shutdown() {
        if (keepAliveTimer != null) {
            keepAliveTimer.cancel();
        }
        int i = 0;
        while (i < runnables.length) {
            TLCWorker worker = runnables[i].getTLCWorker();
            try {
                if (worker != null) {
                    worker.exit();
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            ++i;
        }
        fts = null;
        runnables = new TLCWorkerRunnable[0];
    }

    public static void awaitTermination() throws InterruptedException {
        cdl.await();
        Thread.sleep(10000L);
    }

    public static class Holder
    implements Comparable<Holder> {
        private final long fp;
        private final TLCState successor;
        private final TLCState predecessor;

        public Holder(long fp, TLCState successor, TLCState predecessor) {
            this.fp = fp;
            this.successor = successor;
            this.predecessor = predecessor;
        }

        public long getFp() {
            return this.fp;
        }

        public TLCState getNewState() {
            return this.successor;
        }

        public TLCState getParentState() {
            return this.predecessor;
        }

        @Override
        public int compareTo(Holder o) {
            return this.fp < o.fp ? -1 : (this.fp == o.fp ? 0 : 1);
        }
    }

    public static class TLCWorkerRunnable
    implements Runnable {
        private final TLCServerRMI aServer;
        private final IFPSetManager anFpSetManager;
        private final DistApp aWork;
        private TLCWorker worker;
        private final int threadId;

        public TLCWorkerRunnable(int threadId, TLCServerRMI aServer, IFPSetManager anFpSetManager, DistApp aWork) {
            this.threadId = threadId;
            this.aServer = aServer;
            this.anFpSetManager = anFpSetManager;
            this.aWork = aWork;
        }

        @Override
        public void run() {
            try {
                this.worker = new TLCWorker(this.threadId, this.aWork, this.anFpSetManager, InetAddress.getLocalHost().getCanonicalHostName());
                this.aServer.registerWorker(this.worker);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public TLCWorker getTLCWorker() {
            return this.worker;
        }
    }
}

