/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import tla2sany.semantic.SymbolNode;
import tlc2.tool.Action;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.impl.FastTool;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.IValue;
import tlc2.value.impl.Value;
import util.FilenameToStream;
import util.SimpleFilenameToStream;

public class TLAPlusExecutor {
    private final ReentrantLock lock = new ReentrantLock();
    private final FastTool tool;
    private TLCState state;

    public TLAPlusExecutor(String spec2, String config) {
        this.tool = new FastTool(spec2, config, (FilenameToStream)new SimpleFilenameToStream(), Tool.Mode.Executor);
        this.state = this.tool.getInitStates().first();
    }

    public Mapping map(String actionName, String processNode, IValue v, String ... params) {
        Action[] actions;
        Action[] actionArray = actions = this.tool.getActions();
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            Object lookup;
            Action action = actionArray[n2];
            if (action.getName().equals(actionName) && (lookup = action.con.lookup(s -> s.getName().equals(processNode))) != null && lookup.equals(v)) {
                return new Mapping(action, params);
            }
            ++n2;
        }
        throw new RuntimeException("failed to create mapping");
    }

    public Object step(Mapping m) throws Exception {
        Context ctx = m.getContext();
        this.lock.lock();
        try {
            Object result;
            do {
                StateVec nextStates = this.tool.getNextStates(m.action, ctx, this.state);
                assert (!nextStates.isEmpty());
                this.state = nextStates.first();
                int k = 0;
                while (k < this.tool.getInvariants().length) {
                    if (!this.tool.isValid(this.tool.getInvariants()[k], this.state)) {
                        throw new INextStateFunctor.InvariantViolatedException();
                    }
                    ++k;
                }
            } while ((result = this.state.execCallable()) == null);
            Object object = result;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public Value getConstant(String string) {
        return (Value)this.tool.getSpecProcessor().getDefns().get(string);
    }

    public class Mapping {
        private final Action action;
        private final Map<SymbolNode, IValue> params;
        private final Map<String, SymbolNode> symbol2node;

        public Mapping(Action a, String ... params) {
            this.action = a;
            this.params = new HashMap<SymbolNode, IValue>();
            this.symbol2node = new HashMap<String, SymbolNode>();
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                SymbolNode node = this.action.con.lookupName(s -> s.getName().equals(param));
                this.symbol2node.put(param, node);
                ++n2;
            }
        }

        public Mapping set(String param, IValue value) {
            SymbolNode node = this.symbol2node.get(param);
            this.params.put(node, value);
            return this;
        }

        public Context getContext() {
            Context ctx = this.action.con;
            for (Map.Entry<SymbolNode, IValue> entry : this.params.entrySet()) {
                ctx = ctx.cons(entry.getKey(), entry.getValue());
            }
            return ctx;
        }
    }
}

