/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.debug.Variable;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.Location;
import tla2sany.st.TreeNode;
import tlc2.debug.IDebugTarget;
import tlc2.debug.TLCDebugger;
import tlc2.debug.TLCSourceBreakpoint;
import tlc2.debug.TLCStackFrame;
import tlc2.debug.TLCStateStackFrame;
import tlc2.tool.Action;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.TLCState;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.impl.RecordValue;

public class TLCSuccessorsStackFrame
extends TLCStateStackFrame {
    private final transient INextStateFunctor fun;
    private final transient Action a;
    private IDebugTarget.StepDirection step = IDebugTarget.StepDirection.Continue;
    public static final String SCOPE = "Successors";

    @Override
    protected String getScope() {
        return SCOPE;
    }

    public TLCSuccessorsStackFrame(TLCStackFrame parent, OpDefNode node, Context ctxt, Tool tool, TLCState s, Action a, INextStateFunctor fun) {
        super(parent, (SemanticNode)node, ctxt, tool, s);
        this.a = a;
        this.fun = fun;
        this.setName(node.toString());
    }

    @Override
    protected boolean addT() {
        return true;
    }

    @Override
    Variable[] getStateVariables() {
        return new Variable[]{this.toVariable()};
    }

    @Override
    public Variable[] getVariables(int vr) {
        if (vr == this.stateId) {
            return this.tool.eval(() -> {
                Set<TLCState> aSteps = this.getSuccessors();
                Variable[] vars = new Variable[aSteps.size()];
                Iterator<TLCState> itr = aSteps.iterator();
                int i = 0;
                while (i < vars.length) {
                    TLCState t = itr.next();
                    RecordValue r = new RecordValue(t);
                    vars[i] = this.getStateAsVariable(r, String.valueOf(t.getLevel()) + "." + (i + 1) + ": " + (t.hasAction() ? t.getAction().getLocation() : "<???>"));
                    ++i;
                }
                return vars;
            });
        }
        return super.getVariables(vr);
    }

    Set<TLCState> getSuccessors() {
        return this.fun.getStates().getSubSet(this.a);
    }

    @Override
    protected boolean hasScope() {
        return !this.getSuccessors().isEmpty();
    }

    @Override
    public boolean matches(TLCSourceBreakpoint bp) {
        if (this.node.getTreeNode() != null && this.node.getTreeNode().one() != null && this.node.getTreeNode().one().length > 0) {
            TreeNode[] one = this.node.getTreeNode().one();
            Location location = one[0].getLocation();
            int hits = bp.getHits();
            return bp.getLine() == location.beginLine() && location.beginColumn() <= bp.getColumnAsInt() && bp.getColumnAsInt() <= location.endColumn() && !this.getSuccessors().isEmpty() && this.getSuccessors().size() >= hits && this.matchesExpression(bp, true);
        }
        return false;
    }

    @Override
    public boolean handle(TLCDebugger debugger) {
        return debugger.stack.size() == 1;
    }

    @Override
    public CompletableFuture<Void> stepOver(TLCDebugger debugger) {
        this.step = IDebugTarget.StepDirection.Over;
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> stepOut(TLCDebugger debugger) {
        this.step = IDebugTarget.StepDirection.Out;
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> reverseContinue(TLCDebugger debugger) {
        this.step = IDebugTarget.StepDirection.Out;
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    public IDebugTarget.StepDirection getDirection() {
        return this.step;
    }
}

