/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.HashSet;
import java.util.Set;
import tla2sany.semantic.SemanticNode;

public class StandardModules {
    private static final Set<String> STANDARD_MODULES = new HashSet<String>();

    static {
        STANDARD_MODULES.add("FiniteSets");
        STANDARD_MODULES.add("Sequences");
        STANDARD_MODULES.add("Bags");
        STANDARD_MODULES.add("Naturals");
        STANDARD_MODULES.add("Integers");
        STANDARD_MODULES.add("Reals");
        STANDARD_MODULES.add("RealTime");
        STANDARD_MODULES.add("Randomization");
        STANDARD_MODULES.add("TLC");
    }

    private StandardModules() {
    }

    public static boolean isDefinedInStandardModule(SemanticNode sn) {
        if (sn != null && sn.getLocation() != null) {
            return StandardModules.isDefinedInStandardModule(sn.getLocation().source());
        }
        return false;
    }

    public static boolean isDefinedInStandardModule(String moduleName) {
        return STANDARD_MODULES.contains(moduleName);
    }

    public static void filterNonStandardModulesFromSet(Set<String> listOfModules) {
        listOfModules.retainAll(STANDARD_MODULES);
    }
}

