/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.Errors;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public class DefStepNode
extends LevelNode {
    private UniqueString stepNumber;
    private OpDefNode[] defs;

    public DefStepNode(TreeNode stn, UniqueString stepNum, OpDefNode[] theDefs) {
        super(36, stn);
        this.stepNumber = stepNum;
        this.defs = theDefs;
    }

    public UniqueString getStepNumber() {
        return this.stepNumber;
    }

    public OpDefNode[] getDefs() {
        return this.defs;
    }

    @Override
    public boolean levelCheck(int iter, Errors errors) {
        return this.levelCheckSubnodes(iter, this.defs, errors);
    }

    @Override
    public void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        int i = 0;
        while (i < this.defs.length) {
            this.defs[i].walkGraph(semNodesTable, visitor);
            ++i;
        }
        visitor.postVisit(this);
    }

    @Override
    public SemanticNode[] getChildren() {
        SemanticNode[] res = new SemanticNode[this.defs.length];
        int i = 0;
        while (i < this.defs.length) {
            res[i] = this.defs[i];
            ++i;
        }
        return res;
    }

    @Override
    public String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*DefStepNode:\n" + super.toString(depth, errors) + Strings.indent(2, "\ndefs:");
        int i = 0;
        while (i < this.defs.length) {
            ret = String.valueOf(ret) + Strings.indent(4, this.defs[i].toString(depth - 1, errors));
            ++i;
        }
        return ret;
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element e = doc.createElement("DefStepNode");
        int i = 0;
        while (i < this.defs.length) {
            e.appendChild(this.defs[i].export(doc, context, filter));
            ++i;
        }
        return e;
    }
}

