/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SetOfArgLevelConstraints;
import tla2sany.semantic.SetOfLevelConstraints;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;

public class AssumeNode
extends LevelNode {
    ModuleNode module;
    ExprNode assumeExpr;
    private ThmOrAssumpDefNode def;
    private boolean isAxiom = false;
    int levelChecked = 0;

    public boolean getIsAxiom() {
        return this.isAxiom;
    }

    public AssumeNode(TreeNode stn, ExprNode expr, ModuleNode mn, ThmOrAssumpDefNode opd) {
        super(20, stn);
        this.assumeExpr = expr;
        this.module = mn;
        this.def = opd;
        if (stn.heirs()[0].getImage().equals("AXIOM")) {
            this.isAxiom = true;
        }
        if (opd != null) {
            opd.thmOrAssump = this;
        }
    }

    public final ExprNode getAssume() {
        return this.assumeExpr;
    }

    public final ThmOrAssumpDefNode getDef() {
        return this.def;
    }

    @Override
    public final boolean levelCheck(int iter, Errors errors) {
        if (this.levelChecked >= iter) {
            return true;
        }
        this.levelChecked = iter;
        boolean res = this.assumeExpr.levelCheck(iter, errors);
        if (this.def != null) {
            boolean bl = res = this.def.levelCheck(iter, errors) && res;
        }
        if (this.assumeExpr.getLevel() != 0) {
            errors.addError(ErrorCode.ASSUMPTION_IS_NOT_CONSTANT, this.getTreeNode().getLocation(), "Level error: assumptions must be level 0 (Constant), \nbut this one has level " + this.getLevel() + ".");
        }
        if (res) {
            AssumeNode.addTemporalLevelConstraintToConstants(this.levelParams, this.levelConstraints);
        }
        return res;
    }

    @Override
    public final int getLevel() {
        return this.assumeExpr.getLevel();
    }

    @Override
    public final HashSet<SymbolNode> getLevelParams() {
        return this.assumeExpr.getLevelParams();
    }

    @Override
    public final HashSet<SymbolNode> getAllParams() {
        return this.assumeExpr.getAllParams();
    }

    @Override
    public final SetOfLevelConstraints getLevelConstraints() {
        return this.assumeExpr.getLevelConstraints();
    }

    @Override
    public final SetOfArgLevelConstraints getArgLevelConstraints() {
        return this.assumeExpr.getArgLevelConstraints();
    }

    @Override
    public final HashSet<ArgLevelParam> getArgLevelParams() {
        return this.assumeExpr.getArgLevelParams();
    }

    @Override
    public final String levelDataToString() {
        return "Level: " + this.getLevel() + "\n" + "LevelParameters: " + this.getLevelParams() + "\n" + "LevelConstraints: " + this.getLevelConstraints() + "\n" + "ArgLevelConstraints: " + this.getArgLevelConstraints() + "\n" + "ArgLevelParams: " + this.getArgLevelParams() + "\n";
    }

    @Override
    public final String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        String res = Strings.indent(2, "\n*AssumeNode " + super.toString(depth, errors) + (this.assumeExpr != null ? Strings.indent(2, this.assumeExpr.toString(depth - 1, errors)) : ""));
        if (this.def != null) {
            res = String.valueOf(res) + Strings.indent(4, "\n def: " + Strings.indent(2, this.def.toString(depth - 1, errors)));
        }
        return res;
    }

    @Override
    public SemanticNode[] getChildren() {
        return new SemanticNode[]{this.assumeExpr};
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.assumeExpr != null) {
            this.assumeExpr.walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    public Element exportDefinition(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        if (!context.isTop_level_entry()) {
            throw new IllegalArgumentException("Exporting theorem ref " + this.getNodeRef() + " twice!");
        }
        context.resetTop_level_entry();
        try {
            Element e = this.getLevelElement(doc, context, filter);
            try {
                Element l = this.appendText(doc, "level", Integer.toString(this.getLevel()));
                e.insertBefore(l, e.getFirstChild());
            }
            catch (RuntimeException l) {
                // empty catch block
            }
            try {
                Element loc = this.getLocationElement(doc);
                e.insertBefore(loc, e.getFirstChild());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return e;
        }
        catch (RuntimeException ee) {
            System.err.println("failed for node.toString(): " + this.toString() + "\n with error ");
            ee.printStackTrace();
            throw ee;
        }
    }

    protected String getNodeRef() {
        return "AssumeNodeRef";
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element e = doc.createElement("AssumeNode");
        if (this.def != null) {
            Element d = doc.createElement("definition");
            d.appendChild(this.def.export(doc, context, filter));
            e.appendChild(d);
            assert (this.def.getBody() == this.assumeExpr);
        }
        Element n = doc.createElement("body");
        n.appendChild(this.getAssume().export(doc, context, filter));
        e.appendChild(n);
        return e;
    }

    @Override
    public Element export(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        context.put(this, doc, filter);
        Element e = doc.createElement(this.getNodeRef());
        e.appendChild(this.appendText(doc, "UID", Integer.toString(this.myUID)));
        return e;
    }
}

