/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.output;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import tla2sany.output.LogLevel;
import tla2sany.output.SanyOutput;
import tla2sany.output.SilentSanyOutput;

public class RecordedSanyOutput
implements SanyOutput {
    private final List<Message> messages = new ArrayList<Message>();
    private final LogLevel logLevel;

    public RecordedSanyOutput(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void log(LogLevel level, String format, Object ... args) {
        if (level.ordinal() >= this.logLevel.ordinal()) {
            this.messages.add(new Message(level, format, args));
        }
    }

    @Override
    public PrintStream getStream(LogLevel level) {
        if (level.ordinal() >= this.logLevel.ordinal()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.messages.add(new Message(level, stream));
            return new PrintStream(stream);
        }
        return SilentSanyOutput.NullOutputStream;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Message msg : this.messages) {
            sb.append(msg.toString());
        }
        return sb.toString();
    }

    public static class Message {
        private final LogLevel level;
        private final String format;
        private final Object[] args;
        private final ByteArrayOutputStream stream;

        public Message(LogLevel level, String format, Object ... args) {
            this.level = level;
            this.format = format;
            this.args = args;
            this.stream = null;
        }

        public Message(LogLevel level, ByteArrayOutputStream stream) {
            this.level = level;
            this.format = null;
            this.args = null;
            this.stream = stream;
        }

        public LogLevel getLevel() {
            return this.level;
        }

        public String getText() {
            return String.valueOf(this.stream == null ? String.format(this.format, this.args) : this.stream.toString()) + '\n';
        }

        public String toString() {
            return this.getText();
        }
    }
}

