/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.explorer;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.Context;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.Subst;
import util.FileUtil;

public class DotExplorerVisitor
extends ExplorerVisitor {
    private static final Map<Class<? extends SemanticNode>, String> type2format = new HashMap<Class<? extends SemanticNode>, String>();
    private final ModuleNode rootModule;
    private final Hashtable<Integer, ExploreNode> table;
    private final PrintWriter writer;
    private final Deque<ExploreNode> stack = new ArrayDeque<ExploreNode>();
    private final boolean includeLineNumbers = Boolean.getBoolean(String.valueOf(DotExplorerVisitor.class.getName()) + ".includeLineNumbers");

    static {
        type2format.put(OpDefNode.class, " [style=filled,shape=diamond,fillcolor=\"red\",");
        type2format.put(OpApplNode.class, " [color=\"green\",");
        type2format.put(OpDeclNode.class, " [shape=square,color=\"yellow\",");
        type2format.put(LetInNode.class, " [color=\"orange\",");
    }

    public DotExplorerVisitor(ModuleNode rootModule) {
        this.rootModule = rootModule;
        this.table = new NoopTable<Integer, ExploreNode>();
        try {
            this.writer = new PrintWriter(FileUtil.newBFOS(rootModule.getName() + ".dot"));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.writer.append("strict digraph DiskGraph {\n");
    }

    @Override
    public void preVisit(ExploreNode exploreNode) {
        if (DotExplorerVisitor.skipNode(exploreNode)) {
            return;
        }
        ExploreNode parent = this.stack.peek();
        if (exploreNode == this.rootModule) {
            assert (parent == null);
            ModuleNode mn = (ModuleNode)exploreNode;
            this.writer.append(Integer.toString(mn.hashCode()));
            this.writer.append(" [label=\"");
            this.writer.append(mn.getName().toString());
            this.writer.append("\",style = filled]");
            this.writer.append(";\n");
            this.stack.push(exploreNode);
        } else {
            SemanticNode sn = (SemanticNode)exploreNode;
            this.writer.append(Integer.toString(sn.hashCode()));
            this.writer.append(String.valueOf(type2format.getOrDefault(exploreNode.getClass(), " [")) + "label=\"");
            if (exploreNode instanceof OpDefNode) {
                this.writer.append(DotExplorerVisitor.toDot(((OpDefNode)sn).getName().toString()));
            } else {
                this.writer.append(DotExplorerVisitor.toDot(sn.getTreeNode().getHumanReadableImage()));
            }
            if (this.includeLineNumbers) {
                String loc = sn.getLocation().toString();
                this.writer.append("\n");
                this.writer.append(loc.replace("of module", "\n"));
                this.writer.append("\n" + sn.getClass().getSimpleName());
            }
            this.writer.append("\"]");
            this.writer.append(";\n");
            this.writer.append(Integer.toString(parent.hashCode()));
            this.writer.append(" -> ");
            this.writer.append(Integer.toString(sn.hashCode()));
            this.writer.append("\n");
            this.stack.push(sn);
        }
    }

    @Override
    public void postVisit(ExploreNode exploreNode) {
        if (DotExplorerVisitor.skipNode(exploreNode)) {
            return;
        }
        ExploreNode pop = this.stack.pop();
        assert (pop == exploreNode);
    }

    public void done() {
        this.writer.append("}");
        this.writer.close();
    }

    public Hashtable<Integer, ExploreNode> getTable() {
        return this.table;
    }

    private static String toDot(String sn) {
        return sn.replace("\\", "\\\\").replace("\"", "\\\"").trim().replace("\n", "\\n");
    }

    private static boolean skipNode(ExploreNode exploreNode) {
        if (exploreNode instanceof Context || exploreNode instanceof FormalParamNode) {
            return true;
        }
        if (exploreNode instanceof Subst) {
            return true;
        }
        if (Context.isBuiltIn(exploreNode)) {
            return true;
        }
        if (exploreNode instanceof SemanticNode) {
            return ((SemanticNode)exploreNode).isStandardModule();
        }
        return false;
    }

    private class NoopTable<K, V>
    extends Hashtable<K, V> {
        private NoopTable() {
        }

        @Override
        public V get(Object key) {
            OpDefNode odn;
            Object v = super.get(key);
            if (v instanceof OpDefNode && (odn = (OpDefNode)v).getInRecursive() && DotExplorerVisitor.this.stack.contains(odn)) {
                return v;
            }
            return null;
        }
    }
}

