/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.api;

import java.util.ArrayList;
import java.util.List;
import tla2sany.api.DependencyTable;
import tla2sany.api.Frontend;
import tla2sany.api.ModuleSourceCode;
import tla2sany.api.ModuleSyntaxTree;
import tla2sany.api.Resolver;
import tla2sany.output.SanyOutput;
import tla2sany.output.SilentSanyOutput;
import tla2sany.parser.ParseException;
import tla2sany.parser.TLAplusParser;
import tla2sany.parser.TokenMgrError;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.Context;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.Generator;
import tla2sany.semantic.ModuleNode;
import tla2sany.st.Location;
import util.ToolIO;
import util.UniqueString;

public class SANYFrontend
implements Frontend {
    @Override
    public ExternalModuleTable parse(String rootModuleName, Resolver resolver, Errors log) throws TokenMgrError, ParseException, AbortException {
        ModuleSyntaxTree syntaxRoot = this.processSyntax(rootModuleName, resolver);
        DependencyTable dependenciesRoot = this.resolveDependencies(syntaxRoot, resolver, log);
        ExternalModuleTable modules = this.processSemantics(dependenciesRoot, log);
        if (log.isFailure()) {
            ToolIO.err.println(log.toString());
            return null;
        }
        boolean levelOk = this.checkLevel(modules, log);
        if (!levelOk || log.isFailure()) {
            ToolIO.err.println(log.toString());
            return null;
        }
        return modules;
    }

    @Override
    public ModuleSyntaxTree processSyntax(String moduleName, Resolver resolver) throws TokenMgrError, ParseException {
        ModuleSourceCode source = resolver.resolve(moduleName);
        TLAplusParser parser = new TLAplusParser((SanyOutput)new SilentSanyOutput(), source.text);
        return new ModuleSyntaxTree(source, parser.CompilationUnit());
    }

    @Override
    public DependencyTable resolveDependencies(ModuleSyntaxTree root, Resolver resolver, Errors log) throws TokenMgrError, ParseException, AbortException {
        DependencyTable dependencyTable = new DependencyTable(root);
        ArrayList<String> incompleteModules = new ArrayList<String>();
        incompleteModules.add(root.getModuleName());
        this.resolveDependencies(root.getModuleName(), dependencyTable, resolver, log, incompleteModules);
        return dependencyTable;
    }

    private void resolveDependencies(String moduleName, DependencyTable dependencyTable, Resolver resolver, Errors log, List<String> incompleteModules) throws TokenMgrError, ParseException, AbortException {
        ModuleSyntaxTree module = dependencyTable.modules.get(moduleName);
        List<String> dependencies = module.getDependencies();
        dependencyTable.dependencies.put(module.getModuleName(), dependencies);
        for (String dependencyName : dependencies) {
            if (incompleteModules.contains(dependencyName)) {
                throw log.addMessage(ErrorCode.MODULE_DEPENDENCIES_ARE_CIRCULAR, Location.nullLoc, "Circular dependency detected", new Object[0]);
            }
            if (dependencyTable.modules.containsKey(dependencyName)) continue;
            ModuleSyntaxTree dependency = this.processSyntax(dependencyName, resolver);
            dependencyTable.modules.put(dependency.getModuleName(), dependency);
            ArrayList<String> incompleteModulesNext = new ArrayList<String>(incompleteModules);
            incompleteModulesNext.add(dependencyName);
            this.resolveDependencies(dependencyName, dependencyTable, resolver, log, incompleteModulesNext);
        }
    }

    @Override
    public ExternalModuleTable processSemantics(DependencyTable dependencyTable, Errors log) throws AbortException {
        Context.reInit();
        ExternalModuleTable mt = new ExternalModuleTable();
        ModuleNode root = this.processSemantics(dependencyTable.rootModuleName, dependencyTable, log, mt);
        mt.setRootModule(root);
        return mt;
    }

    private ModuleNode processSemantics(String moduleName, DependencyTable dependencyTable, Errors log, ExternalModuleTable mt) throws AbortException {
        for (String dependencyName : dependencyTable.dependencies.get(moduleName)) {
            if (mt.getModuleNode(dependencyName) != null) continue;
            this.processSemantics(dependencyName, dependencyTable, log, mt);
        }
        Generator gen = new Generator(mt, log);
        ModuleSyntaxTree parseTree = dependencyTable.modules.get(moduleName);
        ModuleNode semanticRoot = gen.generate(parseTree.root);
        mt.put(UniqueString.of(moduleName), gen.getSymbolTable().getExternalContext(), semanticRoot);
        return semanticRoot;
    }

    @Override
    public boolean checkLevel(ExternalModuleTable mt, Errors log) {
        boolean levelOk = mt.getRootModule().levelCheck(log);
        return levelOk && log.isSuccess();
    }
}

