/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.net.URL;
import util.ResourceLocator;

class ClasspathResourceLocator
implements ResourceLocator {
    private final ClassLoader classLoader;
    private final String prefix;

    public ClasspathResourceLocator(ClassLoader classLoader, String prefix) {
        while (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        this.classLoader = classLoader;
        this.prefix = prefix;
    }

    @Override
    public URL locate(String filename) throws IOException {
        return this.classLoader.getResource(this.prefix.isEmpty() ? filename : String.valueOf(this.prefix) + "/" + filename);
    }

    @Override
    public String describeSearchLocations() {
        return "classpath:/" + this.prefix;
    }
}

