/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import tlc2.util.FP64;
import tlc2.value.RandomEnumerableValues;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.SubsetValue;

@State(value=Scope.Benchmark)
public class SubsetValueBenchmark {
    private static final SubsetValue subset35;
    private static final SubsetValue subset60;
    private static final SubsetValue subset100;
    private static final SubsetValue subset200;
    private static final SubsetValue subset300;
    private static final SubsetValue subset400;
    private static final int k = 80000;
    private static final double d = 0.1;
    private static final int k2 = 160000;
    private static final double d2 = 0.2;

    static {
        RandomEnumerableValues.setSeed(15041980L);
        RandomEnumerableValues.reset();
        FP64.Init();
        subset35 = new SubsetValue(new IntervalValue(1, 35));
        subset35.normalize();
        subset60 = new SubsetValue(new IntervalValue(1, 60));
        subset60.normalize();
        subset100 = new SubsetValue(new IntervalValue(1, 100));
        subset100.normalize();
        subset200 = new SubsetValue(new IntervalValue(1, 200));
        subset200.normalize();
        subset300 = new SubsetValue(new IntervalValue(1, 300));
        subset300.normalize();
        subset400 = new SubsetValue(new IntervalValue(1, 400));
        subset400.normalize();
    }

    @Benchmark
    public Enumerable probabilisticN035k80d01() {
        return subset35.getRandomSetOfSubsets(80000, 0.1);
    }

    @Benchmark
    public Enumerable probabilisticN060k80d01() {
        return subset60.getRandomSetOfSubsets(80000, 0.1);
    }

    @Benchmark
    public Enumerable probabilisticN100k80d01() {
        return subset100.getRandomSetOfSubsets(80000, 0.1);
    }

    @Benchmark
    public Enumerable probabilisticN200k80d01() {
        return subset200.getRandomSetOfSubsets(80000, 0.1);
    }

    @Benchmark
    public Enumerable probabilisticN300k80d01() {
        return subset300.getRandomSetOfSubsets(80000, 0.1);
    }

    @Benchmark
    public Enumerable probabilisticN400k80d01() {
        return subset400.getRandomSetOfSubsets(80000, 0.1);
    }

    @Benchmark
    public Enumerable probabilisticN035k16d01() {
        return subset35.getRandomSetOfSubsets(160000, 0.1);
    }

    @Benchmark
    public Enumerable probabilisticN060k16d01() {
        return subset60.getRandomSetOfSubsets(160000, 0.1);
    }

    @Benchmark
    public Enumerable probabilisticN100k16d01() {
        return subset100.getRandomSetOfSubsets(160000, 0.1);
    }

    @Benchmark
    public Enumerable probabilisticN200k16d01() {
        return subset200.getRandomSetOfSubsets(160000, 0.1);
    }

    @Benchmark
    public Enumerable probabilisticN300k16d01() {
        return subset300.getRandomSetOfSubsets(160000, 0.1);
    }

    @Benchmark
    public Enumerable probabilisticN400k16d01() {
        return subset400.getRandomSetOfSubsets(160000, 0.1);
    }

    @Benchmark
    public Enumerable probabilisticN035k80d02() {
        return subset35.getRandomSetOfSubsets(80000, 0.2);
    }

    @Benchmark
    public Enumerable probabilisticN060k80d02() {
        return subset60.getRandomSetOfSubsets(80000, 0.2);
    }

    @Benchmark
    public Enumerable probabilisticN100k80d02() {
        return subset100.getRandomSetOfSubsets(80000, 0.2);
    }

    @Benchmark
    public Enumerable probabilisticN200k80d02() {
        return subset200.getRandomSetOfSubsets(80000, 0.2);
    }

    @Benchmark
    public Enumerable probabilisticN300k80d02() {
        return subset300.getRandomSetOfSubsets(80000, 0.2);
    }

    @Benchmark
    public Enumerable probabilisticN400k80d02() {
        return subset400.getRandomSetOfSubsets(80000, 0.2);
    }

    @Benchmark
    public Enumerable probabilisticN035k16d02() {
        return subset35.getRandomSetOfSubsets(160000, 0.2);
    }

    @Benchmark
    public Enumerable probabilisticN060k16d02() {
        return subset60.getRandomSetOfSubsets(160000, 0.2);
    }

    @Benchmark
    public Enumerable probabilisticN100k16d02() {
        return subset100.getRandomSetOfSubsets(160000, 0.2);
    }

    @Benchmark
    public Enumerable probabilisticN200k16d02() {
        return subset200.getRandomSetOfSubsets(160000, 0.2);
    }

    @Benchmark
    public Enumerable probabilisticN300k16d02() {
        return subset300.getRandomSetOfSubsets(160000, 0.2);
    }

    @Benchmark
    public Enumerable probabilisticN400k16d02() {
        return subset400.getRandomSetOfSubsets(160000, 0.2);
    }

    @Benchmark
    public Enumerable exactN035K08() {
        return subset35.getRandomSetOfSubsets(80000, 8);
    }

    @Benchmark
    public Enumerable exactN035K13() {
        return subset35.getRandomSetOfSubsets(80000, 13);
    }

    @Benchmark
    public Enumerable exactN060K08() {
        return subset60.getRandomSetOfSubsets(80000, 8);
    }

    @Benchmark
    public Enumerable exactN100K08() {
        return subset100.getRandomSetOfSubsets(80000, 8);
    }

    @Benchmark
    public Enumerable exactN100K10() {
        return subset100.getRandomSetOfSubsets(80000, 10);
    }

    @Benchmark
    public Enumerable exactN200K10() {
        return subset200.getRandomSetOfSubsets(80000, 10);
    }

    @Benchmark
    public Enumerable exactN300K09() {
        return subset300.getRandomSetOfSubsets(80000, 9);
    }

    @Benchmark
    public Enumerable exactN400K09() {
        return subset400.getRandomSetOfSubsets(80000, 9);
    }

    @Benchmark
    public Enumerable exactN035K208() {
        return subset35.getRandomSetOfSubsets(160000, 8);
    }

    @Benchmark
    public Enumerable exactN035K213() {
        return subset35.getRandomSetOfSubsets(160000, 13);
    }

    @Benchmark
    public Enumerable exactN060K208() {
        return subset60.getRandomSetOfSubsets(160000, 8);
    }

    @Benchmark
    public Enumerable exactN100K208() {
        return subset100.getRandomSetOfSubsets(160000, 8);
    }

    @Benchmark
    public Enumerable exactN100K210() {
        return subset100.getRandomSetOfSubsets(160000, 10);
    }

    @Benchmark
    public Enumerable exactN200K210() {
        return subset200.getRandomSetOfSubsets(160000, 10);
    }

    @Benchmark
    public Enumerable exactN300K209() {
        return subset300.getRandomSetOfSubsets(160000, 9);
    }

    @Benchmark
    public Enumerable exactN400K209() {
        return subset400.getRandomSetOfSubsets(160000, 9);
    }
}

