/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.math.BigInteger;
import tlc2.TLCGlobals;
import tlc2.tool.FingerprintException;
import tlc2.tool.coverage.CostModel;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.SetOfFcnsOrRcdsValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;
import util.UniqueString;

public class SetOfRcdsValue
extends SetOfFcnsOrRcdsValue
implements Enumerable {
    public final UniqueString[] names;
    public final Value[] values;
    protected SetEnumValue rcdSet;

    public SetOfRcdsValue(UniqueString[] names, Value[] values, boolean isNorm) {
        assert (names.length == values.length);
        this.names = names;
        this.values = values;
        this.rcdSet = null;
        if (!isNorm) {
            this.sortByNames();
        }
    }

    public SetOfRcdsValue(UniqueString[] names, Value[] values, boolean isNorm, CostModel cm) {
        this(names, values, isNorm);
        this.cm = cm;
    }

    @Override
    public final byte getKind() {
        return 14;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            this.convertAndCache();
            return this.rcdSet.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean equals(Object obj) {
        try {
            if (!(obj instanceof SetOfRcdsValue)) {
                this.convertAndCache();
                return this.rcdSet.equals(obj);
            }
            SetOfRcdsValue rcds = (SetOfRcdsValue)obj;
            boolean isEmpty1 = this.isEmpty();
            if (isEmpty1) {
                return rcds.isEmpty();
            }
            if (rcds.isEmpty()) {
                return isEmpty1;
            }
            if (this.names.length != rcds.names.length) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= this.names.length) {
                    return true;
                }
                if (!this.names[i].equals(rcds.names[i]) || !this.values[i].equals(rcds.values[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean member(Value elem) {
        try {
            RecordValue rcd = (RecordValue)elem.toRcd();
            if (rcd == null) {
                if (elem instanceof ModelValue) {
                    return ((ModelValue)elem).modelValueMember(this);
                }
                Assert.fail("Attempted to check if non-record\n" + elem + "\nis in the" + " set of records:\n" + Values.ppr(this.toString()), this.getSource());
            }
            rcd.normalize();
            if (this.names.length != rcd.names.length) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= this.names.length) {
                    return true;
                }
                if (!this.names[i].equals(rcd.names[i]) || !this.values[i].member(rcd.values[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean isFinite() {
        try {
            int i = 0;
            while (true) {
                if (i >= this.values.length) {
                    return true;
                }
                if (!this.values[i].isFinite()) {
                    return false;
                }
                ++i;
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT to the set of records:\n" + Values.ppr(this.toString()), this.getSource());
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT to the set of records:\n" + Values.ppr(this.toString()), this.getSource());
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            long sz = 1L;
            int i = 0;
            while (i < this.values.length) {
                if ((sz *= (long)this.values[i].size()) < Integer.MIN_VALUE || sz > Integer.MAX_VALUE) {
                    Assert.fail(2178, "the number of elements in:\n" + Values.ppr(this.toString()));
                }
                ++i;
            }
            return (int)sz;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    protected boolean needBigInteger() {
        long sz = 1L;
        int i = 0;
        while (i < this.values.length) {
            if ((sz *= (long)this.values[i].size()) < Integer.MIN_VALUE || sz > Integer.MAX_VALUE) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean isNormalized() {
        try {
            if (this.rcdSet != null && this.rcdSet != SetEnumValue.DummyEnum) {
                return this.rcdSet.isNormalized();
            }
            int i = 0;
            while (true) {
                if (i >= this.names.length) {
                    return true;
                }
                if (!this.values[i].isNormalized()) {
                    return false;
                }
                ++i;
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.rcdSet == null || this.rcdSet == SetEnumValue.DummyEnum) {
                int i = 0;
                while (i < this.names.length) {
                    this.values[i].normalize();
                    ++i;
                }
            } else {
                this.rcdSet.normalize();
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            int i = 0;
            while (i < this.values.length) {
                this.values[i].deepNormalize();
                ++i;
            }
            if (this.rcdSet == null) {
                this.rcdSet = SetEnumValue.DummyEnum;
            } else if (this.rcdSet != SetEnumValue.DummyEnum) {
                this.rcdSet.deepNormalize();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private final void sortByNames() {
        int i = 1;
        while (i < this.names.length) {
            int cmp = this.names[0].compareTo(this.names[i]);
            if (cmp == 0) {
                Assert.fail("Field name " + this.names[0] + " occurs multiple times" + " in set of records.", this.getSource());
            } else if (cmp > 0) {
                UniqueString ts = this.names[0];
                this.names[0] = this.names[i];
                this.names[i] = ts;
                Value tv = this.values[0];
                this.values[0] = this.values[i];
                this.values[i] = tv;
            }
            ++i;
        }
        i = 2;
        while (i < this.names.length) {
            int cmp;
            int j = i;
            UniqueString st = this.names[i];
            Value val = this.values[i];
            while ((cmp = st.compareTo(this.names[j - 1])) < 0) {
                this.names[j] = this.names[j - 1];
                this.values[j] = this.values[j - 1];
                --j;
            }
            if (cmp == 0) {
                Assert.fail("Field name " + this.names[i] + " occurs multiple times" + " in set of records.", this.getSource());
            }
            this.names[j] = st;
            this.values[j] = val;
            ++i;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            boolean isDefined = true;
            int i = 0;
            while (i < this.values.length) {
                isDefined = isDefined && this.values[i].isDefined();
                ++i;
            }
            return isDefined;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.convertAndCache();
            return this.rcdSet.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            this.convertAndCache();
            return this.rcdSet.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private final void convertAndCache() {
        if (this.rcdSet == null) {
            this.rcdSet = (SetEnumValue)this.toSetEnum();
        } else if (this.rcdSet == SetEnumValue.DummyEnum) {
            SetEnumValue val = (SetEnumValue)this.toSetEnum();
            val.deepNormalize();
            this.rcdSet = val;
        }
    }

    @Override
    public final Value toSetEnum() {
        Value elem;
        if (this.rcdSet != null && this.rcdSet != SetEnumValue.DummyEnum) {
            return this.rcdSet;
        }
        ValueVec vals = new ValueVec();
        ValueEnumeration Enum2 = this.elements();
        while ((elem = Enum2.nextElement()) != null) {
            vals.addElement(elem);
        }
        if (coverage) {
            this.cm.incSecondary(vals.size());
        }
        return new SetEnumValue(vals, this.isNormalized(), this.cm);
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        this.rcdSet.write(vos);
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            boolean unlazy = TLCGlobals.expand;
            try {
                if (unlazy) {
                    long sz = 1L;
                    int i = 0;
                    while (i < this.values.length) {
                        if ((sz *= (long)this.values[i].size()) < Integer.MIN_VALUE || sz > Integer.MAX_VALUE) {
                            unlazy = false;
                            break;
                        }
                        ++i;
                    }
                    unlazy = sz < (long)TLCGlobals.enumBound;
                }
            }
            catch (Throwable e) {
                if (swallow) {
                    unlazy = false;
                }
                throw e;
            }
            if (unlazy) {
                Value val = this.toSetEnum();
                return val.toString(sb, offset, swallow);
            }
            sb.append("[");
            int len = this.names.length;
            if (len != 0) {
                sb.append(this.names[0] + ": ");
                this.values[0].toString(sb, offset, swallow);
            }
            int i = 1;
            while (i < len) {
                sb.append(", ");
                sb.append(this.names[i] + ": ");
                this.values[i].toString(sb, offset, swallow);
                ++i;
            }
            sb.append("]");
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.rcdSet == null || this.rcdSet == SetEnumValue.DummyEnum) {
                return new Enumerator();
            }
            return this.rcdSet.elements();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    protected SetOfFcnsOrRcdsValue.SubsetEnumerator getSubsetEnumerator(int k, int n) {
        return new SubsetEnumerator(k, n);
    }

    @Override
    protected BigIntegerSubsetEnumerator getBigSubsetEnumerator(int k) {
        return new BigIntegerSubsetEnumerator(k);
    }

    class BigIntegerSubsetEnumerator
    extends SetOfFcnsOrRcdsValue.BigIntegerSubsetEnumerator {
        private final SetEnumValue[] convert;
        private final BigInteger[] rescaleBy;

        public BigIntegerSubsetEnumerator(int k) {
            super(k);
            this.convert = new SetEnumValue[SetOfRcdsValue.this.values.length];
            this.rescaleBy = new BigInteger[SetOfRcdsValue.this.values.length];
            BigInteger numElems = BigInteger.ONE;
            int i = SetOfRcdsValue.this.values.length - 1;
            while (i >= 0) {
                this.convert[i] = (SetEnumValue)SetOfRcdsValue.this.values[i].toSetEnum();
                this.rescaleBy[i] = numElems;
                numElems = numElems.multiply(BigInteger.valueOf(this.convert[i].elems.size()));
                --i;
            }
            this.sz = numElems;
        }

        @Override
        protected Value elementAt(BigInteger idx) {
            Value[] val = new Value[SetOfRcdsValue.this.names.length];
            int i = 0;
            while (i < val.length) {
                SetEnumValue sev = this.convert[i];
                int mod = sev.elems.size();
                BigInteger d = idx.divide(this.rescaleBy[i]);
                BigInteger m = d.mod(BigInteger.valueOf(mod));
                int elementAt = m.intValueExact();
                val[i] = sev.elems.elementAt(elementAt);
                ++i;
            }
            return new RecordValue(SetOfRcdsValue.this.names, val, false, SetOfRcdsValue.this.cm);
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        private ValueEnumeration[] enums;
        private Value[] currentElems;
        private boolean isDone;

        public Enumerator() {
            this.enums = new ValueEnumeration[SetOfRcdsValue.this.values.length];
            this.currentElems = new Value[SetOfRcdsValue.this.values.length];
            this.isDone = false;
            int i = 0;
            while (i < SetOfRcdsValue.this.values.length) {
                if (SetOfRcdsValue.this.values[i] instanceof Enumerable) {
                    this.enums[i] = ((Enumerable)((Object)SetOfRcdsValue.this.values[i])).elements();
                    this.currentElems[i] = this.enums[i].nextElement();
                    if (this.currentElems[i] == null) {
                        this.enums = null;
                        this.isDone = true;
                        break;
                    }
                } else {
                    Assert.fail("Attempted to enumerate a set of the form [l1 : v1, ..., ln : vn],\nbut can't enumerate the value of the `" + SetOfRcdsValue.this.names[i] + "' field:\n" + Values.ppr(SetOfRcdsValue.this.values[i].toString()), SetOfRcdsValue.this.getSource());
                }
                ++i;
            }
        }

        @Override
        public final void reset() {
            if (this.enums != null) {
                int i = 0;
                while (i < this.enums.length) {
                    this.enums[i].reset();
                    this.currentElems[i] = this.enums[i].nextElement();
                    ++i;
                }
                this.isDone = false;
            }
        }

        @Override
        public final Value nextElement() {
            if (this.isDone) {
                return null;
            }
            Value[] elems = new Value[this.currentElems.length];
            if (coverage) {
                SetOfRcdsValue.this.cm.incSecondary(elems.length);
            }
            int i = 0;
            while (i < elems.length) {
                elems[i] = this.currentElems[i];
                ++i;
            }
            i = elems.length - 1;
            while (i >= 0) {
                this.currentElems[i] = this.enums[i].nextElement();
                if (this.currentElems[i] != null) break;
                if (i == 0) {
                    this.isDone = true;
                    break;
                }
                this.enums[i].reset();
                this.currentElems[i] = this.enums[i].nextElement();
                --i;
            }
            return new RecordValue(SetOfRcdsValue.this.names, elems, true, SetOfRcdsValue.this.cm);
        }
    }

    class SubsetEnumerator
    extends SetOfFcnsOrRcdsValue.SubsetEnumerator {
        private final SetEnumValue[] convert;
        private final int[] rescaleBy;

        SubsetEnumerator(int k, int n) {
            super(k, n);
            this.convert = new SetEnumValue[SetOfRcdsValue.this.values.length];
            this.rescaleBy = new int[SetOfRcdsValue.this.values.length];
            int numElems = 1;
            int i = SetOfRcdsValue.this.values.length - 1;
            while (i >= 0) {
                this.convert[i] = (SetEnumValue)SetOfRcdsValue.this.values[i].toSetEnum();
                this.rescaleBy[i] = numElems;
                numElems *= this.convert[i].elems.size();
                --i;
            }
        }

        @Override
        protected RecordValue elementAt(int idx) {
            assert (idx >= 0 && idx < SetOfRcdsValue.this.size());
            Value[] val = new Value[SetOfRcdsValue.this.names.length];
            int i = 0;
            while (i < val.length) {
                SetEnumValue sev = this.convert[i];
                int mod = sev.elems.size();
                int rescaledIdx = (int)Math.floor(idx / this.rescaleBy[i]);
                int elementAt = rescaledIdx % mod;
                val[i] = sev.elems.elementAt(elementAt);
                ++i;
            }
            return new RecordValue(SetOfRcdsValue.this.names, val, false, SetOfRcdsValue.this.cm);
        }
    }
}

