/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import tlc2.util.MemBasedSet;
import util.BufferedDataInputStream;
import util.BufferedDataOutputStream;
import util.FileUtil;

public final class MemIntQueue
extends MemBasedSet {
    private static final int InitialSize = 4096;
    private int start = 0;
    private String diskdir;
    private String filename;

    public MemIntQueue(String metadir, String filename) {
        this(metadir, filename, 4096);
    }

    public MemIntQueue(String metadir, String filename, int initialCapacity) {
        super(initialCapacity);
        this.diskdir = metadir;
        this.filename = filename;
    }

    public final void enqueueInt(int elem) {
        if (this.size == this.elems.length) {
            int[] newElems = this.ensureCapacity(4096);
            int copyLen = this.elems.length - this.start;
            System.arraycopy(this.elems, this.start, newElems, 0, copyLen);
            System.arraycopy(this.elems, 0, newElems, copyLen, this.start);
            this.elems = newElems;
            this.start = 0;
        }
        int last = (this.start + this.size) % this.elems.length;
        this.elems[last] = elem;
        ++this.size;
    }

    public final void enqueueLong(long elem) {
        this.enqueueInt((int)(elem >>> 32));
        this.enqueueInt((int)(elem & 0xFFFFFFFFL));
    }

    public final int dequeueInt() {
        if (this.size < 1) {
            throw new NoSuchElementException();
        }
        int res = this.elems[this.start];
        --this.size;
        this.start = (this.start + 1) % this.elems.length;
        return res;
    }

    public final long dequeueLong() {
        long high = this.dequeueInt();
        long low = this.dequeueInt();
        return high << 32 | low & 0xFFFFFFFFL;
    }

    public int popInt() {
        if (this.size < 1) {
            throw new NoSuchElementException();
        }
        return this.elems[--this.size];
    }

    public long popLong() {
        long low = this.popInt();
        long high = this.popInt();
        return high << 32 | low & 0xFFFFFFFFL;
    }

    public final void beginChkpt() throws IOException {
        String tmpName = String.valueOf(this.diskdir) + FileUtil.separator + this.filename + ".tmp";
        BufferedDataOutputStream bos = new BufferedDataOutputStream(tmpName);
        bos.writeInt(this.size);
        int index = this.start;
        int i = 0;
        while (i < this.size) {
            bos.writeInt(this.elems[index++]);
            if (index == this.elems.length) {
                index = 0;
            }
            ++i;
        }
        bos.close();
    }

    public final void commitChkpt() throws IOException {
        String oldName = String.valueOf(this.diskdir) + FileUtil.separator + this.filename + ".chkpt";
        File oldChkpt = new File(oldName);
        String newName = String.valueOf(this.diskdir) + FileUtil.separator + this.filename + ".tmp";
        File newChkpt = new File(newName);
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            throw new IOException("MemStateQueue.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    public final void recover() throws IOException {
        String chkptName = String.valueOf(this.diskdir) + FileUtil.separator + this.filename + ".chkpt";
        BufferedDataInputStream bis = new BufferedDataInputStream(chkptName);
        this.size = bis.readInt();
        int i = 0;
        while (i < this.size) {
            this.elems[i] = bis.readInt();
            ++i;
        }
        bis.close();
    }

    public static class DetailedFormatter {
        public static String fpAndtidx(MemIntQueue aQueue) {
            StringBuffer buf = new StringBuffer(aQueue.size / 3);
            int i = 0;
            while (i < aQueue.size) {
                long fp = (long)aQueue.elems[i] << 32 | (long)aQueue.elems[i + 1] & 0xFFFFFFFFL;
                buf.append("fp: " + fp);
                buf.append(" tidx: " + aQueue.elems[i + 2]);
                buf.append("\n");
                i += 3;
            }
            return buf.toString();
        }

        public static String fpAndtidxAndptr(MemIntQueue aQueue) {
            StringBuffer buf = new StringBuffer(aQueue.size / 5);
            int i = 0;
            while (i < aQueue.size) {
                long fp = (long)aQueue.elems[i] << 32 | (long)aQueue.elems[i + 1] & 0xFFFFFFFFL;
                buf.append("fp: " + fp);
                buf.append(" tidx: " + aQueue.elems[i + 2]);
                long ptr = (long)aQueue.elems[i + 3] << 32 | (long)aQueue.elems[i + 4] & 0xFFFFFFFFL;
                buf.append(" ptr: " + ptr);
                buf.append("\n");
                i += 5;
            }
            return buf.toString();
        }
    }
}

