/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import tlc2.util.ObjectPoolStack;
import tlc2.util.ObjectStack;
import util.Assert;
import util.FileUtil;

public class DiskObjectStack
extends ObjectStack {
    private static final int BufSize = 8192;
    private final String filePrefix;
    protected Object[] buf1 = new Object[8192];
    protected Object[] buf2 = new Object[8192];
    protected Object[] buf = this.buf1;
    protected int index = 0;
    protected ObjectPoolStack diskStack;

    public DiskObjectStack(String diskdir, String name) {
        this.filePrefix = String.valueOf(diskdir) + FileUtil.separator + name;
        this.diskStack = new ObjectPoolStack(8192, this.filePrefix);
    }

    @Override
    final void enqueueInner(Object state) {
        if (this.index == 8192 && this.buf == this.buf2) {
            try {
                this.buf = this.diskStack.write(this.buf1);
                this.buf1 = this.buf2;
                this.buf2 = this.buf;
                this.index = 0;
            }
            catch (Exception e) {
                Assert.fail(2175, new String[]{"stack", e.getMessage()});
            }
        }
        this.buf[this.index++] = state;
    }

    @Override
    final Object dequeueInner() {
        if (this.buf == this.buf1 && this.index < 4096) {
            try {
                Object[] tempBuf = this.diskStack.read(this.buf);
                if (tempBuf != null) {
                    this.buf2 = this.buf1;
                    this.buf1 = tempBuf;
                    this.buf = this.buf2;
                }
            }
            catch (Exception e) {
                Assert.fail(2174, new String[]{"stack", e.getMessage()});
            }
        }
        return this.buf[--this.index];
    }

    @Override
    public final void beginChkpt() throws IOException {
        String filename = String.valueOf(this.filePrefix) + ".tmp";
        ObjectOutputStream oos = FileUtil.newOBFOS(filename);
        oos.writeInt(this.len);
        int index1 = this.buf == this.buf1 ? this.index : 8192;
        int index2 = this.buf == this.buf1 ? 0 : this.index;
        oos.writeInt(index1);
        oos.writeInt(index2);
        int i = 0;
        while (i < index1) {
            oos.writeObject(this.buf1[i]);
            ++i;
        }
        i = 0;
        while (i < index2) {
            oos.writeObject(this.buf2[i]);
            ++i;
        }
        oos.close();
    }

    @Override
    public final void commitChkpt() throws IOException {
        File oldChkpt = new File(String.valueOf(this.filePrefix) + ".chkpt");
        File newChkpt = new File(String.valueOf(this.filePrefix) + ".tmp");
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            String msg = "DiskObjectStack.commitChkpt: cannot delete " + oldChkpt;
            throw new IOException(msg);
        }
    }

    @Override
    public final void recover() throws IOException {
        int index2;
        int index1;
        block9: {
            String filename = String.valueOf(this.filePrefix) + ".chkpt";
            ObjectInputStream ois = FileUtil.newOBFIS(filename);
            this.len = ois.readInt();
            index1 = ois.readInt();
            index2 = ois.readInt();
            try {
                try {
                    int i = 0;
                    while (i < index1) {
                        this.buf1[i] = ois.readObject();
                        ++i;
                    }
                    i = 0;
                    while (i < index2) {
                        this.buf2[i] = ois.readObject();
                        ++i;
                    }
                }
                catch (ClassNotFoundException e) {
                    Assert.fail(2126, e.getMessage());
                    ois.close();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                ois.close();
                throw throwable;
            }
            ois.close();
        }
        if (index2 == 0) {
            this.buf = this.buf1;
            this.index = index1;
        } else {
            this.buf = this.buf2;
            this.index = index2;
        }
    }
}

