/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.queue;

import gov.nasa.jpf.util.test.TestJPF;
import java.io.IOException;
import org.junit.Test;
import tlc2.tool.TLCState;
import tlc2.tool.queue.DummyTLCState;
import tlc2.tool.queue.StateQueue;

public class StateQueueJPFTest
extends TestJPF {
    private final StateQueue queue = new DummyStateQueue();
    private final TLCState tlcState = new DummyTLCState();
    private final Thread mainThread = new Thread((Runnable)new MainTask(this.queue), "Main");
    private final Thread[] workerThreads = new Thread[3];

    public StateQueueJPFTest() {
        int i = 0;
        while (i < this.workerThreads.length) {
            this.workerThreads[i] = new Thread((Runnable)new WorkerTask(this.queue, this.tlcState), "Worker" + i);
            ++i;
        }
    }

    public static void main(String[] args) {
        new StateQueueJPFTest().test();
    }

    @Test
    public void test() {
        if (this.verifyNoPropertyViolation(new String[0])) {
            try {
                Thread worker;
                this.mainThread.start();
                Thread[] threadArray = this.workerThreads;
                int n = this.workerThreads.length;
                int n2 = 0;
                while (n2 < n) {
                    worker = threadArray[n2];
                    if (!worker.isAlive()) {
                        worker.start();
                    }
                    ++n2;
                }
                this.mainThread.join();
                threadArray = this.workerThreads;
                n = this.workerThreads.length;
                n2 = 0;
                while (n2 < n) {
                    worker = threadArray[n2];
                    worker.join();
                    ++n2;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class DummyStateQueue
    extends StateQueue {
        private TLCState state;

        private DummyStateQueue() {
        }

        @Override
        void enqueueInner(TLCState state) {
            this.state = state;
        }

        @Override
        TLCState dequeueInner() {
            return this.state;
        }

        @Override
        TLCState peekInner() {
            return this.state;
        }

        @Override
        public void beginChkpt() throws IOException {
        }

        @Override
        public void commitChkpt() throws IOException {
        }

        @Override
        public void recover() throws IOException {
        }
    }

    private static class MainTask
    implements Runnable {
        private final StateQueue queue;

        public MainTask(StateQueue queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            this.queue.suspendAll();
            this.queue.resumeAll();
        }
    }

    private static class WorkerTask
    implements Runnable {
        private final StateQueue queue;
        private final TLCState tlcState;

        public WorkerTask(StateQueue queue, TLCState tlcState) {
            this.queue = queue;
            this.tlcState = tlcState;
        }

        @Override
        public void run() {
            int i = 0;
            while (i < 3) {
                TLCState state = this.queue.dequeue();
                if (state == null) {
                    this.queue.finishAll();
                    return;
                }
                this.queue.enqueue(this.tlcState);
                ++i;
            }
            this.queue.finishAll();
        }
    }
}

