/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.liveness.LNAll;
import tlc2.tool.liveness.LNBool;
import tlc2.tool.liveness.LNConj;
import tlc2.tool.liveness.LNDisj;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.LNNeg;
import tlc2.tool.liveness.LNNext;
import tlc2.tool.liveness.LNState;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.TBParVec;
import tlc2.tool.liveness.TBTriple;
import tlc2.util.Vect;
import util.Assert;

public class TBPar
extends Vect<LiveExprNode> {
    TBPar() {
        super(0);
    }

    public TBPar(int i) {
        super(i);
    }

    public final LiveExprNode exprAt(int i) {
        return (LiveExprNode)this.elementAt(i);
    }

    public final boolean equals(TBPar par) {
        return this.contains(par) && par.contains(this);
    }

    final boolean member(LiveExprNode e) {
        int i = 0;
        while (i < this.size()) {
            if (e.equals(this.exprAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final boolean contains(TBPar par) {
        int i = 0;
        while (i < par.size()) {
            if (!this.member(par.exprAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final TBPar union(TBPar par) {
        TBPar res = new TBPar(this.size() + par.size());
        int i = 0;
        while (i < this.size()) {
            if (!par.member(this.exprAt(i))) {
                res.addElement(this.exprAt(i));
            }
            ++i;
        }
        i = 0;
        while (i < par.size()) {
            res.addElement(par.exprAt(i));
            ++i;
        }
        return res;
    }

    private final TBPar append(LiveExprNode ln) {
        TBPar res = new TBPar(this.size() + 1);
        int i = 0;
        while (i < this.size()) {
            res.addElement(this.exprAt(i));
            ++i;
        }
        res.addElement(ln);
        return res;
    }

    private final TBPar append(LiveExprNode ln1, LiveExprNode ln2) {
        TBPar res = new TBPar(this.size() + 2);
        int i = 0;
        while (i < this.size()) {
            res.addElement(this.exprAt(i));
            ++i;
        }
        res.addElement(ln1);
        res.addElement(ln2);
        return res;
    }

    public TBParVec particleClosure() {
        TBPar positive_closure = this.positiveClosure();
        Vect<TBTriple> alphas = positive_closure.alphaTriples();
        Vect<TBTriple> betas = positive_closure.betaTriples();
        return this.particleClosure(this, alphas, betas);
    }

    private TBParVec particleClosure(TBPar terms, Vect<TBTriple> alphas, Vect<TBTriple> betas) {
        boolean done;
        if (!terms.isLocallyConsistent()) {
            return new TBParVec(0);
        }
        TBPar terms1 = terms;
        int i = 0;
        while (i < terms1.size()) {
            LiveExprNode ln = terms1.exprAt(i);
            LiveExprNode kappa1 = null;
            LiveExprNode kappa2 = null;
            if (ln instanceof LNAll) {
                kappa1 = ((LNAll)ln).getBody();
                kappa2 = new LNNext(ln);
            } else if (ln instanceof LNConj) {
                kappa1 = ((LNConj)ln).getBody(0);
                kappa2 = ((LNConj)ln).getBody(1);
            }
            if (kappa1 != null) {
                if (terms1.member(kappa1)) {
                    if (!terms1.member(kappa2)) {
                        terms1 = terms1.append(kappa2);
                    }
                } else {
                    terms1 = terms1.member(kappa2) ? terms1.append(kappa1) : terms1.append(kappa1, kappa2);
                }
            }
            ++i;
        }
        do {
            done = true;
            int i2 = 0;
            while (i2 < alphas.size()) {
                TBTriple alpha = alphas.elementAt(i2);
                if (terms1.member(alpha.getB()) && terms1.member(alpha.getC()) && !terms1.member(alpha.getA())) {
                    terms1.addElement(alpha.getA());
                    done = false;
                }
                ++i2;
            }
        } while (!done);
        if (terms1.size() > terms.size() && !terms1.isLocallyConsistent()) {
            return new TBParVec(0);
        }
        return this.particleClosureBeta(terms1, alphas, betas);
    }

    private TBParVec particleClosureBeta(TBPar terms, Vect<TBTriple> alphas, Vect<TBTriple> betas) {
        int i = 0;
        while (i < terms.size()) {
            LiveExprNode ln = terms.exprAt(i);
            LiveExprNode kappa1 = null;
            LiveExprNode kappa2 = null;
            if (ln instanceof LNEven) {
                kappa1 = ((LNEven)ln).getBody();
                kappa2 = new LNNext(ln);
            } else if (ln instanceof LNDisj) {
                kappa1 = ((LNDisj)ln).getBody(0);
                kappa2 = ((LNDisj)ln).getBody(1);
            }
            if (kappa1 != null && !terms.member(kappa1) && !terms.member(kappa2)) {
                TBParVec ps1 = this.particleClosure(terms.append(kappa1), alphas, betas);
                TBParVec ps2 = this.particleClosure(terms.append(kappa2), alphas, betas);
                return ps1.union(ps2);
            }
            ++i;
        }
        i = 0;
        while (i < betas.size()) {
            TBTriple beta = betas.elementAt(i);
            if ((terms.member(beta.getB()) || terms.member(beta.getC())) && !terms.member(beta.getA())) {
                return this.particleClosure(terms.append(beta.getA()), alphas, betas);
            }
            ++i;
        }
        TBParVec res = new TBParVec(1);
        res.addElement(terms);
        return res;
    }

    private final Vect<TBTriple> alphaTriples() {
        Vect<TBTriple> ts = new Vect<TBTriple>();
        int i = 0;
        while (i < this.size()) {
            LiveExprNode ln = this.exprAt(i);
            if (ln instanceof LNAll) {
                ts.addElement(new TBTriple(ln, ((LNAll)ln).getBody(), new LNNext(ln)));
            } else if (ln instanceof LNConj) {
                LNConj lnc = (LNConj)ln;
                ts.addElement(new TBTriple(lnc, lnc.getBody(0), lnc.getBody(1)));
            }
            ++i;
        }
        return ts;
    }

    private final Vect<TBTriple> betaTriples() {
        Vect<TBTriple> ts = new Vect<TBTriple>();
        int i = 0;
        while (i < this.size()) {
            LiveExprNode ln = this.exprAt(i);
            if (ln instanceof LNEven) {
                ts.addElement(new TBTriple(ln, ((LNEven)ln).getBody(), new LNNext(ln)));
            } else if (ln instanceof LNDisj) {
                LNDisj lnd = (LNDisj)ln;
                ts.addElement(new TBTriple(lnd, lnd.getBody(0), lnd.getBody(1)));
            }
            ++i;
        }
        return ts;
    }

    private final boolean isLocallyConsistent() {
        TBPar pos = new TBPar(this.size());
        TBPar neg = new TBPar(this.size());
        int i = 0;
        while (i < this.size()) {
            LiveExprNode body;
            LiveExprNode ln = this.exprAt(i);
            if (ln instanceof LNState || ln instanceof LNBool) {
                pos.addElement(ln);
            } else if (ln instanceof LNNeg && ((body = ((LNNeg)ln).getBody()) instanceof LNState || body instanceof LNBool)) {
                neg.addElement(body);
            }
            ++i;
        }
        i = 0;
        while (i < pos.size()) {
            if (neg.member(pos.exprAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final TBPar positiveClosure() {
        TBPar tps = new TBPar(this.size() * 2);
        int i = 0;
        while (i < this.size()) {
            tps.addElement((LiveExprNode)this.elementAt(i));
            ++i;
        }
        TBPar result = new TBPar(this.size() * 2);
        while (tps.size() > 0) {
            int i2;
            LiveExprNode ln = tps.exprAt(tps.size() - 1);
            tps.removeLastElement();
            if (ln instanceof LNNeg) {
                tps.addElement(((LNNeg)ln).getBody());
                continue;
            }
            if (ln instanceof LNNext) {
                result.addElement(ln);
                tps.addElement(((LNNext)ln).getBody());
                continue;
            }
            if (ln instanceof LNEven) {
                result.addElement(ln);
                result.addElement(new LNNext(ln));
                tps.addElement(((LNEven)ln).getBody());
                continue;
            }
            if (ln instanceof LNAll) {
                result.addElement(ln);
                result.addElement(new LNNext(ln));
                tps.addElement(((LNAll)ln).getBody());
                continue;
            }
            if (ln instanceof LNConj) {
                LNConj lnc = (LNConj)ln;
                i2 = 0;
                while (i2 < lnc.getCount()) {
                    tps.addElement(lnc.getBody(i2));
                    ++i2;
                }
                result.addElement(ln);
                continue;
            }
            if (ln instanceof LNDisj) {
                LNDisj lnd = (LNDisj)ln;
                i2 = 0;
                while (i2 < lnd.getCount()) {
                    tps.addElement(lnd.getBody(i2));
                    ++i2;
                }
                result.addElement(ln);
                continue;
            }
            if (ln instanceof LNState) {
                result.addElement(ln);
                continue;
            }
            if (ln instanceof LNBool) {
                result.addElement(ln);
                continue;
            }
            Assert.fail(2249);
        }
        return result;
    }

    final TBPar impliedSuccessors() {
        TBPar successors = new TBPar(this.size());
        int i = 0;
        while (i < this.size()) {
            LiveExprNode ln = this.exprAt(i);
            if (ln instanceof LNNext) {
                successors.addElement(((LNNext)ln).getBody());
            }
            ++i;
        }
        return successors;
    }

    final boolean isFulfilling(LNEven promise) {
        return !this.member(promise) || this.member(promise.getBody());
    }

    public final void toString(StringBuffer sb, String padding) {
        sb.append("{");
        String padding1 = String.valueOf(padding) + " ";
        if (this.size() != 0) {
            ((LiveExprNode)this.elementAt(0)).toString(sb, padding1);
        }
        int i = 1;
        while (i < this.size()) {
            sb.append(",\n");
            sb.append(padding1);
            ((LiveExprNode)this.elementAt(i)).toString(sb, padding1);
            ++i;
        }
        sb.append("}");
    }

    @Override
    public final String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, "");
        return sb.toString();
    }

    public String toDotViz() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        if (this.size() != 0) {
            LiveExprNode liveExprNode = (LiveExprNode)this.elementAt(0);
            sb.append(liveExprNode.toDotViz());
        }
        int i = 1;
        while (i < this.size()) {
            sb.append(",\n");
            LiveExprNode liveExprNode = (LiveExprNode)this.elementAt(i);
            sb.append(liveExprNode.toDotViz());
            ++i;
        }
        sb.append("}");
        return sb.toString().replace("\\", "\\\\");
    }
}

