/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.BuiltInOPs;
import tlc2.tool.IContextEnumerator;
import tlc2.tool.ITool;
import tlc2.tool.Specs;
import tlc2.tool.TLCState;
import tlc2.tool.ToolGlobals;
import tlc2.tool.liveness.LNAction;
import tlc2.tool.liveness.LNAll;
import tlc2.tool.liveness.LNBool;
import tlc2.tool.liveness.LNConj;
import tlc2.tool.liveness.LNDisj;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.LNNeg;
import tlc2.tool.liveness.LNStateAST;
import tlc2.tool.liveness.LNStateEnabled;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.OrderOfSolution;
import tlc2.tool.liveness.PossibleErrorModel;
import tlc2.tool.liveness.TBGraph;
import tlc2.tool.liveness.TBPar;
import tlc2.util.Context;
import tlc2.util.Vect;
import tlc2.value.IBoolValue;
import tlc2.value.IFcnLambdaValue;
import tlc2.value.IValue;
import util.Assert;
import util.ToolIO;

public class Liveness
implements ToolGlobals,
ASTConstants {
    private static LiveExprNode astToLive(ITool tool, ExprNode expr, Context con, int level) {
        if (level == 0) {
            level = tool.getLevelBound(expr, con, tool.getId());
        }
        if (level == 0) {
            IValue val = tool.eval(expr, con, TLCState.Empty);
            if (!(val instanceof IBoolValue)) {
                Assert.fail(2215, new String[]{"boolean", expr.toString()});
            }
            return ((IBoolValue)val).getVal() ? LNBool.TRUE : LNBool.FALSE;
        }
        if (level == 1) {
            return new LNStateAST(expr, con);
        }
        return new LNAction(expr, con);
    }

    private static LiveExprNode astToLive(ITool tool, ExprNode expr, Context con) {
        switch (expr.getKind()) {
            case 9: {
                OpApplNode expr1 = (OpApplNode)expr;
                return Liveness.astToLiveAppl(tool, expr1, con);
            }
            case 10: {
                LetInNode expr1 = (LetInNode)expr;
                return Liveness.astToLive(tool, expr1.getBody(), con);
            }
            case 13: {
                SubstInNode expr1 = (SubstInNode)expr;
                Subst[] subs = expr1.getSubsts();
                int slen = subs.length;
                Context con1 = con;
                int i = 0;
                while (i < slen) {
                    Subst sub = subs[i];
                    con1 = con1.cons(sub.getOp(), tool.getVal(sub.getExpr(), con, false));
                    ++i;
                }
                return Liveness.astToLive(tool, expr1.getBody(), con1);
            }
            case 29: {
                LabelNode lbl = (LabelNode)expr;
                if (!(lbl.getBody() instanceof ExprNode)) {
                    Assert.fail(2213, expr.toString());
                }
                return Liveness.astToLive(tool, (ExprNode)lbl.getBody(), con);
            }
        }
        int level = Specs.getLevel(expr, con);
        if (level > 2) {
            Assert.fail(2213, expr.toString());
        }
        return Liveness.astToLive(tool, expr, con, level);
    }

    private static LiveExprNode astToLiveAppl(ITool tool, OpApplNode expr, Context con) {
        ExprOrOpArgNode[] args = expr.getArgs();
        int alen = args.length;
        SymbolNode opNode = expr.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            Object val = tool.lookup(opNode, con, false);
            if (val instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)val;
                opcode = BuiltInOPs.getOpCode(opDef.getName());
                if (opcode == 0) {
                    try {
                        FormalParamNode[] formals = opDef.getParams();
                        Context con1 = con;
                        int i = 0;
                        while (i < alen) {
                            IValue argVal = tool.eval(args[i], con, TLCState.Empty);
                            con1 = con1.cons(formals[i], argVal);
                            ++i;
                        }
                        LiveExprNode res = Liveness.astToLive(tool, opDef.getBody(), con1);
                        int level = res.getLevel();
                        if (level > 2) {
                            return res;
                        }
                        return Liveness.astToLive(tool, expr, con, level);
                    }
                    catch (Exception formals) {}
                }
            } else if (val instanceof IBoolValue) {
                return ((IBoolValue)val).getVal() ? LNBool.TRUE : LNBool.FALSE;
            }
            if (opcode == 0) {
                int level = Specs.getLevel(expr, con);
                if (level > 2) {
                    Assert.fail(2213, expr.toString());
                }
                return Liveness.astToLive(tool, expr, con, level);
            }
        }
        switch (opcode) {
            case 2: {
                IContextEnumerator Enum2;
                ExprNode body = (ExprNode)args[0];
                try {
                    Context con1;
                    Enum2 = tool.contexts(expr, con, TLCState.Empty, TLCState.Empty, 0);
                    LNDisj res = new LNDisj(0);
                    while ((con1 = Enum2.nextElement()) != null) {
                        LiveExprNode kid = Liveness.astToLive(tool, body, con1);
                        res.addDisj(kid);
                    }
                    if (res.getCount() == 0) {
                        return LNBool.FALSE;
                    }
                    int level = res.getLevel();
                    if (level > 2) {
                        return res;
                    }
                    return Liveness.astToLive(tool, expr, con, level);
                }
                catch (Exception e) {
                    int level = Specs.getLevel(expr, con);
                    if (level > 2) {
                        Assert.fail(2213, expr.toString());
                    }
                    return Liveness.astToLive(tool, expr, con, level);
                }
            }
            case 3: {
                IContextEnumerator Enum2;
                ExprNode body = (ExprNode)args[0];
                try {
                    Context con1;
                    Enum2 = tool.contexts(expr, con, TLCState.Empty, TLCState.Empty, 0);
                    LNConj res = new LNConj(0);
                    while ((con1 = Enum2.nextElement()) != null) {
                        LiveExprNode kid = Liveness.astToLive(tool, body, con1);
                        res.addConj(kid);
                    }
                    if (res.getCount() == 0) {
                        return LNBool.TRUE;
                    }
                    int level = res.getLevel();
                    if (level > 2) {
                        return res;
                    }
                    return Liveness.astToLive(tool, expr, con, level);
                }
                catch (Exception e) {
                    int level = Specs.getLevel(expr, con);
                    if (level > 2) {
                        if (e instanceof Assert.TLCRuntimeException) {
                            Assert.fail(2213, new String[]{expr.toString(), e.getMessage()});
                        } else {
                            Assert.fail(2213, expr.toString());
                        }
                    }
                    return Liveness.astToLive(tool, expr, con, level);
                }
            }
            case 6: 
            case 36: {
                LNConj lnConj = new LNConj(alen);
                int i = 0;
                while (i < alen) {
                    LiveExprNode kid = Liveness.astToLive(tool, (ExprNode)args[i], con);
                    lnConj.addConj(kid);
                    ++i;
                }
                int level = lnConj.getLevel();
                if (level > 2) {
                    return lnConj;
                }
                return Liveness.astToLive(tool, expr, con, level);
            }
            case 7: 
            case 37: {
                LNDisj lnDisj = new LNDisj(alen);
                int i = 0;
                while (i < alen) {
                    LiveExprNode kid = Liveness.astToLive(tool, (ExprNode)args[i], con);
                    lnDisj.addDisj(kid);
                    ++i;
                }
                int level = lnDisj.getLevel();
                if (level > 2) {
                    return lnDisj;
                }
                return Liveness.astToLive(tool, expr, con, level);
            }
            case 9: {
                try {
                    IFcnLambdaValue fcn;
                    IValue fval = tool.eval(args[0], con, TLCState.Empty);
                    if (fval instanceof IFcnLambdaValue && !(fcn = (IFcnLambdaValue)((Object)fval)).hasRcd()) {
                        tool.getFcnContext(fcn, args, con, TLCState.Empty, TLCState.Empty, 0);
                        return Liveness.astToLive(tool, (ExprNode)fcn.getBody(), con);
                    }
                }
                catch (Exception fval) {
                    // empty catch block
                }
                int level = expr.getLevel();
                if (level > 2) {
                    Assert.fail(2213, expr.toString());
                }
                return Liveness.astToLive(tool, expr, con, level);
            }
            case 11: {
                LiveExprNode guard = Liveness.astToLive(tool, (ExprNode)args[0], con);
                LiveExprNode e1 = Liveness.astToLive(tool, (ExprNode)args[1], con);
                LiveExprNode e2 = Liveness.astToLive(tool, (ExprNode)args[2], con);
                LNConj conj1 = new LNConj(guard, e1);
                LNConj conj2 = new LNConj(new LNNeg(guard), e2);
                LNDisj res = new LNDisj(conj1, conj2);
                int level = ((LiveExprNode)res).getLevel();
                if (level > 2) {
                    return res;
                }
                return Liveness.astToLive(tool, expr, con, level);
            }
            case 27: {
                LiveExprNode lnArg = Liveness.astToLive(tool, (ExprNode)args[0], con);
                int level = lnArg.getLevel();
                if (level > 2) {
                    return new LNNeg(lnArg);
                }
                return Liveness.astToLive(tool, expr, con, level);
            }
            case 38: {
                LiveExprNode lnLeft = Liveness.astToLive(tool, (ExprNode)args[0], con);
                LiveExprNode lnRight = Liveness.astToLive(tool, (ExprNode)args[1], con);
                int level = Math.max(lnLeft.getLevel(), lnRight.getLevel());
                if (level > 2) {
                    return new LNDisj(new LNNeg(lnLeft), lnRight);
                }
                return Liveness.astToLive(tool, expr, con, level);
            }
            case 48: {
                return new LNAction(expr, con);
            }
            case 53: {
                ExprNode subs = (ExprNode)args[0];
                ExprNode body = (ExprNode)args[1];
                LNNeg en = new LNNeg(new LNStateEnabled(body, con, subs, false));
                LNAction act = new LNAction(body, con, subs, false);
                return new LNDisj(new LNEven(new LNAll(en)), new LNAll(new LNEven(act)));
            }
            case 54: {
                ExprNode subs = (ExprNode)args[0];
                ExprNode body = (ExprNode)args[1];
                LNNeg ln1 = new LNNeg(new LNStateEnabled(body, con, subs, false));
                LNAction ln2 = new LNAction(body, con, subs, false);
                LNDisj disj = new LNDisj(ln1, ln2);
                return new LNAll(new LNEven(disj));
            }
            case 57: {
                LiveExprNode lnLeft = Liveness.astToLive(tool, (ExprNode)args[0], con);
                LiveExprNode lnRight = Liveness.astToLive(tool, (ExprNode)args[1], con);
                LNDisj lnd = new LNDisj(new LNNeg(lnLeft), new LNEven(lnRight));
                return new LNAll(lnd);
            }
            case 59: {
                LiveExprNode lnArg = Liveness.astToLive(tool, (ExprNode)args[0], con);
                return new LNAll(lnArg);
            }
            case 60: {
                LiveExprNode lnArg = Liveness.astToLive(tool, (ExprNode)args[0], con);
                return new LNEven(lnArg);
            }
            case 50: {
                assert (Specs.getLevel(expr, con) == 2);
                ExprNode body = (ExprNode)args[0];
                ExprNode subs = (ExprNode)args[1];
                return new LNAction(body, con, subs, false);
            }
            case 46: {
                return Liveness.astToLive(tool, (ExprNode)args[0], con);
            }
        }
        int level = Specs.getLevel(expr, con);
        if (level > 2) {
            Assert.fail(2213, expr.toString());
        }
        return Liveness.astToLive(tool, expr, con, level);
    }

    private static LiveExprNode parseLiveness(ITool tool) {
        LiveExprNode ln;
        Action[] fairs = tool.getTemporals();
        LNConj lnc = new LNConj(fairs.length);
        int i = 0;
        while (i < fairs.length) {
            ln = Liveness.astToLive(tool, (ExprNode)fairs[i].pred, fairs[i].con);
            lnc.addConj(ln);
            ++i;
        }
        Action[] checks = tool.getImpliedTemporals();
        if (checks.length == 0) {
            if (fairs.length == 0) {
                return null;
            }
        } else if (checks.length == 1) {
            ln = Liveness.astToLive(tool, (ExprNode)checks[0].pred, checks[0].con);
            if (lnc.getCount() == 0) {
                return new LNNeg(ln);
            }
            lnc.addConj(new LNNeg(ln));
        } else {
            LNDisj lnd = new LNDisj(checks.length);
            int i2 = 0;
            while (i2 < checks.length) {
                LiveExprNode ln2 = Liveness.astToLive(tool, (ExprNode)checks[i2].pred, checks[i2].con);
                lnd.addDisj(new LNNeg(ln2));
                ++i2;
            }
            if (lnc.getCount() == 0) {
                return lnd;
            }
            lnc.addConj(lnd);
        }
        return lnc;
    }

    public static OrderOfSolution[] processLiveness(ITool tool) {
        return Liveness.processLiveness(tool, false);
    }

    public static OrderOfSolution[] processLiveness(ITool tool, boolean silent) {
        LiveExprNode lexpr = Liveness.parseLiveness(tool);
        if (lexpr == null) {
            return new OrderOfSolution[0];
        }
        lexpr.tagExpr(1);
        lexpr = lexpr.simplify().toDNF();
        if (lexpr instanceof LNBool && !((LNBool)lexpr).b) {
            return new OrderOfSolution[0];
        }
        LNDisj dnf = lexpr instanceof LNDisj ? (LNDisj)lexpr : new LNDisj(lexpr);
        OSExprPem[] pems = new OSExprPem[dnf.getCount()];
        LiveExprNode[] tfs = new LiveExprNode[dnf.getCount()];
        int i = 0;
        while (i < dnf.getCount()) {
            OSExprPem pem;
            LiveExprNode ln = dnf.getBody(i).flattenSingleJunctions();
            pems[i] = pem = new OSExprPem();
            if (ln instanceof LNConj) {
                LNConj lnc2 = (LNConj)ln;
                int j = 0;
                while (j < lnc2.getCount()) {
                    Liveness.classifyExpr(lnc2.getBody(j), pem);
                    ++j;
                }
            } else {
                Liveness.classifyExpr(ln, pem);
            }
            tfs[i] = pem.toTFS();
            ++i;
        }
        TBPar tfbin = new TBPar(dnf.getCount());
        Vect pembin = new Vect(dnf.getCount());
        int i2 = 0;
        while (i2 < dnf.getCount()) {
            int found = -1;
            LiveExprNode tf = tfs[i2];
            int j = 0;
            while (j < tfbin.size() && found == -1) {
                LiveExprNode tf0 = tfbin.exprAt(j);
                if (tf == null && tf0 == null || tf != null && tf0 != null && tf.equals(tf0)) {
                    found = j;
                }
                ++j;
            }
            if (found == -1) {
                found = tfbin.size();
                tfbin.addElement(tf);
                pembin.addElement(new Vect());
            }
            ((Vect)pembin.elementAt(found)).addElement(pems[i2]);
            ++i2;
        }
        OrderOfSolution[] oss = new OrderOfSolution[tfbin.size()];
        int i3 = 0;
        while (i3 < tfbin.size()) {
            LiveExprNode tf = tfbin.exprAt(i3);
            if (tf == null) {
                oss[i3] = new OrderOfSolution(new LNEven[0]);
            } else {
                LiveExprNode tf1 = tf.makeBinary();
                TBGraph tbg = new TBGraph(tf1);
                if (System.getProperty(String.valueOf(Liveness.class.getName()) + ".tableauExportPath") != null) {
                    try {
                        Files.write(Paths.get(System.getProperty(String.valueOf(Liveness.class.getName()) + ".tableauExportPath", "./TBGraph.dot"), new String[0]), tbg.toDotViz().getBytes(), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                oss[i3] = new OrderOfSolution(tbg, tf1.extractPromises());
            }
            Vect<LiveExprNode> stateBin = new Vect<LiveExprNode>();
            Vect<LiveExprNode> actionBin = new Vect<LiveExprNode>();
            Vect tfPems = (Vect)pembin.elementAt(i3);
            oss[i3].setPems(new PossibleErrorModel[tfPems.size()]);
            int j = 0;
            while (j < tfPems.size()) {
                OSExprPem pem = (OSExprPem)tfPems.elementAt(j);
                oss[i3].getPems()[j] = new PossibleErrorModel(Liveness.addToBin(pem.AEAction, actionBin), Liveness.addToBin(pem.AEState, stateBin), Liveness.addToBin(pem.EAAction, actionBin));
                ++j;
            }
            oss[i3].setCheckState(new LiveExprNode[stateBin.size()]);
            j = 0;
            while (j < stateBin.size()) {
                oss[i3].getCheckState()[j] = stateBin.elementAt(j);
                ++j;
            }
            oss[i3].setCheckAction(new LiveExprNode[actionBin.size()]);
            j = 0;
            while (j < actionBin.size()) {
                oss[i3].getCheckAction()[j] = actionBin.elementAt(j);
                ++j;
            }
            if (Boolean.getBoolean(String.valueOf(Liveness.class.getName()) + ".debug")) {
                LNEven[] promises = oss[i3].getPromises();
                LiveExprNode[] checkAction = oss[i3].getCheckAction();
                LiveExprNode[] checkState = oss[i3].getCheckState();
                MP.printMessage(2263, String.valueOf(pems != null ? pems.length : 0), String.valueOf(promises != null ? promises.length : 0), String.valueOf(checkAction != null ? checkAction.length : 0), String.valueOf(checkState != null ? checkState.length : 0), String.valueOf(oss[i3].hasTableau() ? oss[i3].getTableau().size() : 0));
            }
            ++i3;
        }
        if (!silent) {
            MP.printMessage(2212, String.valueOf(oss.length));
        }
        return oss;
    }

    private static int addToBin(LiveExprNode check, Vect<LiveExprNode> bin) {
        if (check == null) {
            return -1;
        }
        int len = bin.size();
        int idx = 0;
        while (idx < len) {
            LiveExprNode ln = bin.elementAt(idx);
            if (check.equals(ln)) break;
            ++idx;
        }
        if (idx >= len) {
            bin.addElement(check);
        }
        return idx;
    }

    private static int[] addToBin(Vect<LiveExprNode> checks, Vect<LiveExprNode> bin) {
        int[] index = new int[checks.size()];
        int i = 0;
        while (i < checks.size()) {
            LiveExprNode check = checks.elementAt(i);
            index[i] = Liveness.addToBin(check, bin);
            ++i;
        }
        return index;
    }

    private static void classifyExpr(LiveExprNode ln, OSExprPem pem) {
        LiveExprNode ln1;
        if (ln instanceof LNEven) {
            LiveExprNode ln2;
            LiveExprNode ln12 = ((LNEven)ln).getBody();
            if (ln12 instanceof LNAll && (ln2 = ((LNAll)ln12).getBody()).getLevel() < 3) {
                pem.EAAction.addElement(ln2);
                return;
            }
        } else if (ln instanceof LNAll && (ln1 = ((LNAll)ln).getBody()) instanceof LNEven) {
            LiveExprNode ln2 = ((LNEven)ln1).getBody();
            int level = ln2.getLevel();
            if (level <= 1) {
                pem.AEState.addElement(ln2);
                return;
            }
            if (level == 2) {
                pem.AEAction.addElement(ln2);
                return;
            }
        }
        if (ln.containAction()) {
            Assert.fail(2214);
        }
        pem.tfs.addElement(ln);
    }

    public static void printTBGraph(TBGraph tableau) {
        if (tableau == null) {
            ToolIO.out.println("No tableau.");
        } else {
            ToolIO.out.println(tableau.toString());
        }
    }

    private static class OSExprPem {
        private final Vect<LiveExprNode> EAAction = new Vect();
        private final Vect<LiveExprNode> AEState = new Vect();
        private final Vect<LiveExprNode> AEAction = new Vect();
        private final Vect<LiveExprNode> tfs = new Vect();

        public LiveExprNode toTFS() {
            if (this.tfs.size() == 1) {
                return this.tfs.elementAt(0);
            }
            if (this.tfs.size() > 1) {
                LNConj lnc2 = new LNConj(this.tfs.size());
                int j = 0;
                while (j < this.tfs.size()) {
                    lnc2.addConj(this.tfs.elementAt(j));
                    ++j;
                }
                return lnc2;
            }
            return null;
        }
    }
}

