/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.SemanticNode;
import tlc2.TLCGlobals;
import tlc2.debug.IDebugTarget;
import tlc2.debug.TLCDebugger;
import tlc2.tool.Action;
import tlc2.tool.EvalControl;
import tlc2.tool.EvalException;
import tlc2.tool.IActionItemList;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.IStateFunctor;
import tlc2.tool.ITool;
import tlc2.tool.StatefulRuntimeException;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateFun;
import tlc2.tool.TLCStateMutExt;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.ActionItemList;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.util.SetOfStates;
import tlc2.value.IValue;
import tlc2.value.impl.Value;
import util.Assert;

public class DebugTool
extends Tool {
    private static volatile boolean forceViolation = false;
    private static final Set<Integer> KINDS = new HashSet<Integer>(Arrays.asList(16, 17, 18));
    private final IDebugTarget target;
    private final Tool fastTool;
    private EvalMode mode = EvalMode.Const;

    public static boolean forceViolation() {
        return forceViolation;
    }

    public static void setForceViolation() {
        forceViolation = true;
    }

    public DebugTool(Tool tool, TLCDebugger target) {
        super(tool);
        this.fastTool = tool;
        this.target = target.setTool(this);
    }

    @Override
    public boolean isValidAssumption(ExprNode assumption) {
        boolean isValid = this.isValid(assumption);
        if (!isValid) {
            try {
                this.target.markAssumptionViolatedFrame(this, assumption, Context.Empty);
            }
            catch (IDebugTarget.ResetEvalException ree) {
                this.target.popFrame(this, assumption, Context.Empty);
                return this.isValidAssumption(assumption);
            }
        }
        return isValid;
    }

    @Override
    public boolean isValid(Action act, TLCState state) {
        if (act.isInternal()) {
            this.mode = EvalMode.Debugger;
            try {
                boolean bl = this.isValid(act, state, TLCState.Empty);
                return bl;
            }
            finally {
                this.mode = EvalMode.State;
            }
        }
        this.mode = EvalMode.State;
        try {
            return this.isValid(act, state, TLCState.Empty);
        }
        catch (IDebugTarget.ResetEvalException ree) {
            return this.isValid(act, state);
        }
    }

    @Override
    public boolean isValid(ExprNode expr, Context ctxt) {
        this.mode = EvalMode.Const;
        return super.isValid(expr, ctxt);
    }

    @Override
    public final IValue eval(SemanticNode expr, Context ctxt) {
        this.mode = EvalMode.Const;
        return this.evalImpl(expr, Context.Empty, TLCState.Empty, TLCState.Empty, 0, CostModel.DO_NOT_RECORD);
    }

    @Override
    public final IValue eval(SemanticNode expr, Context c, TLCState s0) {
        return this.eval(expr, c, s0, CostModel.DO_NOT_RECORD);
    }

    @Override
    public final IValue eval(SemanticNode expr, Context c, TLCState s0, CostModel cm) {
        this.mode = EvalMode.State;
        return this.evalImpl(expr, c, s0, TLCState.Empty, 0, cm);
    }

    @Override
    public final Value eval(SemanticNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        try {
            if (this.mode == EvalMode.Debugger) {
                return this.fastTool.evalImpl(expr, c, s0, s1, control, cm);
            }
            if (s1 == null || EvalControl.isPrimed(control) || EvalControl.isEnabled(control)) {
                return this.fastTool.evalImpl(expr, c, s0, s1, control, cm);
            }
            if (this.mode == EvalMode.Action && s1.getAction() == null) {
                return this.fastTool.evalImpl(expr, c, s0, s1, control, cm);
            }
            if (EvalControl.isInit(control)) {
                this.mode = EvalMode.State;
                return this.evalImpl(expr, c, s0, s1, control, cm);
            }
            if (EvalControl.isConst(control)) {
                this.mode = EvalMode.Const;
                return this.evalImpl(expr, c, s0, s1, control, cm);
            }
            if (this.mode == EvalMode.State && s1 != null && s1.noneAssigned()) {
                return this.evalImpl(expr, c, s0, s1, control, cm);
            }
            if (this.mode == EvalMode.Const && s0.noneAssigned() && s1.noneAssigned()) {
                return this.evalImpl(expr, c, s0, s1, control, cm);
            }
            this.mode = EvalMode.Action;
            return this.evalImpl(expr, c, s0, s1, control, cm);
        }
        catch (IDebugTarget.ResetEvalException ree) {
            if (ree.isTarget(expr)) {
                return this.eval(expr, c, s0, s1, control, cm);
            }
            throw ree;
        }
    }

    @Override
    protected final Value evalImpl(SemanticNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        try {
            if (this.isInitialize()) {
                return super.evalImpl(expr, c, s0, s1, control, cm);
            }
            if (this.isLiveness(control, s0, s1) || this.isLeaf(expr) || this.isBoring(expr, c)) {
                return this.fastTool.evalImpl(expr, c, s0, s1, control, cm);
            }
            if (this.mode == EvalMode.Debugger) {
                return this.fastTool.evalImpl(expr, c, s0, s1, control, cm);
            }
            if (this.mode == EvalMode.Const) {
                assert (s0.noneAssigned() && s1.noneAssigned());
                return this.constLevelEval(expr, c, s0, s1, control, cm);
            }
            if (this.mode == EvalMode.State) {
                assert (s1 == null || s1.noneAssigned());
                return this.stateLevelEval(expr, c, s0, s1, control, cm);
            }
            return this.actionLevelEval(expr, c, s0, s1, control, cm);
        }
        catch (IDebugTarget.ResetEvalException ree) {
            if (ree.isTarget(expr)) {
                return this.evalImpl(expr, c, s0, s1, control, cm);
            }
            throw ree;
        }
    }

    private boolean isLeaf(SemanticNode expr) {
        return KINDS.contains(expr.getKind());
    }

    private boolean isInitialize() {
        return this.target == null || TLCGlobals.mainChecker == null && TLCGlobals.simulator == null;
    }

    private boolean isLiveness(int control, TLCState s0, TLCState s1) {
        if (EvalControl.isEnabled(control) || EvalControl.isPrimed(control)) {
            return true;
        }
        return s0 instanceof TLCStateFun || s1 instanceof TLCStateFun;
    }

    private boolean isBoring(SemanticNode expr, Context c) {
        return false;
    }

    private Value actionLevelEval(SemanticNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        Value value;
        Value v = null;
        try {
            this.target.pushFrame((Tool)this, expr, c, s0, s1.getAction(), s1);
            value = v = super.evalImpl(expr, c, s0, s1, control, cm);
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            try {
                if (e.isKnown()) {
                    throw e;
                }
                try {
                    this.target.pushExceptionFrame(this, expr, c, s0, s1.getAction(), s1, e);
                }
                catch (Throwable throwable) {
                    this.target.popExceptionFrame((Tool)this, expr, c, v, s0, s1, e);
                    throw throwable;
                }
                this.target.popExceptionFrame((Tool)this, expr, c, v, s0, s1, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.target.popFrame((Tool)this, expr, c, v, s0, s1);
                throw throwable;
            }
        }
        this.target.popFrame((Tool)this, expr, c, v, s0, s1);
        return value;
    }

    private Value stateLevelEval(SemanticNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        Value value;
        Value v = null;
        try {
            this.target.pushFrame(this, expr, c, s0);
            value = v = super.evalImpl(expr, c, s0, s1, control, cm);
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            try {
                if (e.isKnown()) {
                    throw e;
                }
                try {
                    this.target.pushExceptionFrame(this, expr, c, s0, e);
                }
                finally {
                    this.target.popExceptionFrame(this, expr, c, v, s0, e);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.target.popFrame((Tool)this, expr, c, v, s0);
                throw throwable;
            }
        }
        this.target.popFrame((Tool)this, expr, c, v, s0);
        return value;
    }

    private Value constLevelEval(SemanticNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        Value value;
        Value v = null;
        try {
            this.target.pushFrame(this, expr, c);
            value = v = super.evalImpl(expr, c, s0, s1, control, cm);
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            try {
                if (e.isKnown()) {
                    throw e;
                }
                try {
                    this.target.pushExceptionFrame(this, expr, c, e);
                }
                finally {
                    this.target.popExceptionFrame(this, expr, c, v, e);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.target.popFrame((Tool)this, expr, c, v);
                throw throwable;
            }
        }
        this.target.popFrame((Tool)this, expr, c, v);
        return value;
    }

    @Override
    protected final Value evalAppl(OpApplNode expr, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        return this.evalApplImpl(expr, c, s0, s1, control, cm);
    }

    @Override
    protected final Value setSource(SemanticNode expr, Value value) {
        return value;
    }

    @Override
    public final TLCState enabled(SemanticNode pred, IActionItemList acts, Context c, TLCState s0, TLCState s1, CostModel cm) {
        return this.enabledImpl(pred, (ActionItemList)acts, c, s0, s1, cm);
    }

    @Override
    protected final TLCState enabledAppl(OpApplNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, CostModel cm) {
        return this.enabledApplImpl(pred, acts, c, s0, s1, cm);
    }

    @Override
    protected final TLCState enabledUnchanged(SemanticNode expr, ActionItemList acts, Context c, TLCState s0, TLCState s1, CostModel cm) {
        return this.enabledUnchangedImpl(expr, acts, c, s0, s1, cm);
    }

    @Override
    protected final TLCState getNextStates(Action action, SemanticNode expr, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        if (this.mode == EvalMode.Debugger) {
            return this.fastTool.getNextStatesImpl(action, expr, acts, c, s0, s1, nss, cm);
        }
        this.mode = EvalMode.Action;
        try {
            return this.getNextStatesImpl(action, expr, acts, c, s0, s1.setPredecessor(s0).setAction(action), nss, cm);
        }
        catch (IDebugTarget.ResetEvalException ree) {
            if (ree.isTarget(expr)) {
                return this.getNextStates(action, expr, acts, c, s0, s1, nss, cm);
            }
            throw ree;
        }
    }

    @Override
    protected final TLCState getNextStatesAppl(Action action, OpApplNode pred, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        TLCState s;
        if (this.mode == EvalMode.Debugger) {
            return this.fastTool.getNextStatesApplImpl(action, pred, acts, c, s0, s1, nss, cm);
        }
        this.mode = EvalMode.Action;
        try {
            try {
                this.target.pushFrame((Tool)this, pred, c, s0, action, s1);
                s = this.getNextStatesApplImpl(action, pred, acts, c, s0, s1, nss, cm);
            }
            catch (EvalException | Assert.TLCRuntimeException e) {
                if (e.isKnown()) {
                    throw e;
                }
                try {
                    this.target.pushExceptionFrame(this, pred, c, e);
                }
                finally {
                    this.target.popExceptionFrame((Tool)this, (SemanticNode)pred, c, s0, action, s1, e);
                }
                throw e;
            }
            catch (INextStateFunctor.InvariantViolatedException e) {
                if (e.isKnown()) {
                    throw e;
                }
                try {
                    this.target.markInvariantViolatedFrame(this, pred, c, s0, action, s1, e);
                }
                finally {
                    this.target.popExceptionFrame((Tool)this, (SemanticNode)pred, c, s0, action, s1, (StatefulRuntimeException)e);
                }
                throw e;
            }
        }
        finally {
            this.target.popFrame((Tool)this, (SemanticNode)pred, c, s0, s1);
        }
        return s;
    }

    @Override
    protected final TLCState processUnchanged(Action action, SemanticNode expr, ActionItemList acts, Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        try {
            return this.processUnchangedImpl(action, expr, acts, c, s0, s1, nss, cm);
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            if (e.isKnown()) {
                throw e;
            }
            try {
                this.target.pushExceptionFrame(this, expr, c, s0, action, s1, e);
            }
            finally {
                this.target.popExceptionFrame((Tool)this, expr, c, s0, action, s1, e);
            }
            throw e;
        }
        catch (INextStateFunctor.InvariantViolatedException e) {
            if (e.isKnown()) {
                throw e;
            }
            try {
                this.target.markInvariantViolatedFrame(this, expr, c, s0, action, s1, e);
            }
            finally {
                this.target.popExceptionFrame((Tool)this, expr, c, s0, action, s1, (StatefulRuntimeException)e);
            }
            throw e;
        }
    }

    @Override
    protected TLCState processUnsatisfied(TLCState state, SemanticNode pred, Context c, IStateFunctor states, CostModel cm) {
        this.target.pushUnsatisfiedFrame(this, pred, c, state);
        this.target.popFrame((Tool)this, pred, c, state);
        return states.addUnsatisfiedState(state, pred, c);
    }

    @Override
    protected TLCState processUnsatisfied(TLCState curState, Action action, TLCState succState, SemanticNode pred, Context c, INextStateFunctor nss, CostModel cm) {
        succState.setAction(action).setPredecessor(curState);
        this.target.pushUnsatisfiedFrame(this, pred, c, curState, action, succState);
        this.target.popFrame((Tool)this, pred, c, curState, succState);
        return nss.addUnsatisfiedState(curState, action, succState, pred, c);
    }

    @Override
    protected void getInitStates(SemanticNode init, ActionItemList acts, Context c, TLCState ps, IStateFunctor states, CostModel cm) {
        if (this.mode == EvalMode.Debugger) {
            this.fastTool.getInitStates(init, acts, c, ps, states, cm);
        } else {
            this.mode = EvalMode.State;
            try {
                if (states instanceof WrapperStateFunctor) {
                    super.getInitStates(init, acts, c, ps, states, cm);
                } else {
                    super.getInitStates(init, acts, c, ps, new WrapperStateFunctor(states, this.target), cm);
                }
            }
            catch (IDebugTarget.ResetEvalException ree) {
                if (ree.isTarget(init)) {
                    this.getInitStates(init, acts, c, ps, states, cm);
                }
                throw ree;
            }
        }
    }

    @Override
    protected void getInitStatesAppl(OpApplNode init, ActionItemList acts, Context c, TLCState ps, IStateFunctor states, CostModel cm) {
        if (this.mode == EvalMode.Debugger) {
            this.fastTool.getInitStatesAppl(init, acts, c, ps, states, cm);
        } else {
            this.mode = EvalMode.State;
            try {
                this.target.pushFrame(this, init, c, ps);
                super.getInitStatesAppl(init, acts, c, ps, states, cm);
            }
            finally {
                this.target.popFrame((Tool)this, (SemanticNode)init, c, ps);
            }
        }
    }

    @Override
    public boolean getNextStates(INextStateFunctor functor, TLCState state, Action action) {
        if (this.mode == EvalMode.Debugger) {
            this.fastTool.getNextStates(functor, state, action);
        }
        this.mode = EvalMode.Action;
        try {
            if (functor instanceof WrapperNextStateFunctor) {
                boolean bl = super.getNextStates(functor, state, action);
                return bl;
            }
            WrapperNextStateFunctor wf = new WrapperNextStateFunctor(functor, this.target);
            if (action.isDeclared()) {
                try {
                    IDebugTarget.StepDirection d = this.target.pushFrame((Tool)this, action.getOpDef(), action.con, state, action, wf);
                    if (d == IDebugTarget.StepDirection.Out && !state.isInitial()) {
                        functor.setElement(state.getPredecessor());
                        return false;
                    }
                    if (d == IDebugTarget.StepDirection.Over) {
                        return false;
                    }
                    super.getNextStates(wf, state, action);
                }
                finally {
                    this.target.popFrame((Tool)this, action.getOpDef(), action.con, state, action, wf);
                }
            } else {
                this.getNextStates(wf, state, action);
            }
            return false;
        }
        catch (IDebugTarget.ResetEvalException ree) {
            assert (ree.isTarget(action.getOpDef()));
            boolean bl = this.getNextStates(functor, state, action);
            return bl;
        }
        catch (IDebugTarget.AbortEvalException e) {
            return false;
        }
        finally {
            if (this.toolMode == Tool.Mode.MC_DEBUG) {
                state.unsetPredecessor();
            }
        }
    }

    @Override
    public final <T> T eval(Supplier<T> supplier) {
        EvalMode old = this.setDebugger();
        ITool oldTool = TLCStateMutExt.resetTool(this.fastTool);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.mode = old;
            TLCStateMutExt.resetTool(oldTool);
        }
    }

    public EvalMode setDebugger() {
        EvalMode old = this.mode;
        this.mode = EvalMode.Debugger;
        return old;
    }

    @Override
    public ITool noDebug() {
        return this.fastTool;
    }

    public static enum EvalMode {
        Const,
        State,
        Action,
        Debugger;

    }

    private static class WrapperNextStateFunctor
    implements INextStateFunctor {
        protected final INextStateFunctor functor;
        protected final IDebugTarget target;

        WrapperNextStateFunctor(INextStateFunctor functor, IDebugTarget target) {
            this.functor = functor;
            this.target = target;
        }

        @Override
        public Object addElement(TLCState predecessor, Action a, TLCState state) {
            try {
                IDebugTarget.StepDirection dt = this.target.pushFrame(predecessor, a, state);
                if (dt == IDebugTarget.StepDirection.Out) {
                    if (predecessor.isInitial()) {
                        this.functor.setElement(predecessor);
                        throw new IDebugTarget.AbortEvalException();
                    }
                    assert (predecessor.getPredecessor() != null);
                    this.functor.setElement(predecessor.getPredecessor());
                    throw new IDebugTarget.AbortEvalException();
                }
                if (dt == IDebugTarget.StepDirection.In) {
                    this.functor.addElement(predecessor, a, state);
                    this.functor.setElement(state);
                    throw new IDebugTarget.AbortEvalException();
                }
                if (dt == IDebugTarget.StepDirection.Over) {
                    INextStateFunctor iNextStateFunctor = this.functor;
                    return iNextStateFunctor;
                }
                assert (dt == IDebugTarget.StepDirection.Continue);
                Object object = this.functor.addElement(predecessor, a, state);
                return object;
            }
            finally {
                this.target.popFrame(predecessor, state);
            }
        }

        @Override
        public boolean hasStates() {
            return this.functor.hasStates();
        }

        @Override
        public SetOfStates getStates() {
            return this.functor.getStates();
        }

        @Override
        public TLCState addUnsatisfiedState(TLCState curState, Action action, TLCState succState, SemanticNode pred, Context c) {
            return this.functor.addUnsatisfiedState(curState, action, succState, pred, c);
        }

        @Override
        public TLCState addUnsatisfiedState(TLCState state, SemanticNode pred, Context c) {
            return this.functor.addUnsatisfiedState(state, pred, c);
        }
    }

    private static class WrapperStateFunctor
    implements IStateFunctor {
        protected final IStateFunctor functor;
        protected final IDebugTarget target;

        WrapperStateFunctor(IStateFunctor functor, IDebugTarget target) {
            this.functor = functor;
            this.target = target;
        }

        @Override
        public Object addElement(TLCState state) {
            try {
                this.target.pushFrame(state);
                Object object = this.functor.addElement(state);
                return object;
            }
            finally {
                this.target.popFrame(state);
            }
        }
    }
}

