/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import org.junit.After;
import org.junit.Before;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.FPSetStatistic;

public abstract class AbstractFPSetTest {
    protected static final long RNG_SEED = 15041980L;
    protected static final String tmpdir = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "FPSetTest" + System.currentTimeMillis();
    protected static final String filename = "FPSetTestTest";
    protected static final DecimalFormat df = new DecimalFormat("###,###.###");
    protected static final DecimalFormat pf = new DecimalFormat("#.##");
    protected long previousTimestamp;
    protected long previousSize;
    protected long startTimestamp;
    protected Date endTimeStamp;
    private File dir;

    @Before
    public void setUp() throws Exception {
        this.dir = new File(tmpdir);
        this.dir.mkdirs();
        this.previousTimestamp = this.startTimestamp = System.currentTimeMillis();
        this.previousSize = 0L;
        System.out.println("Test started at " + new Date());
    }

    @After
    public void tearDown() {
        if (this.endTimeStamp == null) {
            this.endTimeStamp = new Date();
        }
        System.out.println("Test finished at " + this.endTimeStamp);
        File[] listFiles = this.dir.listFiles();
        int i = 0;
        while (i < listFiles.length) {
            File aFile = listFiles[i];
            aFile.delete();
            ++i;
        }
        this.dir.delete();
    }

    protected abstract FPSet getFPSet(FPSetConfiguration var1) throws IOException;

    protected FPSet getFPSetInitialized() throws IOException {
        return this.getFPSetInitialized(1);
    }

    protected FPSet getFPSetInitialized(int numThreads) throws IOException {
        FPSet fpSet = this.getFPSet(new FPSetConfiguration());
        fpSet.init(numThreads, tmpdir, filename);
        if (fpSet instanceof FPSetStatistic) {
            FPSetStatistic fpSetStats = (FPSetStatistic)((Object)fpSet);
            long maxTblCnt = fpSetStats.getMaxTblCnt();
            System.out.println("Maximum FPSet table count is: " + df.format(maxTblCnt) + " (approx: " + df.format(maxTblCnt * 8L >> 20) + " GiB)");
            System.out.println("FPSet lock count is: " + fpSetStats.getLockCnt());
            System.out.println("FPSet bucket count is: " + fpSetStats.getTblCapacity());
        }
        System.out.println("Testing " + fpSet.getClass().getCanonicalName());
        return fpSet;
    }

    public void printInsertionSpeed(FPSet fpSet) {
        long now = System.currentTimeMillis();
        double factor = (double)(now - this.previousTimestamp) / 60000.0;
        if (factor >= 1.0) {
            long currentSize = fpSet.size();
            long insertions = (long)((double)(currentSize - this.previousSize) * factor);
            if (fpSet instanceof FPSetStatistic) {
                FPSetStatistic fpSetStatistics = (FPSetStatistic)((Object)fpSet);
                System.out.println(String.valueOf(System.currentTimeMillis()) + " s (epoch); " + df.format(insertions) + " insertions/min; " + pf.format(fpSetStatistics.getLoadFactor()) + " load factor");
            } else {
                System.out.println(String.valueOf(System.currentTimeMillis()) + " s (epoch); " + df.format(insertions) + " insertions/min");
            }
            this.previousTimestamp = now;
            this.previousSize = currentSize;
        }
    }

    public void printInsertionSpeed(FPSet fpSet, long start, long end) {
        long size = fpSet.size();
        long duration = Math.max(end - start, 1L);
        long insertions = size / duration * 60000L;
        if (fpSet instanceof FPSetStatistic) {
            FPSetStatistic fpSetStatistics = (FPSetStatistic)((Object)fpSet);
            System.out.println(String.valueOf(System.currentTimeMillis()) + " s; " + df.format(insertions) + " insertions/min; " + pf.format(fpSetStatistics.getLoadFactor()) + " load factor");
        } else {
            System.out.println(String.valueOf(System.currentTimeMillis()) + " s (epoch); " + df.format(insertions) + " insertions/min");
        }
    }
}

