/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.util.HashSet;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;

public class ModuleASTCacheManager {
    public static void clearModuleASTCache(ExternalModuleTable moduleTable, int toolId) {
        if (moduleTable == null) {
            return;
        }
        ModuleNode[] modules = moduleTable.getModuleNodes();
        HashSet<ModuleNode> visited = new HashSet<ModuleNode>();
        ModuleNode[] moduleNodeArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleNode moduleNode = moduleNodeArray[n2];
            if (moduleNode != null && !visited.contains(moduleNode)) {
                ModuleASTCacheManager.clearModuleNodeCache(moduleNode, toolId, visited);
            }
            ++n2;
        }
    }

    private static int clearModuleNodeCache(ModuleNode moduleNode, int toolId, HashSet<ModuleNode> visited) {
        OpDefNode[] opDefs;
        if (moduleNode == null || visited.contains(moduleNode)) {
            return 0;
        }
        visited.add(moduleNode);
        int clearedCount = 0;
        OpDefNode[] opDefNodeArray = opDefs = moduleNode.getOpDefs();
        int n = opDefs.length;
        int n2 = 0;
        while (n2 < n) {
            Object oldValue;
            OpDefNode opDef = opDefNodeArray[n2];
            if (opDef != null && opDef.getBody() != null && (oldValue = opDef.getBody().getToolObject(toolId)) != null) {
                opDef.getBody().setToolObject(toolId, null);
                ++clearedCount;
            }
            ++n2;
        }
        HashSet<ModuleNode> extendedModules = moduleNode.getExtendedModuleSet(true);
        if (extendedModules != null) {
            for (ModuleNode extendedModule : extendedModules) {
                clearedCount += ModuleASTCacheManager.clearModuleNodeCache(extendedModule, toolId, visited);
            }
        }
        return clearedCount;
    }

    public static void clearModuleASTCache(ModuleNode rootModule, int toolId) {
        if (rootModule == null) {
            return;
        }
        ModuleASTCacheManager.clearModuleNodeCache(rootModule, toolId, new HashSet<ModuleNode>());
    }
}

