/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Vector;
import tla2tex.BuiltInSymbols;
import tla2tex.CommentToken;
import tla2tex.Debug;
import tla2tex.ExecuteCommand;
import tla2tex.FormatComments;
import tla2tex.Misc;
import tla2tex.OutputFileWriter;
import tla2tex.Parameters;
import tla2tex.PosAndCol;
import tla2tex.Position;
import tla2tex.ResourceFileReader;
import tla2tex.Token;
import tla2tex.TokenizeSpec;
import util.ToolIO;

public final class LaTeXOutput {
    public static void WriteAlignmentFile(Token[][] spec2) {
        OutputFileWriter writer = LaTeXOutput.StartLaTeXOutput(Parameters.LaTeXAlignmentFile);
        LaTeXOutput.InnerWriteAlignmentFile(spec2, writer, true);
    }

    public static void WriteTeXAlignmentFile(Token[][] spec2, Vector preamble, float linewidth) {
        OutputFileWriter writer = new OutputFileWriter(String.valueOf(Parameters.LaTeXAlignmentFile) + ".tex");
        writer.putLine("\\batchmode");
        int i = 0;
        while (i < preamble.size()) {
            writer.putLine((String)preamble.elementAt(i));
            ++i;
        }
        if (linewidth >= 0.0f) {
            writer.putLine("\\setlength{\\textwidth}{" + Misc.floatToString(linewidth, 2) + "pt}");
        }
        writer.putLine("\\begin{document}");
        writer.putLine("\\makeatletter");
        writer.putLine("\\chardef\\%=`\\%");
        LaTeXOutput.InnerWriteAlignmentFile(spec2, writer, false);
    }

    private static void InnerWriteAlignmentFile(Token[][] spec2, OutputFileWriter writer, boolean tlaMode) {
        int line = 0;
        boolean inProlog = true;
        while (inProlog && line < spec2.length) {
            if (spec2[line].length > 0 && spec2[line][0].type != 8) {
                inProlog = false;
                continue;
            }
            ++line;
        }
        if (Parameters.CommentShading) {
            writer.putLine("\\setboolean{shading}{true}");
        }
        boolean inBeginModule = false;
        boolean inSub = false;
        while (line < spec2.length) {
            int item = 0;
            String outLine = "\\fl{";
            while (item < spec2[line].length) {
                Token tok = spec2[line][item];
                if (inSub && !tok.subscript) {
                    inSub = false;
                    outLine = String.valueOf(outLine) + "}";
                }
                if (tok.isAlignmentPoint) {
                    outLine = String.valueOf(outLine) + "}" + "\\al" + "{" + line + "}{" + item + "}{";
                }
                block0 : switch (tok.type) {
                    case 1: {
                        int symType = BuiltInSymbols.GetBuiltInSymbol((String)spec2[line][item].string, (boolean)true).symbolType;
                        if (!inSub && (symType == 6 || tok.string.equals("^")) && item + 1 < spec2[line].length && spec2[line][item + 1].subscript) {
                            inSub = true;
                            if (symType == 6) {
                                outLine = String.valueOf(outLine) + " " + BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).TeXString + "_{";
                                break;
                            }
                            outLine = String.valueOf(outLine) + " " + "^{";
                            break;
                        }
                        outLine = String.valueOf(outLine) + " " + BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).TeXString;
                        break;
                    }
                    case 2: 
                    case 4: {
                        outLine = String.valueOf(outLine) + " " + Misc.TeXify(tok.string);
                        break;
                    }
                    case 13: {
                        outLine = String.valueOf(outLine) + " " + Misc.TeXifyPcalLabel(tok.string);
                        break;
                    }
                    case 3: {
                        outLine = String.valueOf(outLine) + "\\@w" + "{" + LaTeXOutput.FixString(tok.string) + "}";
                        break;
                    }
                    case 12: {
                        outLine = String.valueOf(outLine) + LaTeXOutput.PfStepString(tok.string);
                        if (!((Token.PfStepToken)tok).needsSpace) break;
                        outLine = String.valueOf(outLine) + "\\ ";
                        break;
                    }
                    case 5: {
                        CommentToken ctok = (CommentToken)tok;
                        switch (ctok.subtype) {
                            case 6: {
                                if (item == 0) break block0;
                                outLine = String.valueOf(outLine) + "%";
                                Misc.WriteIfNonNull(writer, outLine);
                                outLine = "";
                                Vector<String> vec = new Vector<String>(2);
                                vec.addElement(tok.string);
                                FormatComments.WriteComment(writer, vec, 1, 0.0f, tlaMode);
                                break;
                            }
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: {
                                break;
                            }
                            default: {
                                Debug.ReportBug("Bad comment token subtype at position (" + line + ", " + item + ")\n" + "    in LaTeXOutput.WriteAlignmentFile");
                                break;
                            }
                        }
                        break;
                    }
                    case 6: {
                        if (inBeginModule) {
                            outLine = String.valueOf(outLine) + "}" + "\\moduleRightDash\\cl" + "{";
                            inBeginModule = false;
                            break;
                        }
                        if (item + 1 < spec2[line].length && spec2[line][item + 1].string.equals("MODULE")) {
                            outLine = String.valueOf(outLine) + "}" + "\\moduleLeftDash\\cl" + "{";
                            inBeginModule = true;
                            break;
                        }
                        outLine = String.valueOf(outLine) + "}" + "\\midbar\\cl" + "{";
                        break;
                    }
                    case 7: {
                        outLine = String.valueOf(outLine) + "}" + "\\bottombar\\cl" + "{";
                        break;
                    }
                    case 9: {
                        break;
                    }
                    default: {
                        Debug.ReportBug("Bad token type at position (" + line + ", " + item + ")\n" + "    in LaTeXOutput.WriteAlignmentFile");
                    }
                }
                ++item;
            }
            if (inSub) {
                outLine = String.valueOf(outLine) + "}";
                inSub = false;
            }
            outLine = String.valueOf(outLine) + "}";
            Misc.BreakStringOut(writer, outLine);
            ++line;
        }
        writer.putLine("\\end{document}");
        writer.close();
    }

    private static OutputFileWriter StartLaTeXOutput(String fileName) {
        OutputFileWriter writer = new OutputFileWriter(String.valueOf(LaTeXOutput.prependMetaDirToFileName(fileName)) + ".tex");
        writer.putLine("\\batchmode %% Suppresses most terminal output.");
        if (Parameters.LaTeXptSize == 10) {
            writer.putLine("\\documentclass{article}");
        } else {
            writer.putLine("\\documentclass[" + Parameters.LaTeXptSize + "pt]{article}");
        }
        if (Parameters.CommentShading) {
            writer.putLine("\\usepackage{color}");
            writer.putLine("\\definecolor{boxshade}{gray}{" + Parameters.PSGrayLevel + "}");
        }
        writer.putLine("\\setlength{\\textwidth}{" + Parameters.LaTeXtextwidth + "pt}");
        writer.putLine("\\setlength{\\textheight}{" + Parameters.LaTeXtextheight + "pt}");
        if (Parameters.LaTeXhoffset != 0) {
            writer.putLine("\\addtolength{\\hoffset}{" + Parameters.LaTeXhoffset + "pt}");
        }
        if (Parameters.LaTeXvoffset != 0) {
            writer.putLine("\\addtolength{\\voffset}{" + Parameters.LaTeXvoffset + "pt}");
        }
        if (Parameters.UserStyleFile.equals("")) {
            ResourceFileReader latexStyleReader = new ResourceFileReader(Parameters.LaTeXStyleFile);
            LaTeXOutput.CopyResourceFile(latexStyleReader, writer);
        } else {
            writer.putLine("\\usepackage{" + Parameters.UserStyleFile + "}");
        }
        writer.putLine("\\begin{document}");
        writer.putLine("\\tlatex");
        return writer;
    }

    private static void CopyResourceFile(ResourceFileReader input, OutputFileWriter output) {
        String line = input.getLine();
        while (line != null) {
            output.putLine(line);
            line = input.getLine();
        }
        input.close();
    }

    public static void RunLaTeX(String fileName) {
        String latexCmd = String.valueOf(Parameters.LaTeXCommand) + " " + fileName + ".tex";
        ExecuteCommand.executeCommand(latexCmd);
    }

    public static void SetDimensions(Token[][] spec2) {
        int item;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(LaTeXOutput.prependMetaDirToFileName(String.valueOf(Parameters.LaTeXAlignmentFile) + ".log"))));
        }
        catch (FileNotFoundException e) {
            Debug.ReportError("Could not read file " + Parameters.LaTeXAlignmentFile + ".log\n" + "    written by LaTeX");
        }
        try {
            String inputLine = bufferedReader.readLine();
            while (inputLine != null) {
                if (inputLine.length() > 2 && inputLine.substring(0, 3).equals("\\%{")) {
                    float dist;
                    int start = 3;
                    int after = inputLine.indexOf("}", start);
                    int line = Integer.parseInt(inputLine.substring(start, after));
                    start = after + 2;
                    after = inputLine.indexOf("}", start);
                    item = Integer.parseInt(inputLine.substring(start, after));
                    start = after + 2;
                    after = inputLine.indexOf("p", start);
                    spec2[line][item].distFromMargin = dist = Misc.stringToFloat(inputLine.substring(start, after));
                }
                inputLine = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            Debug.ReportError("Error reading file: " + Parameters.LaTeXAlignmentFile + ".log\n" + "    written by LaTeX");
        }
        int line = 0;
        int arrayLen = 0;
        while (line < spec2.length) {
            arrayLen += spec2[line].length;
            ++line;
        }
        Object[] posCols = new PosAndCol[arrayLen];
        int arrayItem = 0;
        line = 0;
        while (line < spec2.length) {
            item = 0;
            while (item < spec2[line].length) {
                posCols[arrayItem] = new PosAndCol(line, item, spec2[line][item].column);
                ++item;
                ++arrayItem;
            }
            ++line;
        }
        Arrays.sort(posCols);
        int nextPos = 0;
        while (nextPos < posCols.length) {
            float savedPreSpace;
            Object pc = posCols[nextPos];
            Token tok = ((Position)pc).toToken(spec2);
            Debug.Assert(tok.preSpace == 0.0f, "preSpace already computed when it shouldn't have been");
            if (tok.belowAlign.line != -1) {
                float tokIndent;
                float maxIndent = tokIndent = LaTeXOutput.TotalIndent(spec2, new Position(((PosAndCol)pc).line, ((PosAndCol)pc).item));
                Position alPos = tok.belowAlign;
                while (alPos.line != -1) {
                    float f = LaTeXOutput.TotalIndent(spec2, alPos);
                    if (f > maxIndent) {
                        maxIndent = f;
                    }
                    alPos = alPos.toToken((Token[][])spec2).belowAlign;
                }
                tok.preSpace = maxIndent - tokIndent;
                Token ltok = null;
                int extraSpace = Integer.MAX_VALUE;
                if (((PosAndCol)pc).item > 1 || ((PosAndCol)pc).item == 1 && spec2[((PosAndCol)pc).line][0].type != 5) {
                    ltok = spec2[((PosAndCol)pc).line][((PosAndCol)pc).item - 1];
                    extraSpace = tok.column - (ltok.column + ltok.getWidth());
                }
                alPos = tok.belowAlign;
                while (alPos.line != -1) {
                    int sp;
                    if ((alPos.item > 1 || alPos.item == 1 && spec2[alPos.line][0].type != 5) && (sp = alPos.toToken((Token[][])spec2).column - (ltok.column + (ltok = spec2[alPos.line][alPos.item - 1]).getWidth())) < extraSpace) {
                        extraSpace = sp;
                    }
                    alPos = alPos.toToken((Token[][])spec2).belowAlign;
                }
                if (extraSpace == Integer.MAX_VALUE) {
                    extraSpace = 0;
                }
                if (--extraSpace > 0) {
                    tok.preSpace += Parameters.LaTeXLeftSpace(extraSpace);
                }
            }
            if (tok.aboveAlign.line == -1) {
                savedPreSpace = tok.preSpace;
                if (((PosAndCol)pc).item == 0) {
                    tok.preSpace = Parameters.LaTeXLeftSpace(tok.column);
                } else if (((PosAndCol)pc).item == 1 && spec2[((PosAndCol)pc).line][0].type == 5) {
                    tok.preSpace = Parameters.LaTeXLeftSpace(tok.column) - spec2[((PosAndCol)pc).line][0].preSpace;
                } else {
                    Token ltok = spec2[((PosAndCol)pc).line][((PosAndCol)pc).item - 1];
                    int extraSpace = tok.column - (ltok.column + ltok.getWidth()) - 1;
                    if (extraSpace > 0) {
                        tok.preSpace = Parameters.LaTeXLeftSpace(extraSpace);
                    }
                }
                if (tok.preSpace < savedPreSpace) {
                    tok.preSpace = savedPreSpace;
                }
            } else {
                savedPreSpace = tok.preSpace;
                tok.preSpace = 0.0f;
                tok.preSpace = LaTeXOutput.TotalIndent(spec2, tok.aboveAlign) - LaTeXOutput.TotalIndent(spec2, (Position)pc) + Parameters.LaTeXLeftSpace(tok.column - tok.aboveAlign.toToken((Token[][])spec2).column);
                if (tok.preSpace < savedPreSpace) {
                    tok.preSpace = savedPreSpace;
                }
                if (tok.preSpace < 0.0f) {
                    tok.preSpace = 0.0f;
                }
            }
            ++nextPos;
        }
    }

    private static int findInt(String str, int start) {
        int nextChar = start;
        while ('0' <= str.charAt(nextChar) && str.charAt(nextChar) <= '9') {
            ++nextChar;
        }
        return Integer.parseInt(str.substring(start, nextChar));
    }

    private static float findFloat(String str, int start) {
        int nextChar = start;
        while ('0' <= str.charAt(nextChar) && str.charAt(nextChar) <= '9' || str.charAt(nextChar) == '.') {
            ++nextChar;
        }
        return Misc.stringToFloat(str.substring(start, nextChar));
    }

    private static float TotalIndent(Token[][] spec2, Position pos) {
        float val = 0.0f;
        int item = 0;
        while (item <= pos.item) {
            val += spec2[pos.line][item].preSpace;
            ++item;
        }
        return val + pos.toToken((Token[][])spec2).distFromMargin;
    }

    private static float TotalIndentWithSpace(Token[][] spec2, Position pos) {
        int posOfFirstSpaceToLeft = 0;
        if (pos.item > 0) {
            Token tokToLeft = spec2[pos.line][pos.item - 1];
            posOfFirstSpaceToLeft = tokToLeft.column + tokToLeft.getWidth();
        }
        float spaceToLeft = Parameters.LaTeXLeftSpace(pos.toToken((Token[][])spec2).column - posOfFirstSpaceToLeft - 1);
        return spaceToLeft + LaTeXOutput.TotalIndent(spec2, pos);
    }

    private static String FixString(String inputStr) {
        String result = "";
        String str = Misc.TeXify(inputStr);
        int pos = 0;
        while (pos < str.length()) {
            char ch = str.charAt(pos);
            result = ch == ' ' ? String.valueOf(result) + "\\ " : (ch == '-' ? String.valueOf(result) + "{-}" : String.valueOf(result) + ch);
            ++pos;
        }
        return result;
    }

    static String PfStepString(String str) {
        int leftAnglePos = str.indexOf(62);
        return "\\@pfstepnum{" + str.substring(1, leftAnglePos) + "}{" + str.substring(leftAnglePos + 1) + "}";
    }

    public static void WriteLaTeXFile(Token[][] spec2) {
        OutputFileWriter writer = LaTeXOutput.StartLaTeXOutput(Parameters.LaTeXOutputFile);
        LaTeXOutput.InnerWriteLaTeXFile(spec2, writer, true);
        writer.putLine("\\end{document}");
        writer.close();
    }

    public static void WriteTLATeXEnvironment(Token[][] spec2, OutputFileWriter writer) {
        writer.putLine("\\begin{tlatex}");
        LaTeXOutput.InnerWriteLaTeXFile(spec2, writer, false);
        writer.putLine("\\end{tlatex}");
    }

    private static void InnerWriteLaTeXFile(Token[][] spec2, OutputFileWriter writer, boolean tlaMode) {
        int pcalEndLine;
        int pcalStartLine;
        Vector<String> commentVec = new Vector<String>(150);
        int line = 0;
        while (line < spec2.length && (spec2[line] == null || spec2[line].length == 0)) {
            ++line;
        }
        int item = 0;
        if (line < spec2.length && spec2[line][item].type == 8) {
            boolean endProlog = false;
            while (!endProlog && line < spec2.length) {
                if (spec2[line] == null || spec2[line].length == 0) {
                    commentVec.addElement("");
                    ++line;
                    continue;
                }
                if (spec2[line][0].type != 8) {
                    endProlog = true;
                    continue;
                }
                commentVec.addElement(spec2[line][0].string);
                if (spec2[line].length > 1) {
                    item = 1;
                    endProlog = true;
                    continue;
                }
                ++line;
            }
            if (Parameters.PrintProlog) {
                FormatComments.WriteComment(writer, commentVec, 3, 0.0f, tlaMode);
            }
        }
        if (Parameters.CommentShading) {
            writer.putLine("\\setboolean{shading}{true}");
        }
        boolean inBeginModule = false;
        boolean done = false;
        boolean inSub = false;
        boolean hasPcal = TokenizeSpec.hasPcal;
        if (TokenizeSpec.hasPcal) {
            pcalStartLine = TokenizeSpec.pcalStart.line;
            pcalEndLine = TokenizeSpec.pcalEnd.line;
        } else {
            pcalStartLine = Integer.MAX_VALUE;
            pcalEndLine = 0x7FFFFFFE;
        }
        boolean pcalLine = false;
        while (line < spec2.length) {
            if (tlaMode && TokenizeSpec.hasPcal) {
                boolean pcalLineNext;
                boolean bl = pcalLineNext = pcalStartLine <= line && line <= pcalEndLine;
                if (pcalLineNext && !pcalLine) {
                    writer.putLine("\\pcalsymbolstrue");
                    if (Parameters.CommentShading && !Parameters.NoPlusCalShading) {
                        writer.putLine("\\pcalshadingtrue");
                    }
                    if (TokenizeSpec.isCSyntax) {
                        writer.putLine("\\csyntaxtrue");
                    } else {
                        writer.putLine("\\csyntaxfalse");
                    }
                }
                if (pcalLine && !pcalLineNext) {
                    writer.putLine("\\pcalshadingfalse \\pcalsymbolsfalse");
                }
                pcalLine = pcalLineNext;
            }
            if (spec2[line].length == 0) {
                int blankLines = 0;
                while (line < spec2.length && spec2[line].length == 0) {
                    ++blankLines;
                    ++line;
                }
                writer.putLine("\\@pvspace{" + Misc.floatToString(Parameters.LaTeXVSpace(blankLines), 2) + "pt}%");
                continue;
            }
            Debug.Assert(spec2[line].length != 0, "LaTeXOutput.WriteLaTeXFile: Unprocessed or unskipped blank line.");
            String outLine = "";
            boolean openLine = false;
            boolean issueVSpace = false;
            if (spec2[line][0].type == 5 && (((CommentToken)spec2[line][0]).subtype == 8 || ((CommentToken)spec2[line][0]).subtype == 9)) {
                issueVSpace = true;
                int i = line;
                boolean endSearch = false;
                while (issueVSpace && !endSearch && i < spec2.length) {
                    Token bATok = null;
                    if (spec2[i][0].belowAlign.line != -1) {
                        bATok = spec2[i][0].belowAlign.toToken(spec2);
                    }
                    if (spec2[i][0].belowAlign.line == -1 || bATok.type != 5 || ((CommentToken)bATok).subtype != 8 && ((CommentToken)bATok).subtype != 9) {
                        endSearch = true;
                        continue;
                    }
                    if (spec2[i][0].belowAlign.item != 0) {
                        issueVSpace = false;
                        endSearch = true;
                        continue;
                    }
                    ++i;
                }
                if (issueVSpace) {
                    int count = line - spec2[line][0].aboveAlign.line;
                    writer.putLine("\\multivspace{" + count + "}%");
                    line = i;
                    outLine = "";
                    openLine = false;
                }
            }
            if (!issueVSpace) {
                outLine = "\\@x{";
                openLine = true;
                if (Parameters.PrintLineNumbers) {
                    outLine = String.valueOf(outLine) + "\\makebox[0pt][r]{\\scriptsize " + (line + 1) + "\\hspace{1em}}";
                }
                while (!done && item < spec2[line].length) {
                    Debug.Assert(openLine, "LaTeXOutput.WriteLaTeXFile: prematurely closed line");
                    Token tok = spec2[line][item];
                    Position pos = new Position(line, item);
                    if (inSub && !tok.subscript) {
                        inSub = false;
                        outLine = String.valueOf(outLine) + "}";
                    }
                    if (tok.preSpace >= Misc.stringToFloat("0.01")) {
                        outLine = String.valueOf(outLine) + "\\@s" + "{" + Misc.floatToString(tok.preSpace, 2) + "}";
                    }
                    block0 : switch (tok.type) {
                        case 1: {
                            int symType = BuiltInSymbols.GetBuiltInSymbol((String)spec2[line][item].string, (boolean)true).symbolType;
                            if (!inSub && (symType == 6 || tok.string.equals("^")) && item + 1 < spec2[line].length && spec2[line][item + 1].subscript) {
                                inSub = true;
                                if (symType == 6) {
                                    outLine = String.valueOf(outLine) + " " + BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).TeXString + "_{";
                                    break;
                                }
                                outLine = String.valueOf(outLine) + " " + "^{";
                                break;
                            }
                            outLine = String.valueOf(outLine) + " " + BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).TeXString;
                            break;
                        }
                        case 2: {
                            outLine = String.valueOf(outLine) + " " + Misc.TeXify(tok.string);
                            break;
                        }
                        case 4: {
                            outLine = String.valueOf(outLine) + " " + Misc.TeXifyIdent(tok.string);
                            break;
                        }
                        case 13: {
                            outLine = String.valueOf(outLine) + " " + Misc.TeXifyPcalLabel(tok.string);
                            break;
                        }
                        case 3: {
                            outLine = String.valueOf(outLine) + "\\@w" + "{" + LaTeXOutput.FixString(tok.string) + "}";
                            break;
                        }
                        case 12: {
                            outLine = String.valueOf(outLine) + LaTeXOutput.PfStepString(tok.string);
                            if (!((Token.PfStepToken)tok).needsSpace) break;
                            outLine = String.valueOf(outLine) + "\\ ";
                            break;
                        }
                        case 5: {
                            CommentToken ctok = (CommentToken)tok;
                            switch (ctok.subtype) {
                                case 6: {
                                    Misc.BreakStringOut(writer, String.valueOf(outLine) + "}%");
                                    Vector<String> vec = new Vector<String>(2);
                                    vec.addElement(tok.string);
                                    if (item == 0 && spec2[line].length > 1) {
                                        FormatComments.WriteComment(writer, vec, 2, 0.0f, tlaMode);
                                    } else {
                                        FormatComments.WriteComment(writer, vec, 1, 0.0f, tlaMode);
                                    }
                                    outLine = "\\@xx{";
                                    break block0;
                                }
                                case 7: {
                                    float commentWidth = (float)Parameters.LaTeXtextwidth - LaTeXOutput.TotalIndent(spec2, pos);
                                    Vector<String> mlineVector = new Vector<String>();
                                    Position nextPos = ctok.belowAlign;
                                    boolean more = true;
                                    Token ntok = null;
                                    int lastLine = pos.line;
                                    while (more && nextPos.line != -1) {
                                        ntok = nextPos.toToken(spec2);
                                        if (ntok.type == 5 && ((CommentToken)ntok).subtype == 8) {
                                            mlineVector.addElement(ntok.string);
                                            lastLine = nextPos.line;
                                            nextPos = ntok.belowAlign;
                                            continue;
                                        }
                                        more = false;
                                    }
                                    if (nextPos.line != -1 && ntok.type == 5 && ((CommentToken)ntok).subtype == 9) {
                                        lastLine = nextPos.line;
                                    }
                                    boolean parMulti = true;
                                    Position cPos = pos;
                                    while (parMulti && cPos.line < lastLine) {
                                        parMulti = cPos.item == 0;
                                        cPos = cPos.toToken((Token[][])spec2).belowAlign;
                                    }
                                    boolean bl = parMulti = parMulti && cPos.item == 0;
                                    if (parMulti) {
                                        outLine = "";
                                        openLine = false;
                                        FormatComments.WriteComment(writer, mlineVector, 3, LaTeXOutput.TotalIndent(spec2, pos), tlaMode);
                                        line = lastLine;
                                        break block0;
                                    }
                                    Misc.BreakStringOut(writer, String.valueOf(outLine) + "}%");
                                    outLine = "";
                                    openLine = false;
                                    FormatComments.WriteComment(writer, mlineVector, 4, commentWidth, tlaMode);
                                    break block0;
                                }
                                case 8: 
                                case 9: {
                                    break block0;
                                }
                                case 10: {
                                    outLine = "";
                                    openLine = false;
                                    Debug.Assert(outLine.equals(""), "Non-empty outLine at beginning of PAR comment");
                                    Vector<String> lineVector = new Vector<String>();
                                    String spaces = "  ";
                                    int j = 0;
                                    while (j < tok.column) {
                                        spaces = String.valueOf(spaces) + " ";
                                        ++j;
                                    }
                                    lineVector.addElement(String.valueOf(spaces) + tok.string);
                                    while (line + 1 < spec2.length && (spec2[line + 1].length == 0 || spec2[line + 1][0].type == 5 && ((CommentToken)spec2[line + 1][0]).subtype == 10)) {
                                        if (spec2[line + 1].length == 0) {
                                            lineVector.add("");
                                        } else {
                                            lineVector.add(spec2[line + 1][0].string);
                                        }
                                        ++line;
                                    }
                                    FormatComments.WriteComment(writer, lineVector, 3, -2.0f, tlaMode);
                                    break block0;
                                }
                            }
                            Debug.ReportBug("Bad comment token subtype at position (" + line + ", " + item + ")\n" + "    in LaTeXOutput.WriteAlignmentFile");
                            break;
                        }
                        case 6: {
                            if (inBeginModule) {
                                outLine = String.valueOf(outLine) + "}" + "\\moduleRightDash\\@xx" + "{";
                                inBeginModule = false;
                                break;
                            }
                            if (item + 1 < spec2[line].length && spec2[line][item + 1].string.equals("MODULE")) {
                                outLine = String.valueOf(outLine) + "}" + "\\moduleLeftDash\\@xx" + "{";
                                inBeginModule = true;
                                break;
                            }
                            outLine = String.valueOf(outLine) + "}" + "\\midbar\\@xx" + "{";
                            break;
                        }
                        case 7: {
                            outLine = String.valueOf(outLine) + "}" + "\\bottombar\\@xx" + "{";
                            break;
                        }
                        case 9: {
                            if (item != 0) {
                                Misc.BreakStringOut(writer, String.valueOf(outLine) + "}%");
                                ++line;
                            }
                            outLine = null;
                            openLine = false;
                            if (Parameters.PrintEpilog) {
                                writer.putLine("\\setboolean{shading}{false}");
                                Vector<String> lineVector = new Vector<String>();
                                while (line < spec2.length) {
                                    if (spec2[line].length == 0) {
                                        lineVector.addElement("");
                                    } else {
                                        lineVector.addElement(spec2[line][0].string);
                                    }
                                    ++line;
                                }
                                FormatComments.WriteComment(writer, lineVector, 3, 0.0f, tlaMode);
                            }
                            done = true;
                            break;
                        }
                        default: {
                            Debug.ReportBug("Bad token type at position (" + line + ", " + item + ")\n" + "    in LaTeXOutput.WriteLaTeXFile");
                        }
                    }
                    ++item;
                }
            }
            if (inSub) {
                Debug.Assert(outLine != null, "Unclosed sub/superscript command at end of line");
                outLine = String.valueOf(outLine) + "}";
                inSub = false;
            }
            if (openLine) {
                Misc.BreakStringOut(writer, String.valueOf(outLine) + "}%");
            }
            outLine = "";
            item = 0;
            ++line;
        }
    }

    protected static String prependMetaDirToFileName(String fileName) {
        String outputFileName = fileName;
        if (!Parameters.MetaDir.equals("")) {
            outputFileName = String.valueOf(Parameters.MetaDir) + File.separator + outputFileName;
        }
        ToolIO.out.println("looking for file: " + outputFileName);
        return outputFileName;
    }
}

