/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.AST;
import pcal.PcalDebug;
import pcal.TLAExpr;
import pcal.exception.PcalSymTabException;

public class PcalSymTab {
    public Vector symtab = new Vector();
    public Vector procs;
    public Vector processes;
    public Vector disambiguateReport = new Vector();
    public String errorReport = "";
    public String iPC = null;
    public static final int num_vtypes = 7;
    public static final int GLOBAL = 0;
    public static final int LABEL = 1;
    public static final int PROCEDURE = 2;
    public static final int PROCESS = 3;
    public static final int PROCESSVAR = 4;
    public static final int PROCEDUREVAR = 5;
    public static final int PARAMETER = 6;
    private static String[] typePrefix = new String[]{"", "", "", "", "", "", ""};
    public static String[] vtypeName = new String[]{"Global variable", "Label", "Procedure", "Process", "Process variable", "Procedure variable", "Parameter"};

    public PcalSymTab(AST ast) throws PcalSymTabException {
        this.procs = new Vector();
        this.processes = new Vector();
        this.InsertSym(0, "pc", "", "", 0, 0);
        this.ExtractSym(ast, "");
        if (this.errorReport.length() > 0) {
            throw new PcalSymTabException(this.errorReport);
        }
    }

    public boolean InsertSym(int type, String id, String context, String cType, int line, int col) {
        if (type == 5 || type == 4 || type == 6) {
            int i = this.FindSym(0, id, "");
            if (i < this.symtab.size()) {
                return false;
            }
            i = this.FindSym(id, context);
            if (i < this.symtab.size()) {
                return false;
            }
        } else {
            int i = this.FindSym(type, id, context);
            if (i < this.symtab.size()) {
                return false;
            }
        }
        SymTabEntry se = new SymTabEntry(type, id, context, cType, line, col);
        this.symtab.addElement(se);
        return true;
    }

    public boolean InsertProc(AST.Procedure proc) {
        int i = this.FindProc(proc.name);
        if (i < this.procs.size()) {
            return false;
        }
        ProcedureEntry pe = new ProcedureEntry(proc);
        this.procs.addElement(pe);
        return true;
    }

    public boolean InsertProcess(AST.Process p) {
        int i = this.FindProcess(p.name);
        if (i < this.processes.size()) {
            return false;
        }
        ProcessEntry pe = new ProcessEntry(p);
        this.processes.addElement(pe);
        return true;
    }

    public int FindSym(int type, String id, String context) {
        int i = 0;
        while (i < this.symtab.size()) {
            SymTabEntry se = (SymTabEntry)this.symtab.elementAt(i);
            if (se.id.equals(id) && se.context.equals(context) && se.type == type) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public int FindSym(String id, String context) {
        int i = 0;
        while (i < this.symtab.size()) {
            SymTabEntry se = (SymTabEntry)this.symtab.elementAt(i);
            if (se.id.equals(id) && se.context.equals(context)) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public int FindProc(String id) {
        int i = 0;
        while (i < this.procs.size()) {
            ProcedureEntry pe = (ProcedureEntry)this.procs.elementAt(i);
            if (pe.name.equals(id)) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public int FindProcess(String id) {
        int i = 0;
        while (i < this.processes.size()) {
            ProcessEntry pe = (ProcessEntry)this.processes.elementAt(i);
            if (pe.name.equals(id)) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public String UseThis(int type, String id, String context) {
        int i = this.FindSym(type, id, context);
        if (i == this.symtab.size()) {
            return id;
        }
        return ((SymTabEntry)this.symtab.elementAt((int)i)).useThis;
    }

    public String UseThisLab(String id, String context) {
        return this.UseThis(1, id, context);
    }

    public String UseThisVar(String id, String context) {
        SymTabEntry se = null;
        int i = this.FindSym(id, context);
        if (i == this.symtab.size()) {
            return id;
        }
        se = (SymTabEntry)this.symtab.elementAt(i);
        if (se.type == 0 || se.type == 4 || se.type == 5 || se.type == 6) {
            return se.useThis;
        }
        i = this.FindSym(id, "");
        if (se.type == 0) {
            return se.useThis;
        }
        return id;
    }

    public String UseThis(String id, String context) {
        int i = 0;
        while (i < this.symtab.size()) {
            SymTabEntry se = (SymTabEntry)this.symtab.elementAt(i);
            if (se.id.equals(id) && se.context.equals(context) && (se.type == 0 || se.type == 4 || se.type == 5 || se.type == 6)) break;
            ++i;
        }
        if (i == this.symtab.size()) {
            return id;
        }
        return ((SymTabEntry)this.symtab.elementAt((int)i)).useThis;
    }

    private boolean Ambiguous(String id) {
        int i = 0;
        boolean found = false;
        while (i < this.symtab.size()) {
            SymTabEntry se = (SymTabEntry)this.symtab.elementAt(i);
            if (se.useThis.equals(id)) {
                if (!found) {
                    found = true;
                } else {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void Disambiguate() {
        int vtype = 0;
        while (vtype <= 7) {
            int i = 0;
            while (i < this.symtab.size()) {
                SymTabEntry se = (SymTabEntry)this.symtab.elementAt(i);
                if (se.type == vtype) {
                    se.useThis = String.valueOf(typePrefix[vtype]) + se.id;
                    int suffixLength = 0;
                    while (vtype > 0 && this.Ambiguous(se.useThis)) {
                        se.useThis = ++suffixLength == 1 ? String.valueOf(se.useThis) + "_" : (suffixLength > se.context.length() + 1 ? String.valueOf(se.useThis) + vtype : String.valueOf(se.useThis) + se.context.charAt(suffixLength - 2));
                    }
                    if (!se.id.equals(se.useThis)) {
                        this.disambiguateReport.addElement("\\* " + vtypeName[se.type] + " " + se.id + (se.context.length() == 0 ? "" : " of " + se.cType + " " + se.context) + " at line " + se.line + " col " + se.col + " changed to " + se.useThis);
                    }
                }
                ++i;
            }
            ++vtype;
        }
    }

    public String toString() {
        int i = 0;
        String result = "[";
        while (i < this.symtab.size()) {
            SymTabEntry se = (SymTabEntry)this.symtab.elementAt(i);
            if (i > 0) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + vtypeName[se.type] + " " + se.context + ':' + se.id + " line " + se.line + " col " + se.col + " (" + se.useThis + ")";
            ++i;
        }
        return String.valueOf(result) + "]";
    }

    private void ExtractSym(AST ast, String context) {
        if (ast.getClass().equals(AST.UniprocessObj.getClass())) {
            this.ExtractUniprocess((AST.Uniprocess)ast, context);
        } else if (ast.getClass().equals(AST.MultiprocessObj.getClass())) {
            this.ExtractMultiprocess((AST.Multiprocess)ast, context);
        } else {
            PcalDebug.ReportBug("Unexpected AST type.");
        }
    }

    private void ExtractStmt(AST ast, String context, String cType) {
        if (ast.getClass().equals(AST.WhileObj.getClass())) {
            this.ExtractWhile((AST.While)ast, context, cType);
        } else if (ast.getClass().equals(AST.AssignObj.getClass())) {
            this.ExtractAssign((AST.Assign)ast, context, cType);
        } else if (ast.getClass().equals(AST.IfObj.getClass())) {
            this.ExtractIf((AST.If)ast, context, cType);
        } else if (ast.getClass().equals(AST.WithObj.getClass())) {
            this.ExtractWith((AST.With)ast, context, cType);
        } else if (ast.getClass().equals(AST.WhenObj.getClass())) {
            this.ExtractWhen((AST.When)ast, context, cType);
        } else if (ast.getClass().equals(AST.PrintSObj.getClass())) {
            this.ExtractPrintS((AST.PrintS)ast, context, cType);
        } else if (ast.getClass().equals(AST.AssertObj.getClass())) {
            this.ExtractAssert((AST.Assert)ast, context, cType);
        } else if (ast.getClass().equals(AST.SkipObj.getClass())) {
            this.ExtractSkip((AST.Skip)ast, context, cType);
        } else if (ast.getClass().equals(AST.LabelIfObj.getClass())) {
            this.ExtractLabelIf((AST.LabelIf)ast, context, cType);
        } else if (ast.getClass().equals(AST.CallObj.getClass())) {
            this.ExtractCall((AST.Call)ast, context, cType);
        } else if (ast.getClass().equals(AST.ReturnObj.getClass())) {
            this.ExtractReturn((AST.Return)ast, context, cType);
        } else if (ast.getClass().equals(AST.CallReturnObj.getClass())) {
            this.ExtractCallReturn((AST.CallReturn)ast, context, cType);
        } else if (ast.getClass().equals(AST.CallGotoObj.getClass())) {
            this.ExtractCallGoto((AST.CallGoto)ast, context, cType);
        } else if (ast.getClass().equals(AST.GotoObj.getClass())) {
            this.ExtractGoto((AST.Goto)ast, context, cType);
        } else if (ast.getClass().equals(AST.EitherObj.getClass())) {
            this.ExtractEither((AST.Either)ast, context, cType);
        } else if (ast.getClass().equals(AST.LabelEitherObj.getClass())) {
            this.ExtractLabelEither((AST.LabelEither)ast, context, cType);
        } else {
            PcalDebug.ReportBug("Unexpected AST type " + ast.toString());
        }
    }

    private void ExtractUniprocess(AST.Uniprocess ast, String context) {
        if (ast.prcds.size() > 0) {
            this.InsertSym(0, "stack", "", "", 0, 0);
        }
        int i = 0;
        while (i < ast.decls.size()) {
            this.ExtractVarDecl((AST.VarDecl)ast.decls.elementAt(i), "");
            ++i;
        }
        i = 0;
        while (i < ast.prcds.size()) {
            this.ExtractProcedure((AST.Procedure)ast.prcds.elementAt(i), "");
            ++i;
        }
        if (ast.body.size() > 0) {
            AST.LabeledStmt ls = (AST.LabeledStmt)ast.body.elementAt(0);
            this.iPC = ls.label;
        }
        i = 0;
        while (i < ast.body.size()) {
            this.ExtractLabeledStmt((AST.LabeledStmt)ast.body.elementAt(i), "", "");
            ++i;
        }
    }

    private void ExtractMultiprocess(AST.Multiprocess ast, String context) {
        if (ast.prcds.size() > 0) {
            this.InsertSym(0, "stack", "", "", 0, 0);
        }
        int i = 0;
        while (i < ast.decls.size()) {
            this.ExtractVarDecl((AST.VarDecl)ast.decls.elementAt(i), "");
            ++i;
        }
        i = 0;
        while (i < ast.prcds.size()) {
            this.ExtractProcedure((AST.Procedure)ast.prcds.elementAt(i), "");
            ++i;
        }
        i = 0;
        while (i < ast.procs.size()) {
            this.ExtractProcess((AST.Process)ast.procs.elementAt(i), "");
            ++i;
        }
    }

    private void ExtractProcedure(AST.Procedure ast, String context) {
        if (!this.InsertProc(ast)) {
            this.errorReport = String.valueOf(this.errorReport) + "\nProcedure " + ast.name + " redefined at line " + ast.line + ", column " + ast.col;
        }
        boolean b = this.InsertSym(2, ast.name, context, "procedure", ast.line, ast.col);
        int i = 0;
        while (i < ast.decls.size()) {
            this.ExtractPVarDecl((AST.PVarDecl)ast.decls.elementAt(i), ast.name);
            ++i;
        }
        i = 0;
        while (i < ast.params.size()) {
            this.ExtractParamDecl((AST.PVarDecl)ast.params.elementAt(i), ast.name);
            ++i;
        }
        i = 0;
        while (i < ast.body.size()) {
            this.ExtractLabeledStmt((AST.LabeledStmt)ast.body.elementAt(i), ast.name, "procedure");
            ++i;
        }
    }

    private void ExtractProcess(AST.Process ast, String context) {
        if (!this.InsertProcess(ast)) {
            this.errorReport = String.valueOf(this.errorReport) + "\nProcess " + ast.name + " redefined at line " + ast.line + ", column " + ast.col;
        }
        boolean b = this.InsertSym(3, ast.name, context, "process", ast.line, ast.col);
        int i = 0;
        while (i < ast.decls.size()) {
            this.ExtractVarDecl((AST.VarDecl)ast.decls.elementAt(i), ast.name);
            ++i;
        }
        i = 0;
        while (i < ast.body.size()) {
            this.ExtractLabeledStmt((AST.LabeledStmt)ast.body.elementAt(i), ast.name, "process");
            ++i;
        }
    }

    private void ExtractVarDecl(AST.VarDecl ast, String context) {
        int vtype;
        int n = vtype = context.isEmpty() ? 0 : 4;
        if (!this.InsertSym(vtype, ast.var, context, "process", ast.line, ast.col)) {
            this.errorReport = String.valueOf(this.errorReport) + "\n" + vtypeName[vtype] + " " + ast.var + " redefined at line " + ast.line + ", column " + ast.col;
        }
    }

    private void ExtractPVarDecl(AST.PVarDecl ast, String context) {
        if (!this.InsertSym(5, ast.var, context, "procedure", ast.line, ast.col)) {
            this.errorReport = String.valueOf(this.errorReport) + "\nProcedure variable " + ast.var + " redefined at line " + ast.line + ", column " + ast.col;
        }
    }

    private void ExtractParamDecl(AST.PVarDecl ast, String context) {
        if (!this.InsertSym(6, ast.var, context, "procedure", ast.line, ast.col)) {
            this.errorReport = String.valueOf(this.errorReport) + "\nParameter " + ast.var + " redefined at line " + ast.line + ", column " + ast.col;
        }
    }

    private void ExtractLabeledStmt(AST.LabeledStmt ast, String context, String cType) {
        if (!this.InsertSym(1, ast.label, context, cType, ast.line, ast.col)) {
            this.errorReport = String.valueOf(this.errorReport) + "\nLabel " + ast.label + " redefined at line " + ast.line + ", column " + ast.col;
        }
        int i = 0;
        while (i < ast.stmts.size()) {
            this.ExtractStmt((AST)ast.stmts.elementAt(i), context, cType);
            ++i;
        }
    }

    private void ExtractWhile(AST.While ast, String context, String cType) {
        int i = 0;
        while (i < ast.unlabDo.size()) {
            this.ExtractStmt((AST)ast.unlabDo.elementAt(i), context, cType);
            ++i;
        }
        i = 0;
        while (i < ast.labDo.size()) {
            this.ExtractLabeledStmt((AST.LabeledStmt)ast.labDo.elementAt(i), context, cType);
            ++i;
        }
    }

    private void ExtractAssign(AST.Assign ast, String context, String cType) {
    }

    private void ExtractIf(AST.If ast, String context, String cType) {
        int i = 0;
        while (i < ast.Then.size()) {
            this.ExtractStmt((AST)ast.Then.elementAt(i), context, cType);
            ++i;
        }
        i = 0;
        while (i < ast.Else.size()) {
            this.ExtractStmt((AST)ast.Else.elementAt(i), context, cType);
            ++i;
        }
    }

    private void ExtractWith(AST.With ast, String context, String cType) {
        int i = 0;
        while (i < ast.Do.size()) {
            this.ExtractStmt((AST)ast.Do.elementAt(i), context, cType);
            ++i;
        }
    }

    private void ExtractWhen(AST.When ast, String context, String cType) {
    }

    private void ExtractPrintS(AST.PrintS ast, String context, String cType) {
    }

    private void ExtractAssert(AST.Assert ast, String context, String cType) {
    }

    private void ExtractSkip(AST.Skip ast, String context, String cType) {
    }

    private void ExtractLabelIf(AST.LabelIf ast, String context, String cType) {
        int i = 0;
        while (i < ast.unlabThen.size()) {
            this.ExtractStmt((AST)ast.unlabThen.elementAt(i), context, cType);
            ++i;
        }
        i = 0;
        while (i < ast.labThen.size()) {
            this.ExtractLabeledStmt((AST.LabeledStmt)ast.labThen.elementAt(i), context, cType);
            ++i;
        }
        i = 0;
        while (i < ast.unlabElse.size()) {
            this.ExtractStmt((AST)ast.unlabElse.elementAt(i), context, cType);
            ++i;
        }
        i = 0;
        while (i < ast.labElse.size()) {
            this.ExtractLabeledStmt((AST.LabeledStmt)ast.labElse.elementAt(i), context, cType);
            ++i;
        }
    }

    private void ExtractCall(AST.Call ast, String context, String cType) {
    }

    private void ExtractReturn(AST.Return ast, String context, String cType) {
    }

    private void ExtractCallReturn(AST.CallReturn ast, String context, String cType) {
    }

    private void ExtractCallGoto(AST.CallGoto ast, String context, String cType) {
    }

    private void ExtractGoto(AST.Goto ast, String context, String cType) {
    }

    private void ExtractEither(AST.Either ast, String context, String cType) {
        int i = 0;
        while (i < ast.ors.size()) {
            Vector orClause = (Vector)ast.ors.elementAt(i);
            int j = 0;
            while (j < orClause.size()) {
                this.ExtractStmt((AST)orClause.elementAt(j), context, cType);
                ++j;
            }
            ++i;
        }
    }

    private void ExtractLabelEither(AST.LabelEither ast, String context, String cType) {
        int i = 0;
        while (i < ast.clauses.size()) {
            AST.Clause orClause = (AST.Clause)ast.clauses.elementAt(i);
            int j = 0;
            while (j < orClause.unlabOr.size()) {
                this.ExtractStmt((AST)orClause.unlabOr.elementAt(j), context, cType);
                ++j;
            }
            j = 0;
            while (j < orClause.labOr.size()) {
                this.ExtractLabeledStmt((AST.LabeledStmt)orClause.labOr.elementAt(j), context, cType);
                ++j;
            }
            ++i;
        }
    }

    public void CheckForDefaultInitValue() throws PcalSymTabException {
        String errors = "";
        int i = 0;
        while (i < this.symtab.size()) {
            SymTabEntry se = (SymTabEntry)this.symtab.elementAt(i);
            if (se.id.equals("defaultInitValue")) {
                errors = errors.equals("") ? "Cannot use `defaultInitValue' as " : String.valueOf(errors) + " or ";
                errors = String.valueOf(errors) + vtypeName[se.type] + " name";
            }
            ++i;
        }
        if (!errors.equals("")) {
            throw new PcalSymTabException(errors);
        }
    }

    public class ProcedureEntry {
        public String name;
        public Vector params;
        public Vector decls;
        public String iPC;
        public AST.Procedure ast;

        public ProcedureEntry(AST.Procedure p) {
            this.name = p.name;
            this.params = p.params;
            this.decls = p.decls;
            this.ast = p;
            if (p.body.size() == 0) {
                this.iPC = null;
            } else {
                AST.LabeledStmt ls = (AST.LabeledStmt)p.body.elementAt(0);
                this.iPC = ls.label;
            }
        }
    }

    public class ProcessEntry {
        public String name;
        public boolean isEq;
        public TLAExpr id;
        public Vector decls;
        public String iPC;
        public AST.Process ast;

        public ProcessEntry(AST.Process p) {
            this.name = p.name;
            this.isEq = p.isEq;
            this.id = p.id;
            this.decls = p.decls;
            this.ast = p;
            if (p.body.size() == 0) {
                this.iPC = null;
            } else {
                AST.LabeledStmt ls = (AST.LabeledStmt)p.body.elementAt(0);
                this.iPC = ls.label;
            }
        }
    }

    public class SymTabEntry {
        public int type;
        public String id;
        public String context;
        public String cType;
        public int line;
        public int col;
        public String useThis;

        public SymTabEntry(int type, String id, String context, String cType, int line, int col) {
            this.type = type;
            this.id = id;
            this.context = context;
            this.cType = cType;
            this.line = line;
            this.col = col;
            this.useThis = id;
        }

        public String toString() {
            return "[id: " + this.id + ", usethis: " + this.useThis + ", line: " + this.line + ", col:" + this.col + ", type: " + this.type + ", context: " + this.context + "]";
        }
    }
}

