/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.AST;
import pcal.exception.UnrecoverableException;
import pcal.exception.UnrecoverablePositionedException;
import util.ToolIO;

public class PcalDebug {
    public static final String UNRECOVERABLE_ERROR = "\nUnrecoverable error:\n -- ";
    public static final String WARNING = "Warning: ";
    public static final String ERROR_POSTFIX = ".\n";

    public static void reportError(UnrecoverableException e) {
        if (e instanceof UnrecoverablePositionedException) {
            PcalDebug.reportError(e.getMessage(), ((UnrecoverablePositionedException)e).getPosition());
        } else {
            PcalDebug.reportError(e.getMessage());
        }
    }

    public static void reportWarning(String warningText) {
        ToolIO.out.println(new StringBuffer(WARNING).append(warningText));
    }

    public static void reportInfo(String infoText) {
        ToolIO.out.println(infoText);
    }

    public static void reportError(String message) {
        ToolIO.out.println(new StringBuffer(UNRECOVERABLE_ERROR).append(message).append(ERROR_POSTFIX).toString());
    }

    public static void reportError(String message, AST ast) {
        if (ast == null || ast.line == 0) {
            PcalDebug.reportError(message);
        } else {
            PcalDebug.reportError(String.valueOf(message) + "\n    at " + ast.location());
        }
    }

    public static void Assert(boolean val) {
        if (!val) {
            PcalDebug.ReportBug("Assertion failure");
        }
    }

    public static void Assert(boolean val, String msg) {
        if (!val) {
            PcalDebug.ReportBug("Failure of assertion: " + msg);
        }
    }

    public static void ReportBug(String msg) {
        StringBuilder sb = new StringBuilder("You have discovered a bug in pcal.trans.\n");
        sb.append("Send the following information and the\ninput file to the current maintainer(s).\n\n -- ");
        sb.append(msg).append(".");
        ToolIO.out.println("");
        ToolIO.out.println(sb.toString());
        ToolIO.out.println("");
        throw new Error(sb.toString());
    }

    public static void printObjectArray(Object[] array, String name) {
        if (array == null) {
            ToolIO.out.println(String.valueOf(name) + " == null");
            return;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == null) {
                ToolIO.out.println(String.valueOf(name) + "[" + i + "] = null");
            } else {
                ToolIO.out.println(String.valueOf(name) + "[" + i + "] = " + array[i].toString());
            }
            ++i;
        }
        if (array.length == 0) {
            ToolIO.out.println(String.valueOf(name) + " = zero-length array");
        }
    }

    public static void printIntArray(int[] array, String name) {
        if (array == null) {
            ToolIO.out.println(String.valueOf(name) + " == null");
            return;
        }
        int i = 0;
        while (i < array.length) {
            ToolIO.out.println(String.valueOf(name) + "[" + i + "] = " + array[i]);
            ++i;
        }
        if (array.length == 0) {
            ToolIO.out.println(String.valueOf(name) + " = zero-length array");
        }
    }

    public static void print2DArray(Object[][] array, String name) {
        if (array == null) {
            ToolIO.out.println(String.valueOf(name) + " == null");
            return;
        }
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                ToolIO.out.println(String.valueOf(name) + "[" + i + "][" + j + "] = " + array[i][j].toString());
                ++j;
            }
            if (array[i].length == 0) {
                ToolIO.out.println(String.valueOf(name) + "[" + i + "] = null");
            }
            ++i;
        }
        if (array.length == 0) {
            ToolIO.out.println(String.valueOf(name) + " = zero-length array");
        }
    }

    public static void printVector(Vector vec, String name) {
        if (vec == null) {
            ToolIO.out.println(String.valueOf(name) + " == null");
            return;
        }
        int i = 0;
        while (i < vec.size()) {
            if (vec.elementAt(i) == null) {
                ToolIO.out.println(String.valueOf(name) + "[" + i + "] = null");
            } else {
                ToolIO.out.println(String.valueOf(name) + "[" + i + "] = " + vec.elementAt(i).toString());
            }
            ++i;
        }
        if (vec.size() == 0) {
            ToolIO.out.println(String.valueOf(name) + " = zero-length vec");
        }
    }

    public static void print2DVector(Vector vec, String name) {
        if (vec == null) {
            ToolIO.out.println(String.valueOf(name) + " == null");
            return;
        }
        int i = 0;
        while (i < vec.size()) {
            if (vec.elementAt(i) == null) {
                ToolIO.out.println(String.valueOf(name) + "[" + i + "] = null");
            } else {
                PcalDebug.printVector((Vector)vec.elementAt(i), String.valueOf(name) + "[" + i + "]");
            }
            ++i;
        }
        if (vec.size() == 0) {
            ToolIO.out.println(String.valueOf(name) + " = zero-length vec");
        }
    }

    public static String pair(int i, int j) {
        return "(" + i + ", " + j + ")";
    }

    public static void printPair(int i, int j) {
        ToolIO.out.println(PcalDebug.pair(i, j));
    }
}

