/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.PrintStream;
import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.PossibleErrorModel;
import tlc2.tool.liveness.TBGraph;
import tlc2.util.BitVector;

public class OrderOfSolution {
    private final TBGraph tableau;
    private final LNEven[] promises;
    private LiveExprNode[] checkState;
    private LiveExprNode[] checkAction;
    private PossibleErrorModel[] pems;

    public OrderOfSolution(LNEven[] livenessEventually) {
        this(null, livenessEventually);
    }

    public OrderOfSolution(TBGraph aTableau, LNEven[] livenessEventually) {
        this.tableau = aTableau;
        this.promises = livenessEventually;
    }

    public final void printPromises(PrintStream ps) {
        int i = 0;
        while (i < this.getPromises().length) {
            ps.println(this.getPromises()[i].toString());
            ++i;
        }
    }

    public final String toString() {
        if (this.getPems().length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        this.toString(sb);
        return sb.toString();
    }

    public final void toString(StringBuffer sb) {
        String padding = "";
        int plen = this.getPems().length;
        if (this.hasTableau()) {
            if (plen == 1 && this.getPems()[0].isEmpty()) {
                this.getTableau().tf.toString(sb, "   ");
                return;
            }
            sb.append("/\\ ");
            this.getTableau().tf.toString(sb, "   ");
            sb.append("\n/\\ ");
            padding = "   ";
        }
        if (plen == 1) {
            this.getPems()[0].toString(sb, padding, this.checkState, this.getCheckAction());
        } else {
            sb.append("\\/ ");
            String padding1 = String.valueOf(padding) + "   ";
            this.getPems()[0].toString(sb, padding1, this.checkState, this.getCheckAction());
            int i = 1;
            while (i < plen) {
                sb.append(String.valueOf(padding) + "\\/ ");
                this.getPems()[i].toString(sb, padding1, this.checkState, this.getCheckAction());
                ++i;
            }
        }
    }

    public TBGraph getTableau() {
        return this.tableau;
    }

    public boolean hasTableau() {
        return this.tableau != null;
    }

    public LNEven[] getPromises() {
        return this.promises;
    }

    public LiveExprNode[] getCheckState() {
        return this.checkState;
    }

    public boolean[] checkState(ITool tool, TLCState state) {
        boolean[] result = new boolean[this.checkState.length];
        int i = 0;
        while (i < this.checkState.length) {
            result[i] = this.checkState[i].eval(tool, state, null);
            ++i;
        }
        return result;
    }

    void setCheckState(LiveExprNode[] checkState) {
        this.checkState = checkState;
    }

    public boolean[] checkAction(ITool tool, TLCState state0, TLCState state1) {
        boolean[] result = new boolean[this.checkAction.length];
        int i = 0;
        while (i < this.checkAction.length) {
            result[i] = this.checkAction[i].eval(tool, state0, state1);
            ++i;
        }
        return result;
    }

    public BitVector checkAction(ITool tool, TLCState state0, TLCState state1, BitVector result, int offset) {
        int i = 0;
        while (i < this.checkAction.length) {
            if (this.checkAction[i].eval(tool, state0, state1)) {
                result.set(offset + i);
            }
            ++i;
        }
        return result;
    }

    public LiveExprNode[] getCheckAction() {
        return this.checkAction;
    }

    void setCheckAction(LiveExprNode[] checkAction) {
        this.checkAction = checkAction;
    }

    public PossibleErrorModel[] getPems() {
        return this.pems;
    }

    void setPems(PossibleErrorModel[] pems) {
        this.pems = pems;
    }
}

