/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.RemoteException;
import tlc2.output.MP;
import tlc2.tool.TLCTrace;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import util.Assert;
import util.BufferedDataInputStream;
import util.BufferedDataOutputStream;
import util.FileUtil;

public class MemFPSet
extends FPSet {
    private String metadir;
    private String filename;
    private static final int MaxLoad = 20;
    private static final int LogInitialCapacity = 16;
    private long[][] table;
    private long count;
    private long threshold;
    private int mask;

    public static MemFPSet NewMemFPSetUnchecked() {
        try {
            return new MemFPSet();
        }
        catch (RemoteException notExpectedToHappen) {
            notExpectedToHappen.printStackTrace();
            return null;
        }
    }

    public MemFPSet() throws RemoteException {
        this(new FPSetConfiguration());
    }

    public MemFPSet(FPSetConfiguration fpSetConfig) throws RemoteException {
        super(fpSetConfig);
        int initialCapacity = 65536;
        this.count = 0L;
        this.threshold = initialCapacity * 20;
        this.table = new long[initialCapacity][];
        this.mask = initialCapacity - 1;
    }

    @Override
    public final FPSet init(int numThreads, String metadir, String filename) {
        this.metadir = metadir;
        this.filename = filename;
        return this;
    }

    @Override
    public final synchronized long size() {
        return this.count;
    }

    public final synchronized long sizeof() {
        long size = 28L;
        size += (long)(16 + this.table.length * 8);
        int i = 0;
        while (i < this.table.length) {
            if (this.table[i] != null) {
                size += (long)(16 + this.table[i].length * 8);
            }
            ++i;
        }
        return size;
    }

    @Override
    public synchronized boolean put(long fp) {
        int index = (int)(fp & (long)this.mask);
        long[] list = this.table[index];
        if (list != null) {
            int listlen = list.length;
            int i = 0;
            while (i < listlen) {
                if (list[i] == fp) {
                    return true;
                }
                ++i;
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            index = (int)(fp & (long)this.mask);
            list = this.table[index];
        }
        int len = list == null ? 0 : list.length;
        long[] newList = new long[len + 1];
        if (list != null) {
            System.arraycopy(list, 0, newList, 0, len);
        }
        newList[len] = fp;
        this.table[index] = newList;
        ++this.count;
        return false;
    }

    @Override
    public synchronized boolean contains(long fp) {
        int index = (int)(fp & (long)this.mask);
        long[] list = this.table[index];
        if (list != null) {
            int listlen = list.length;
            int i = 0;
            while (i < listlen) {
                if (list[i] == fp) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private final void rehash() {
        long min = this.count;
        long max = 0L;
        long[][] oldTable = this.table;
        int oldCapacity = oldTable.length;
        long[][] newTable = new long[oldCapacity * 2][];
        int onebitmask = oldCapacity;
        int i = 0;
        while (i < oldCapacity) {
            long[] list = oldTable[i];
            if (list != null) {
                int cnt0 = 0;
                int cnt1 = 0;
                int listlen = list.length;
                if ((long)listlen < min) {
                    min = listlen;
                }
                if ((long)listlen > max) {
                    max = listlen;
                }
                int j = 0;
                while (j < listlen) {
                    if ((list[j] & (long)onebitmask) == 0L) {
                        ++cnt0;
                    } else {
                        ++cnt1;
                    }
                    ++j;
                }
                if (cnt0 == 0) {
                    newTable[i + oldCapacity] = list;
                } else if (cnt1 == 0) {
                    newTable[i] = list;
                } else {
                    long[] list0 = new long[cnt0];
                    long[] list1 = new long[cnt1];
                    int j2 = 0;
                    while (j2 < listlen) {
                        if ((list[j2] & (long)onebitmask) == 0L) {
                            list0[--cnt0] = list[j2];
                        } else {
                            list1[--cnt1] = list[j2];
                        }
                        ++j2;
                    }
                    newTable[i] = list0;
                    newTable[i + oldCapacity] = list1;
                }
            }
            ++i;
        }
        this.threshold *= 2L;
        this.table = newTable;
        this.mask = newTable.length - 1;
    }

    @Override
    public final void exit(boolean cleanup) throws IOException {
        super.exit(cleanup);
        if (cleanup) {
            File file = new File(this.metadir);
            FileUtil.deleteDir(file, true);
        }
        String hostname = InetAddress.getLocalHost().getHostName();
        MP.printMessage(2211, hostname);
        System.exit(0);
    }

    @Override
    public final long checkFPs() {
        long dis = Long.MAX_VALUE;
        int i = 0;
        while (i < this.table.length) {
            long[] bucket = this.table[i];
            if (bucket != null) {
                int j = 0;
                while (j < bucket.length) {
                    int k = j + 1;
                    while (k < bucket.length) {
                        dis = Math.min(dis, Math.abs(bucket[j] - bucket[k]));
                        ++k;
                    }
                    k = i + 1;
                    while (k < this.table.length) {
                        long[] bucket1 = this.table[k];
                        if (bucket1 != null) {
                            int m = 0;
                            while (m < bucket1.length) {
                                long dis1;
                                long x = bucket[j];
                                long y = bucket1[m];
                                long l = dis1 = x > y ? x - y : y - x;
                                if (dis1 >= 0L) {
                                    dis = Math.min(dis, dis1);
                                }
                                ++m;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return dis;
    }

    @Override
    public final void beginChkpt(String fname) throws IOException {
        BufferedDataOutputStream dos = new BufferedDataOutputStream(this.chkptName(fname, "tmp"));
        int i = 0;
        while (i < this.table.length) {
            long[] bucket = this.table[i];
            if (bucket != null) {
                int j = 0;
                while (j < bucket.length) {
                    dos.writeLong(bucket[j]);
                    ++j;
                }
            }
            ++i;
        }
        dos.close();
    }

    @Override
    public final void commitChkpt(String fname) throws IOException {
        File oldChkpt = new File(this.chkptName(fname, "chkpt"));
        File newChkpt = new File(this.chkptName(fname, "tmp"));
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            throw new IOException("MemFPSet.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    @Override
    public final void recover(String fname) throws IOException {
        BufferedDataInputStream dis = new BufferedDataInputStream(this.chkptName(fname, "chkpt"));
        try {
            while (!dis.atEOF()) {
                Assert.check(!this.put(dis.readLong()), 2133);
            }
        }
        catch (EOFException e) {
            Assert.fail(2161, "checkpoints");
        }
        dis.close();
    }

    @Override
    public final void beginChkpt() throws IOException {
        this.beginChkpt(this.filename);
    }

    @Override
    public final void commitChkpt() throws IOException {
        this.commitChkpt(this.filename);
    }

    @Override
    public final void recover(TLCTrace trace) throws IOException {
        this.recover(this.filename);
    }

    @Override
    public final void recoverFP(long fp) throws IOException {
        Assert.check(!this.put(fp), 2133);
    }

    private final String chkptName(String fname, String ext) {
        return String.valueOf(this.metadir) + FileUtil.separator + fname + ".fp." + ext;
    }
}

