/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import org.junit.Test;
import tlc2.TLC;
import tlc2.TLCGlobals;
import tlc2.value.RandomEnumerableValues;

public class RunTwiceJUnitTest {
    @Test
    public void testSecondRunFailsIfNoReset() throws Exception {
        boolean globalsSet;
        int r1 = RunTwiceJUnitTest.runTLC("test-model/ModelA.tla");
        if (r1 == 0) {
            throw new AssertionError((Object)"ModelA should report invariant violation");
        }
        boolean bl = globalsSet = TLCGlobals.mainChecker != null || TLCGlobals.simulator != null;
        if (!globalsSet) {
            throw new AssertionError((Object)"TLC global state should be present after first run");
        }
        int r2 = RunTwiceJUnitTest.runTLC("test-model/ModelB_RunFlag.tla");
        if (r2 == 0) {
            throw new AssertionError((Object)"Second run unexpectedly succeeded without resetting globals");
        }
    }

    @Test
    public void testSecondRunSucceedsAfterReset() throws Exception {
        int r1 = RunTwiceJUnitTest.runTLC("test-model/ModelA.tla");
        if (r1 == 0) {
            throw new AssertionError((Object)"ModelA should report invariant violation");
        }
        TLCGlobals.reset();
        RandomEnumerableValues.reset();
        int r2 = RunTwiceJUnitTest.runTLC("test-model/ModelB_RunFlag.tla");
        if (r2 == 0) {
            throw new AssertionError((Object)"ModelB should report invariant violation on a clean run");
        }
    }

    private static int runTLC(String modelPath) throws Exception {
        TLC tlc = new TLC();
        String[] args = new String[]{"-workers", "1", "-deadlock", "-metadir", "states/RunTwiceJUnitTest", modelPath};
        tlc.handleParameters(args);
        return tlc.process();
    }
}

