/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import tla2sany.semantic.Context;
import tlc2.TLC;
import tlc2.tool.AbstractChecker;
import tlc2.tool.Simulator;
import tlc2.value.RandomEnumerableValues;

public class TLCGlobals {
    public static final int DEFAULT_CHECKPOINT_DURATION = 1800042;
    public static String versionOfTLC = "Version 2.20 of Day Month 20??";
    public static int enumBound = 2000;
    public static int setBound = 1000000;
    private static int numWorkers = 1;
    public static double livenessThreshold = 0.1;
    public static double livenessGraphSizeThreshold = 0.1;
    public static double livenessRatio = 0.2;
    public static String lnCheck = "default";
    public static AbstractChecker mainChecker = null;
    public static Simulator simulator = null;
    public static final char coverageIndent = '|';
    public static int coverageInterval = -1;
    public static int DFIDMax = -1;
    public static boolean continuation = false;
    public static boolean printDiffsOnly = false;
    public static boolean warn = true;
    public static final int progressInterval = Math.max(Math.abs(Integer.getInteger(String.valueOf(TLC.class.getName()) + ".progressInterval", 60)), 1) * 1000;
    public static long chkptDuration = Integer.getInteger(String.valueOf(TLCGlobals.class.getName()) + ".chkpt", 1800042).intValue();
    private static boolean forceChkpt = false;
    private static long lastChkpt = System.currentTimeMillis();
    public static final String metaRoot = "states";
    public static String metaDir = null;
    public static boolean useView = false;
    public static boolean useGZIP = false;
    public static boolean debug = false;
    public static boolean tool = false;
    public static boolean expand = true;

    public static boolean doLiveness() {
        return !lnCheck.equals("final") && !lnCheck.equals("seqfinal") && !lnCheck.equals("off");
    }

    public static boolean doSequentialLiveness() {
        return lnCheck.startsWith("seq");
    }

    public static synchronized void setNumWorkers(int n) {
        numWorkers = n;
    }

    public static synchronized int getNumWorkers() {
        return numWorkers;
    }

    public static synchronized void incNumWorkers(int n) {
        numWorkers += n;
    }

    public static void incNumWorkers() {
        TLCGlobals.incNumWorkers(1);
    }

    public static void decNumWorkers() {
        TLCGlobals.incNumWorkers(-1);
    }

    public static final boolean isCoverageEnabled() {
        return coverageInterval >= 0;
    }

    public static void forceChkpt() {
        forceChkpt = true;
    }

    public static boolean chkptExplicitlyEnabled() {
        return chkptDuration > 0L && chkptDuration != 1800042L;
    }

    public static boolean doCheckPoint() {
        if (forceChkpt) {
            forceChkpt = false;
            return true;
        }
        if (chkptDuration == 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - lastChkpt >= chkptDuration) {
            lastChkpt = now;
            return true;
        }
        return false;
    }

    public static boolean isValidSetSize(int bound) {
        return bound >= 1;
    }

    public static String getRevision() {
        return TLCGlobals.getManifestValue("X-Git-ShortRevision");
    }

    public static String getRevisionOrDev() {
        return TLCGlobals.getRevision() == null ? "development" : TLCGlobals.getRevision();
    }

    public static Date getBuildDate() {
        try {
            String manifestValue = TLCGlobals.getManifestValue("Build-TimeStamp");
            if (manifestValue == null) {
                return new Date();
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            return df.parse(manifestValue);
        }
        catch (NullPointerException | ParseException e) {
            return new Date();
        }
    }

    public static int getSCMCommits() {
        try {
            return Integer.parseInt(TLCGlobals.getManifestValue("X-Git-Commits-Count"));
        }
        catch (NullPointerException | NumberFormatException nfe) {
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getManifestValue(String key) {
        try {
            Manifest manifest;
            Attributes attributes;
            Enumeration<URL> resources = TLCGlobals.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            do {
                if (resources.hasMoreElements()) continue;
                return null;
            } while (!"TLA+ Tools".equals((attributes = (manifest = new Manifest(resources.nextElement().openStream())).getMainAttributes()).getValue("Implementation-Title")));
            if (attributes.getValue(key) == null) return null;
            return attributes.getValue(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getInstallLocation() {
        try {
            return new File(TLC.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
        }
        catch (URISyntaxException e) {
            return "unknown";
        }
    }

    public static synchronized void reset() {
        TLCGlobals.clearOperatorOverrideCaches();
        mainChecker = null;
        simulator = null;
        metaDir = null;
        numWorkers = 1;
        livenessThreshold = 0.1;
        livenessGraphSizeThreshold = 0.1;
        livenessRatio = 0.2;
        lnCheck = "default";
        coverageInterval = -1;
        DFIDMax = -1;
        continuation = false;
        printDiffsOnly = false;
        warn = true;
        useView = false;
        useGZIP = false;
        debug = false;
        tool = false;
        expand = true;
        forceChkpt = false;
        lastChkpt = System.currentTimeMillis();
        if (tlc2.module.TLC.OUTPUT != null) {
            try {
                tlc2.module.TLC.OUTPUT.flush();
                tlc2.module.TLC.OUTPUT.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            tlc2.module.TLC.OUTPUT = null;
        }
        try {
            Context.reInit();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to reset Context: " + e.getMessage(), e);
        }
        try {
            RandomEnumerableValues.reset();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to reset RandomEnumerableValues: " + e.getMessage(), e);
        }
    }

    public static synchronized void deepReset() {
        TLCGlobals.reset();
        TLCGlobals.clearPlusCalState();
        TLCGlobals.clearPcalTokenizeState();
        TLCGlobals.clearValueInputStreamCustomValues();
        TLCGlobals.clearSimpUtilState();
        TLCGlobals.clearModelValueState();
        TLCGlobals.clearTLCDebuggerOverride();
        TLCGlobals.clearTLCRunnerState();
        TLCGlobals.resetFrontEndToolIdCounter();
    }

    private static void clearPlusCalState() {
        try {
            Field f;
            String fieldName;
            Class<?> parseAlg = Class.forName("pcal.ParseAlgorithm");
            String[] stringArray = new String[]{"charReader", "currentProcedure"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                fieldName = stringArray[n2];
                f = parseAlg.getDeclaredField(fieldName);
                f.setAccessible(true);
                f.set(null, null);
                ++n2;
            }
            stringArray = new String[]{"plusLabels", "minusLabels", "proceduresCalled", "addedLabels", "addedLabelsLocs", "procedures"};
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                fieldName = stringArray[n2];
                f = parseAlg.getDeclaredField(fieldName);
                f.setAccessible(true);
                f.set(null, new Vector());
                ++n2;
            }
            stringArray = new String[]{"allLabels"};
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                fieldName = stringArray[n2];
                f = parseAlg.getDeclaredField(fieldName);
                f.setAccessible(true);
                f.set(null, new Hashtable());
                ++n2;
            }
            stringArray = new String[]{"gotoUsed", "gotoDoneUsed", "omitPC", "omitStutteringWhenDone", "hasDefaultInitialization", "pSyntax", "cSyntax", "hasLabel"};
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                fieldName = stringArray[n2];
                f = parseAlg.getDeclaredField(fieldName);
                f.setAccessible(true);
                f.setBoolean(null, false);
                ++n2;
            }
            stringArray = new String[]{"nextLabelNum", "lastTokCol", "lastTokLine"};
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                fieldName = stringArray[n2];
                f = parseAlg.getDeclaredField(fieldName);
                f.setAccessible(true);
                f.setInt(null, 0);
                ++n2;
            }
            stringArray = new String[]{"getLabelLocation"};
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                fieldName = stringArray[n2];
                f = parseAlg.getDeclaredField(fieldName);
                f.setAccessible(true);
                f.set(null, null);
                ++n2;
            }
            Class<?> pcalParams = Class.forName("pcal.PcalParams");
            pcalParams.getMethod("resetParams", new Class[0]).invoke(null, new Object[0]);
            Class<?> ast = Class.forName("pcal.AST");
            ast.getMethod("ASTInit", new Class[0]).invoke(null, new Object[0]);
            Class<?> pcalBuiltIns = Class.forName("pcal.PcalBuiltInSymbols");
            Method init = pcalBuiltIns.getMethod("Initialize", new Class[0]);
            init.invoke(null, new Object[0]);
            try {
                Class<?> pcalTranslate = Class.forName("pcal.PcalTranslate");
                String[] stringArray2 = new String[]{"st", "currentProcedure"};
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fName = stringArray2[n4];
                    Field f2 = pcalTranslate.getDeclaredField(fName);
                    f2.setAccessible(true);
                    f2.set(null, null);
                    ++n4;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to clear PlusCal state: " + e.getMessage(), e);
        }
    }

    private static void clearPcalTokenizeState() {
        try {
            Field f;
            String fieldName;
            Class<?> tokenize = Class.forName("pcal.Tokenize");
            String[] stringArray = new String[]{"Delimiter"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                fieldName = stringArray[n2];
                f = tokenize.getDeclaredField(fieldName);
                f.setAccessible(true);
                f.set(null, null);
                ++n2;
            }
            stringArray = new String[]{"DelimiterLine", "DelimiterCol"};
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                fieldName = stringArray[n2];
                f = tokenize.getDeclaredField(fieldName);
                f.setAccessible(true);
                f.setInt(null, 0);
                ++n2;
            }
            Field readerField = tokenize.getDeclaredField("reader");
            readerField.setAccessible(true);
            readerField.set(null, null);
        }
        catch (ClassNotFoundException tokenize) {
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to clear PlusCal tokenize state: " + e.getMessage(), e);
        }
    }

    private static void clearValueInputStreamCustomValues() {
        try {
            Class<?> vis = Class.forName("tlc2.value.ValueInputStream");
            Field f = vis.getDeclaredField("customValues");
            f.setAccessible(true);
            Map map = (Map)f.get(null);
            if (map != null) {
                map.clear();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to clear ValueInputStream customValues: " + e.getMessage(), e);
        }
    }

    private static void clearSimpUtilState() {
        try {
            Class<?> simpUtil = Class.forName("tlc2.util.SimpUtil");
            Field defns = simpUtil.getDeclaredField("defns");
            defns.setAccessible(true);
            defns.set(null, new Hashtable());
        }
        catch (ClassNotFoundException simpUtil) {
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to clear SimpUtil state: " + e.getMessage(), e);
        }
    }

    private static void clearModelValueState() {
        try {
            Class<?> modelValue = Class.forName("tlc2.value.impl.ModelValue");
            Field mvs = modelValue.getDeclaredField("mvs");
            mvs.setAccessible(true);
            mvs.set(null, null);
        }
        catch (ClassNotFoundException modelValue) {
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to clear ModelValue state: " + e.getMessage(), e);
        }
    }

    private static void clearTLCDebuggerOverride() {
        try {
            Class<?> debugger = Class.forName("tlc2.debug.TLCDebugger");
            Field override = debugger.getDeclaredField("OVERRIDE");
            override.setAccessible(true);
            override.set(null, null);
        }
        catch (ClassNotFoundException | NoSuchFieldException debugger) {
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to clear TLCDebugger override: " + e.getMessage(), e);
        }
    }

    private static void clearTLCRunnerState() {
        try {
            Class<?> tlcRunner = Class.forName("tlc2.TLCRunner");
            Field jvmArgs = tlcRunner.getDeclaredField("JVM_ARGUMENTS");
            jvmArgs.setAccessible(true);
            jvmArgs.set(null, null);
        }
        catch (ClassNotFoundException tlcRunner) {
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to clear TLCRunner state: " + e.getMessage(), e);
        }
    }

    private static void resetFrontEndToolIdCounter() {
        try {
            Class<?> frontEnd = Class.forName("tla2sany.semantic.FrontEnd");
            Field idCnt = frontEnd.getDeclaredField("idCnt");
            idCnt.setAccessible(true);
            idCnt.setInt(null, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void clearOperatorOverrideCaches() {
        if (mainChecker == null) {
            return;
        }
        try {
            Object tool = mainChecker.getClass().getField("tool").get(mainChecker);
            if (tool == null) {
                return;
            }
            Object specProcessor = tool.getClass().getMethod("getSpecProcessor", new Class[0]).invoke(tool, new Object[0]);
            if (specProcessor == null) {
                return;
            }
            Class<?> specProcessorClass = specProcessor.getClass();
            Method getSpecObjMethod = specProcessorClass.getMethod("getSpecObj", new Class[0]);
            Object specObj = getSpecObjMethod.invoke(specProcessor, new Object[0]);
            if (specObj == null) {
                return;
            }
            Class<?> specObjClass = specObj.getClass();
            Method getExternalModuleTableMethod = specObjClass.getMethod("getExternalModuleTable", new Class[0]);
            Object moduleTable = getExternalModuleTableMethod.invoke(specObj, new Object[0]);
            if (moduleTable == null) {
                return;
            }
            Field toolIdField = specProcessorClass.getDeclaredField("toolId");
            toolIdField.setAccessible(true);
            int toolId = toolIdField.getInt(specProcessor);
            Class<?> cacheManagerClass = Class.forName("tlc2.tool.ModuleASTCacheManager");
            Method clearCacheMethod = cacheManagerClass.getMethod("clearModuleASTCache", Class.forName("tla2sany.semantic.ExternalModuleTable"), Integer.TYPE);
            clearCacheMethod.invoke(null, moduleTable, toolId);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to clear operator override caches: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to clear operator override caches: " + e.getMessage(), e);
        }
    }

    public static final class Coverage {
        private static final int coverage = Integer.getInteger(String.valueOf(TLCGlobals.class.getName()) + ".coverage", 0);

        public static boolean isVariableEnabled() {
            if (TLCGlobals.isCoverageEnabled()) {
                return true;
            }
            return (coverage & 2) > 0;
        }

        public static boolean isActionEnabled() {
            if (TLCGlobals.isCoverageEnabled()) {
                return true;
            }
            return (coverage & 1) > 0;
        }

        public static boolean isEnabled() {
            if (TLCGlobals.isCoverageEnabled()) {
                return true;
            }
            return coverage > 0;
        }
    }
}

