/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import tlc2.TLC;
import tlc2.output.TeeOutputStream;
import tlc2.tool.fp.FPSetFactory;

public class TLCRunner {
    public static List<String> JVM_ARGUMENTS;
    private static final String TLC_CLASS;
    private final File outputLogfile;
    private final OutputStream outputOutputStream;
    private final List<String> arguments;
    private boolean silenceStdOut;

    static {
        TLC_CLASS = TLC.class.getName();
        JVM_ARGUMENTS = new ArrayList<String>();
        JVM_ARGUMENTS.add("-XX:+UseParallelGC");
        JVM_ARGUMENTS.add("-Dfile.encoding=UTF-8");
        JVM_ARGUMENTS.add("-Dtlc2.tool.fp.FPSet.impl=" + FPSetFactory.getImplementationDefault());
    }

    public TLCRunner(List<String> tlcArguments, File logfileDestination) {
        this.outputLogfile = logfileDestination;
        this.outputOutputStream = null;
        this.arguments = tlcArguments;
        this.silenceStdOut = false;
    }

    public TLCRunner(List<String> tlcArguments, OutputStream logfileOutputStream) {
        this.outputLogfile = null;
        this.outputOutputStream = logfileOutputStream;
        this.arguments = tlcArguments;
        this.silenceStdOut = false;
    }

    void setSilenceStdOut(boolean flag) {
        this.silenceStdOut = flag;
    }

    public int run() throws IOException {
        BufferedOutputStream logfileOutputStream;
        ProcessBuilder processBuilder = this.createProcess();
        Process p = processBuilder.start();
        BufferedInputStream stdOutReader = new BufferedInputStream(p.getInputStream());
        BufferedInputStream stdErrReader = new BufferedInputStream(p.getErrorStream());
        if (this.outputOutputStream != null) {
            logfileOutputStream = this.outputOutputStream instanceof BufferedOutputStream ? (BufferedOutputStream)this.outputOutputStream : new BufferedOutputStream(this.outputOutputStream);
        } else {
            FileOutputStream fos = new FileOutputStream(this.outputLogfile);
            logfileOutputStream = new BufferedOutputStream(fos);
        }
        FilterOutputStream stdOutPumpOutput = this.silenceStdOut ? logfileOutputStream : new TeeOutputStream(System.out, logfileOutputStream);
        StreamPump stdOutPump = new StreamPump(stdOutReader, stdOutPumpOutput);
        StreamPump stdErrPump = new StreamPump(stdErrReader, null);
        try {
            new Thread(stdOutPump).start();
            new Thread(stdErrPump).start();
            p.waitFor();
            int n = p.exitValue();
            return n;
        }
        catch (InterruptedException ie) {
            System.out.println("TLC process was interrupted: " + ie.getMessage());
        }
        finally {
            stdOutPump.stop();
            stdErrPump.stop();
            try {
                logfileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return 153;
    }

    private ProcessBuilder createProcess() {
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        String jvm = String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java" + (isWindows ? ".exe" : "");
        ArrayList<String> command = new ArrayList<String>();
        command.add(jvm);
        command.addAll(JVM_ARGUMENTS);
        command.add(TLC_CLASS);
        command.addAll(this.arguments);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Map<String, String> environment = processBuilder.environment();
        environment.put("CLASSPATH", System.getProperty("java.class.path"));
        return processBuilder;
    }

    private static class StreamPump
    implements Runnable {
        private static final int WAIT_SLEEP = 125;
        private final InputStream inputStream;
        private final OutputStream outputStream;
        private volatile boolean shouldStop;

        StreamPump(InputStream is, OutputStream os) {
            this.inputStream = is;
            this.outputStream = os;
            this.shouldStop = false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                block4: while (true) {
                    if (this.shouldStop) {
                        return;
                    }
                    while (true) {
                        if (this.inputStream.available() <= 0 || this.shouldStop) {
                            if (this.outputStream != null) {
                                this.outputStream.flush();
                            }
                            try {
                                Thread.sleep(125L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            continue block4;
                        }
                        if (this.outputStream != null) {
                            this.outputStream.write(this.inputStream.read());
                            continue;
                        }
                        this.inputStream.read();
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void stop() {
            this.shouldStop = true;
        }
    }
}

