/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public class UseOrHideNode
extends LevelNode {
    public LevelNode[] facts = null;
    public SymbolNode[] defs = null;
    public boolean isOnly;
    private UniqueString stepName = null;

    public void setStepName(UniqueString stepName) {
        this.stepName = stepName;
    }

    public UniqueString getStepName() {
        return this.stepName;
    }

    public UseOrHideNode(int kind, TreeNode stn, LevelNode[] theFacts, SymbolNode[] theDefs, boolean only) {
        super(kind, stn);
        this.facts = theFacts;
        this.defs = theDefs;
        this.isOnly = only;
    }

    public void factCheck(Errors errors) {
        if (this.facts == null || this.getKind() == 31) {
            return;
        }
        int i = 0;
        while (i < this.facts.length) {
            if (this.facts[i].getKind() == 9 && ((OpApplNode)this.facts[i]).operator.getKind() != 23) {
                errors.addError(ErrorCode.USE_OR_HIDE_FACT_NOT_VALID, this.facts[i].stn.getLocation(), "The only expression allowed as a fact in a HIDE is \nthe name of a theorem, assumption, or step.");
            }
            ++i;
        }
    }

    @Override
    public boolean levelCheck(int iter, Errors errors) {
        if (this.levelChecked >= iter) {
            return this.levelCorrect;
        }
        return this.levelCheckSubnodes(iter, this.facts, errors);
    }

    @Override
    public void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        int i = 0;
        while (i < this.facts.length) {
            this.facts[i].walkGraph(semNodesTable, visitor);
            ++i;
        }
        visitor.postVisit(this);
    }

    @Override
    public SemanticNode[] getChildren() {
        if (this.facts == null || this.facts.length == 0) {
            return null;
        }
        SemanticNode[] res = new SemanticNode[this.facts.length];
        int i = 0;
        while (i < this.facts.length) {
            res[i] = this.facts[i];
            ++i;
        }
        return res;
    }

    @Override
    public String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*UseOrHideNode:\n" + super.toString(depth, errors) + Strings.indent(2, "\nisOnly: " + this.isOnly) + Strings.indent(2, "\nfacts:");
        int i = 0;
        while (i < this.facts.length) {
            ret = String.valueOf(ret) + Strings.indent(4, this.facts[i].toString(1, errors));
            ++i;
        }
        ret = String.valueOf(ret) + Strings.indent(2, "\ndefs:");
        i = 0;
        while (i < this.defs.length) {
            ret = String.valueOf(ret) + Strings.indent(4, this.defs[i].toString(1, errors));
            ++i;
        }
        return ret;
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element e = doc.createElement("UseOrHideNode");
        Element factse = doc.createElement("facts");
        Element definitions = doc.createElement("defs");
        int i = 0;
        while (i < this.facts.length) {
            factse.appendChild(this.facts[i].export(doc, context, filter));
            ++i;
        }
        i = 0;
        while (i < this.defs.length) {
            definitions.appendChild(this.defs[i].export(doc, context, filter));
            ++i;
        }
        e.appendChild(factse);
        e.appendChild(definitions);
        if (this.isOnly) {
            e.appendChild(doc.createElement("only"));
        }
        if (this.getKind() == 32) {
            e.appendChild(doc.createElement("hide"));
        }
        return e;
    }
}

