/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tla2sany.semantic.SemanticNode;
import tlc2.TLCGlobals;
import tlc2.tool.Action;
import tlc2.tool.TLCState;
import tlc2.util.BitVector;
import tlc2.util.IStateWriter;
import tlc2.util.StateWriter;
import util.FileUtil;

public class DotStateWriter
extends StateWriter {
    private static final String dotColorScheme = "paired12";
    private final Map<String, Integer> actionToColors = new HashMap<String, Integer>();
    private final Map<Integer, Set<Long>> rankToNodes = new HashMap<Integer, Set<Long>>();
    private final Set<Long> strict;
    private final boolean colorize;
    private final boolean actionLabels;
    private Integer colorGen = 1;
    private final boolean snapshot;
    private final boolean constrained;
    private final boolean stuttering;

    public DotStateWriter() throws IOException {
        this("DotStateWriter.dot", "", false, false, false, false, false, false);
    }

    public DotStateWriter(String fname, String strict) throws IOException {
        this(fname, strict, false, false, false, false, false, false);
    }

    public DotStateWriter(String fname, boolean colorize, boolean actionLabels, boolean snapshot, boolean constrained, boolean stuttering, boolean strict) throws IOException {
        this(fname, "strict ", colorize, actionLabels, snapshot, constrained, stuttering, strict);
    }

    public DotStateWriter(String fname, String prefix, boolean colorize, boolean actionLabels, boolean snapshot, boolean constrained, boolean stuttering, boolean strict) throws IOException {
        super(fname);
        this.colorize = colorize;
        this.actionLabels = actionLabels;
        this.snapshot = snapshot;
        this.constrained = constrained;
        this.stuttering = stuttering;
        this.strict = strict ? new HashSet<Long>() : null;
        this.writer.append(String.valueOf(prefix) + "digraph DiskGraph {\n");
        this.writer.append("node [shape=box,style=rounded]\n");
        if (colorize) {
            this.writer.append(String.format("edge [colorscheme=\"%s\"]\n", dotColorScheme));
        }
        this.writer.append("nodesep=0.35;\n");
        this.writer.append("subgraph cluster_graph {\n");
        this.writer.append("color=\"white\";\n");
        this.writer.flush();
    }

    @Override
    public boolean isDot() {
        return true;
    }

    @Override
    public boolean isConstrained() {
        return this.constrained;
    }

    @Override
    public synchronized void writeState(TLCState state) {
        this.writer.append(Long.toString(state.fingerPrint()));
        this.writer.append(" [label=\"");
        this.writer.append(DotStateWriter.states2dot(state.evalStateLevelAlias()));
        this.writer.append("\",style = filled]");
        this.writer.append("\n");
        this.maintainRanks(state);
        if (this.snapshot) {
            try {
                this.snapshot();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    protected void maintainRanks(TLCState state) {
        this.rankToNodes.computeIfAbsent(state.getLevel(), k -> new HashSet()).add(state.fingerPrint());
    }

    @Override
    public void writeState(TLCState state, TLCState successor, short stateFlags) {
        this.writeState(state, successor, stateFlags, IStateWriter.Visualization.DEFAULT);
    }

    @Override
    public void writeState(TLCState state, TLCState successor, short stateFlags, Action action) {
        this.writeState(state, successor, null, 0, 0, stateFlags, IStateWriter.Visualization.DEFAULT, action, null);
    }

    @Override
    public void writeState(TLCState state, TLCState successor, short stateFlags, Action action, SemanticNode pred) {
        this.writeState(state, successor, null, 0, 0, stateFlags, IStateWriter.Visualization.DEFAULT, action, pred);
    }

    @Override
    public void writeState(TLCState state, TLCState successor, short stateFlags, IStateWriter.Visualization visualization) {
        this.writeState(state, successor, null, 0, 0, stateFlags, visualization, null, null);
    }

    @Override
    public void writeState(TLCState state, TLCState successor, BitVector actionChecks, int from, int length, short stateFlags) {
        this.writeState(state, successor, actionChecks, from, length, stateFlags, IStateWriter.Visualization.DEFAULT, null, null);
    }

    private synchronized void writeState(TLCState state, TLCState successor, BitVector actionChecks, int from, int length, short stateFlags, IStateWriter.Visualization visualization, Action action, SemanticNode pred) {
        if (!this.stuttering && visualization == IStateWriter.Visualization.STUTTERING) {
            return;
        }
        long sfp = successor.fingerPrint();
        long cfp = state.fingerPrint();
        if (this.strict != null && !this.strict.add(cfp ^ sfp)) {
            return;
        }
        String successorsFP = Long.toString(sfp);
        this.writer.append(Long.toString(cfp));
        this.writer.append(" -> ");
        this.writer.append(successorsFP);
        if (visualization == IStateWriter.Visualization.STUTTERING) {
            this.writer.append(" [style=\"dashed\",color=\"lightgray\"];\n");
        } else {
            if (action != null) {
                String transitionLabel = this.dotTransitionLabel(state, successor, action, pred);
                this.writer.append(transitionLabel);
            }
            this.writer.append(";\n");
            if (!this.isSet(stateFlags, 1)) {
                this.writer.append(successorsFP);
                this.writer.append(" [label=\"");
                if (TLCGlobals.printDiffsOnly) {
                    this.writer.append(DotStateWriter.states2dot(state.evalStateLevelAlias(), successor.evalStateLevelAlias()));
                } else {
                    this.writer.append(DotStateWriter.states2dot(successor.evalStateLevelAlias()));
                }
                this.writer.append("\",tooltip=\"");
                this.writer.append(DotStateWriter.states2dot(successor));
                if (this.isSet(stateFlags, 2)) {
                    this.writer.append("\",style = filled, fillcolor=lightyellow]");
                } else {
                    this.writer.append("\"]");
                }
                this.writer.append(";\n");
            }
        }
        this.maintainRanks(state);
        if (this.snapshot) {
            try {
                this.snapshot();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    protected Integer getActionColor(Action action) {
        if (action == null) {
            return 1;
        }
        String actionName = action.getName().toString();
        if (this.actionToColors.containsKey(actionName)) {
            return this.actionToColors.get(actionName);
        }
        this.colorGen = this.colorGen + 1;
        this.actionToColors.put(actionName, this.colorGen);
        return this.colorGen;
    }

    protected String dotTransitionLabel(TLCState state, TLCState successor, Action action, SemanticNode pred) {
        String color = this.colorize ? this.getActionColor(action).toString() : "black";
        String actionName = this.actionLabels ? action.getInvocationSignature().replace("\\", "\\\\").replace("\"", "\\\"").trim() : "";
        String labelFmtStr = " [label=\"%s%s\",color=\"%s\",fontcolor=\"%s\"]";
        return String.format(" [label=\"%s%s\",color=\"%s\",fontcolor=\"%s\"]", actionName, pred == null ? "" : "\n" + pred.toString(), color, color);
    }

    protected String dotLegend(String name, Set<String> actions) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("subgraph %s {", "cluster_legend"));
        sb.append("graph[style=bold];");
        sb.append("label = \"Next State Actions\" style=\"solid\"\n");
        sb.append(String.format("node [ labeljust=\"l\",colorscheme=\"%s\",style=filled,shape=record ]\n", dotColorScheme));
        for (String action : actions) {
            String str = String.format("%s [label=\"%s\",fillcolor=%d]", action.replaceAll("!", ":"), action, this.actionToColors.get(action));
            sb.append(str);
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    protected static String states2dot(TLCState predecessor, TLCState state) {
        return state.toString(predecessor).replace("\\", "\\\\").replace("\"", "\\\"").trim().replace("\n", "\\n");
    }

    protected static String states2dot(TLCState state) {
        return state.toString().replace("\\", "\\\\").replace("\"", "\\\"").trim().replace("\n", "\\n");
    }

    @Override
    public void close() {
        for (Set<Long> entry : this.rankToNodes.values()) {
            this.writer.append("{rank = same; ");
            for (Long l : entry) {
                this.writer.append(l + ";");
            }
            this.writer.append("}\n");
        }
        this.writer.append("}\n");
        if (this.colorize && this.actionToColors.size() > 1) {
            this.writer.append(this.dotLegend("DotLegend", this.actionToColors.keySet()));
        }
        this.writer.append("}");
        super.close();
    }

    @Override
    public void snapshot() throws IOException {
        this.writer.flush();
        String snapshot = this.fname.replace(".dot", "_snapshot.dot");
        FileUtil.copyFile(this.fname, snapshot);
        StringBuffer buf = new StringBuffer();
        for (Set<Long> entry : this.rankToNodes.values()) {
            buf.append("{rank = same; ");
            for (Long l : entry) {
                buf.append(l + ";");
            }
            buf.append("}\n");
        }
        buf.append("}\n");
        if (this.colorize && this.actionToColors.size() > 1) {
            buf.append(this.dotLegend("DotLegend", this.actionToColors.keySet()));
        }
        buf.append("}");
        Files.write(Paths.get(snapshot, new String[0]), buf.toString().getBytes(), StandardOpenOption.APPEND);
    }
}

