/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;
import java.io.PrintWriter;
import tlc2.tool.Action;
import util.FileUtil;

public class DotActionWriter {
    protected final PrintWriter writer;
    protected final String fname;

    public DotActionWriter(String fname, String strict) throws IOException {
        this.fname = fname;
        this.writer = new PrintWriter(FileUtil.newBFOS(fname));
        this.writer.append(String.valueOf(strict) + "digraph ActionGraph {\n");
        this.writer.append("nodesep=0.35;\n");
        this.writer.append("subgraph cluster_legend {\n");
        this.writer.append("label = \"Coverage\";\n");
        this.writer.append("node [shape=point] {\n");
        this.writer.append("d0 [style = invis];\n");
        this.writer.append("d1 [style = invis];\n");
        this.writer.append("p0 [style = invis];\n");
        this.writer.append("p0 [style = invis];\n");
        this.writer.append("}\n");
        this.writer.append("d0 -> d1 [label=unseen, color=\"green\", style=dotted]\n");
        this.writer.append("p0 -> p1 [label=seen]\n");
        this.writer.append("}\n");
        this.writer.flush();
    }

    public synchronized void write(Action action, int id) {
        this.writer.append(Integer.toString(id));
        this.writer.append(" [shape=box,label=\"");
        this.writer.append(action.getNameOfDefault());
        if (action.isInitPredicate()) {
            this.writer.append("\",style = filled]");
        } else {
            this.writer.append("\"]");
        }
        this.writer.append("\n");
    }

    public synchronized void write(int fromId, int toId) {
        this.write(fromId, toId, 0.0);
    }

    public synchronized void write(int fromId, int toId, double weight) {
        this.writer.append(Integer.toString(fromId));
        this.writer.append(" -> ");
        this.writer.append(Integer.toString(toId));
        if (weight == 0.0) {
            this.writer.append("[color=\"green\",style=dotted]");
        } else {
            this.writer.append(String.format("[penwidth=%s]", Double.toString(weight)));
        }
        this.writer.append(";\n");
    }

    public void close() {
        this.writer.append("}");
        this.writer.close();
    }

    public void writeSubGraphStart(String key, String label) {
        this.writer.append(String.format("subgraph cluster_%s {\ncolor=\"white\"\nlabel=\"%s\"\n", key, label));
    }

    public void writeSubGraphEnd() {
        this.writer.append("}\n");
    }
}

