/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.IOException;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import tlc2.tool.fp.OffHeapDiskFPSet;
import tlc2.util.RandomGenerator;

@State(value=Scope.Benchmark)
public class OffHeapIndexerBenchmark {
    RandomGenerator rng = new RandomGenerator(0L);
    long seed = 0L;
    private OffHeapDiskFPSet.Indexer infinite = new OffHeapDiskFPSet.InfinitePrecisionIndexer(0x40000000L, 1);
    private OffHeapDiskFPSet.Indexer infMult = new OffHeapDiskFPSet.Mult1024Indexer(0x40000000L, 1);
    private OffHeapDiskFPSet.Indexer bitshift = new OffHeapDiskFPSet.BitshiftingIndexer(0x40000000L, 1);

    @Setup
    public void up() throws IOException {
    }

    @Setup(value=Level.Iteration)
    public void reseedIter() {
        ++this.seed;
        this.rng.setSeed(this.seed);
    }

    @Setup(value=Level.Trial)
    public void reseed() {
        this.rng.setSeed(0L);
        this.seed = 0L;
    }

    @Benchmark
    public long InfMult() {
        return this.infMult.getIdx(this.rng.nextLong() & Long.MAX_VALUE);
    }

    @Benchmark
    public long Infinite() {
        return this.infinite.getIdx(this.rng.nextLong() & Long.MAX_VALUE);
    }

    @Benchmark
    public long Bitshift() {
        return this.bitshift.getIdx(this.rng.nextLong() & Long.MAX_VALUE);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(OffHeapIndexerBenchmark.class.getSimpleName()).build();
        new Runner(opt).run();
    }
}

