/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import tlc2.output.MP;
import tlc2.output.StatePrinter;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.TraceApp;
import tlc2.tool.WorkerException;
import tlc2.util.BufferedRandomAccessFile;
import tlc2.util.LongVec;
import tlc2.value.RandomEnumerableValues;
import tlc2.value.ValueOutputStream;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import util.Assert;
import util.FileUtil;

public class TLCTrace {
    static final String EXT = ".st";
    protected static String filename;
    private final BufferedRandomAccessFile raf;
    private long lastPtr;
    protected TraceApp tool;
    private int previousLevel;

    public TLCTrace(String metadir, String specFile, TraceApp tool) throws IOException {
        filename = String.valueOf(metadir) + FileUtil.separator + specFile + EXT;
        this.raf = new BufferedRandomAccessFile(filename, "rw");
        this.lastPtr = 1L;
        this.tool = tool;
    }

    public final synchronized long writeState(long aFingerprint) throws IOException {
        return this.writeState(1L, aFingerprint);
    }

    public final synchronized long writeState(TLCState predecessor, long aFingerprint) throws IOException {
        return this.writeState(predecessor.uid, aFingerprint);
    }

    private final synchronized long writeState(long predecessorLoc, long fp) throws IOException {
        this.lastPtr = this.raf.getFilePointer();
        this.raf.writeLongNat(predecessorLoc);
        this.raf.writeLong(fp);
        return this.lastPtr;
    }

    public void close() throws IOException {
        this.raf.close();
    }

    private synchronized long getPrev(long loc) throws IOException {
        this.raf.seek(loc);
        return this.raf.readLongNat();
    }

    private synchronized long getFP(long loc) throws IOException {
        this.raf.seek(loc);
        this.raf.readLongNat();
        return this.raf.readLong();
    }

    public synchronized int getLevelForReporting() throws IOException {
        int calculatedLevel = this.getLevel(this.lastPtr);
        if (calculatedLevel > this.previousLevel) {
            this.previousLevel = calculatedLevel;
        }
        return this.previousLevel;
    }

    public int getLevel() throws IOException {
        return this.getLevel(this.lastPtr);
    }

    public final synchronized int getLevel(long startLoc) throws IOException {
        long currentFilePointer = this.raf.getFilePointer();
        int level = 0;
        long predecessorLoc = startLoc;
        while (predecessorLoc != 1L) {
            ++level;
            predecessorLoc = this.getPrev(predecessorLoc);
        }
        this.raf.seek(currentFilePointer);
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TLCStateInfo[] getTrace() throws IOException {
        HashMap<Long, TLCStateInfo> locToState = new HashMap<Long, TLCStateInfo>();
        TLCTrace tLCTrace = this;
        synchronized (tLCTrace) {
            long curLoc = this.raf.getFilePointer();
            try {
                long length = this.raf.length();
                this.raf.seek(0L);
                this.raf.readLongNat();
                TLCStateInfo state = this.tool.getState(this.raf.readLong());
                locToState.put(0L, state);
                long location = 12L;
                while (location < length) {
                    long predecessorLocation = this.raf.readLongNat();
                    long fp = this.raf.readLong();
                    TLCStateInfo predecessor = (TLCStateInfo)locToState.get(predecessorLocation);
                    state = this.tool.getState(fp, predecessor.state);
                    state.stateNumber = location / 12L;
                    locToState.put(location, state);
                    location += 12L;
                }
            }
            finally {
                this.raf.seek(curLoc);
            }
        }
        return locToState.values().toArray(new TLCStateInfo[locToState.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TLCStateInfo[] getTrace(long loc, boolean included) throws IOException {
        LongVec fps = new LongVec();
        TLCTrace tLCTrace = this;
        synchronized (tLCTrace) {
            long loc1;
            long curLoc = this.raf.getFilePointer();
            long ploc = loc1 = included ? loc : this.getPrev(loc);
            while (ploc != 1L) {
                fps.addElement(this.getFP(ploc));
                ploc = this.getPrev(ploc);
            }
            this.raf.seek(curLoc);
        }
        return this.getTrace(fps);
    }

    protected final TLCStateInfo[] getTrace(LongVec fps) {
        return this.getTrace(null, fps);
    }

    protected final TLCStateInfo[] getTrace(TLCStateInfo sinfo, LongVec fps) {
        Random snapshot = RandomEnumerableValues.reset();
        int stateNum = 0;
        int len = fps.size();
        TLCStateInfo[] res = new TLCStateInfo[len];
        if (len > 0) {
            if (sinfo == null) {
                long fp = fps.elementAt(len - 1);
                sinfo = this.tool.getState(fp);
            }
            res[stateNum++] = sinfo;
            int i = len - 2;
            while (i >= 0) {
                long fp = fps.elementAt(i);
                sinfo = this.tool.getState(fp, sinfo.state);
                if (sinfo == null) {
                    MP.printError(2123);
                    MP.printError(2128, "2 " + Long.toString(fp));
                    System.exit(1);
                }
                res[stateNum++] = sinfo;
                --i;
            }
        }
        RandomEnumerableValues.set(snapshot);
        return res;
    }

    public void printTrace(TLCState s1, TLCState s2) throws IOException, WorkerException {
        this.printTrace(s1, s2, this.getTrace(s1.uid, false));
    }

    protected final void printTrace(TLCState s1, TLCState s2, TLCStateInfo[] prefix) throws IOException, WorkerException {
        TLCStateInfo sinfo;
        if (s1.isInitial()) {
            MP.printError(2121);
            if (s2 == null) {
                StatePrinter.printInvariantViolationStateTraceState(new TLCStateInfo(s1));
            } else {
                StatePrinter.printInvariantViolationStateTraceState(this.tool.evalAlias(new TLCStateInfo(s1), s2, prefix), s1, 1);
                TLCStateInfo state = this.tool.getState(s2, s1);
                StatePrinter.printInvariantViolationStateTraceState(this.tool.evalAlias(state, s2, prefix), s1, 2, true);
            }
            return;
        }
        MP.printError(2121);
        TLCState lastState = null;
        int idx = 0;
        while (idx < prefix.length - 1) {
            int j = idx + 1;
            StatePrinter.printInvariantViolationStateTraceState(this.tool.evalAlias(prefix[idx], prefix[j].state, () -> Arrays.asList(prefix).subList(0, j)), lastState, idx + 1);
            lastState = prefix[idx].state;
            ++idx;
        }
        if (prefix.length == 0) {
            sinfo = this.tool.getState(s1.fingerPrint());
            if (sinfo == null) {
                MP.printError(2123);
                MP.printError(2128, "3");
                System.exit(1);
            }
        } else {
            int j = prefix.length - 1;
            TLCStateInfo s0 = prefix[j];
            s1.setPredecessor(s0);
            StatePrinter.printInvariantViolationStateTraceState(this.tool.evalAlias(s0, s1, prefix), lastState, ++idx);
            sinfo = this.tool.getState(s1.fingerPrint(), s0.state);
            if (sinfo == null) {
                MP.printError(2123);
                MP.printError(2128, "4");
                StatePrinter.printStandaloneErrorState(s1);
                System.exit(1);
            }
            sinfo.state.uid = s1.uid;
            sinfo.state.workerId = s1.workerId;
        }
        if (s2 == null) {
            lastState = null;
        }
        StatePrinter.printInvariantViolationStateTraceState(this.tool.evalAlias(sinfo, s2 == null ? sinfo.state : s2, prefix, sinfo), lastState, ++idx, s2 == null);
        lastState = sinfo.state;
        if (s2 != null) {
            TLCStateInfo si1 = sinfo;
            sinfo = this.tool.getState(s2, s1);
            if (sinfo == null) {
                MP.printError(2123);
                MP.printError(2128, "5");
                StatePrinter.printStandaloneErrorState(s2);
                System.exit(1);
            }
            sinfo.state.uid = s2.uid;
            sinfo.state.workerId = s2.workerId;
            sinfo = this.tool.evalAlias(sinfo, s2, prefix, si1, sinfo);
            StatePrinter.printInvariantViolationStateTraceState(sinfo, null, ++idx, true);
        }
    }

    private final TLCStateInfo[] printPrefix(long fp) throws IOException {
        this.raf.seek(0L);
        this.raf.readLongNat();
        while (this.raf.readLong() != fp) {
            this.raf.readLongNat();
        }
        TLCState lastState = null;
        TLCStateInfo[] prefix = this.getTrace(this.lastPtr, false);
        int idx = 0;
        while (idx < prefix.length) {
            StatePrinter.printInvariantViolationStateTraceState(prefix[idx], lastState, idx + 1);
            lastState = prefix[idx].state;
            ++idx;
        }
        return prefix;
    }

    public synchronized void beginChkpt() throws IOException {
        this.raf.flush();
        DataOutputStream dos = FileUtil.newDFOS(String.valueOf(filename) + ".tmp");
        dos.writeLong(this.raf.getFilePointer());
        dos.writeLong(this.lastPtr);
        dos.close();
    }

    public void commitChkpt() throws IOException {
        File oldChkpt = new File(String.valueOf(filename) + ".chkpt");
        File newChkpt = new File(String.valueOf(filename) + ".tmp");
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            throw new IOException("Trace.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    public void recover() throws IOException {
        DataInputStream dis = FileUtil.newDFIS(String.valueOf(filename) + ".chkpt");
        long filePos = dis.readLong();
        this.lastPtr = dis.readLong();
        dis.close();
        this.raf.seek(filePos);
    }

    private long[] addBlock(long[] fp, long[] prev) throws IOException {
        int i = 0;
        while (i < fp.length) {
            prev[i] = this.writeState(prev[i], fp[i]);
            ++i;
        }
        return prev;
    }

    public synchronized Enumerator elements() throws IOException {
        return new TLCTraceEnumerator();
    }

    public static void writeBehavior(File file, TLCState state, StateVec stateTrace) {
        try {
            ValueOutputStream vos = new ValueOutputStream(file, true);
            Value[] v = new Value[stateTrace.size()];
            int i = 0;
            while (i < stateTrace.size()) {
                v[i] = new RecordValue(stateTrace.elementAt(i));
                ++i;
            }
            new TupleValue(v).write(vos);
            vos.close();
        }
        catch (IOException e) {
            Assert.fail(2161, file.getName());
        }
    }

    public static interface Enumerator {
        public long nextPos() throws IOException;

        public long nextFP() throws IOException;

        public void close() throws IOException;

        public void reset(long var1) throws IOException;
    }

    public class TLCTraceEnumerator
    implements Enumerator {
        long len;
        BufferedRandomAccessFile enumRaf;

        TLCTraceEnumerator() throws IOException {
            this.len = TLCTrace.this.raf.length();
            this.enumRaf = new BufferedRandomAccessFile(filename, "r");
        }

        @Override
        public final void reset(long pos) throws IOException {
            this.len = TLCTrace.this.raf.length();
            if (pos == -1L) {
                pos = this.enumRaf.getFilePointer();
            }
            this.enumRaf = new BufferedRandomAccessFile(filename, "r");
            this.enumRaf.seek(pos);
        }

        @Override
        public final long nextPos() throws IOException {
            long fpos = this.enumRaf.getFilePointer();
            if (fpos < this.len) {
                return fpos;
            }
            return -1L;
        }

        @Override
        public final long nextFP() throws IOException {
            this.enumRaf.readLongNat();
            return this.enumRaf.readLong();
        }

        @Override
        public final void close() throws IOException {
            this.enumRaf.close();
        }
    }
}

