/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import tla2tex.CommentToken;
import tla2tex.Debug;
import tla2tex.Misc;
import tla2tex.OutputFileWriter;
import tla2tex.Position;
import tla2tex.Token;

public class WriteTLAFile {
    public static void Write(Token[][] spec2, String fileName) {
        OutputFileWriter writer = new OutputFileWriter(fileName);
        int line = 0;
        boolean deleting = false;
        int multiBelow = 0;
        while (line < spec2.length) {
            String outLine = "";
            int item = 0;
            boolean nullComment = false;
            while (item < spec2[line].length) {
                Token tok = spec2[line][item];
                outLine = item > 0 ? String.valueOf(outLine) + WriteTLAFile.SpacesString(tok.column - spec2[line][item - 1].column - spec2[line][item - 1].getWidth()) : String.valueOf(outLine) + WriteTLAFile.SpacesString(tok.column);
                block0 : switch (tok.type) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 12: 
                    case 13: {
                        outLine = String.valueOf(outLine) + tok.string;
                        break;
                    }
                    case 3: {
                        outLine = String.valueOf(outLine) + "\"" + tok.string + "\"";
                        break;
                    }
                    case 5: {
                        CommentToken ctok = (CommentToken)tok;
                        if (ctok.subtype == 7) {
                            deleting = false;
                            multiBelow = 0;
                        }
                        String commentString = "";
                        if (ctok.subtype == 8 || ctok.subtype == 9) {
                            CommentToken bctok;
                            Token btok;
                            Position bpos;
                            int i = 0;
                            while (ctok != null && i < multiBelow) {
                                bpos = ctok.belowAlign;
                                ctok = null;
                                if (bpos.line != -1) {
                                    btok = bpos.toToken(spec2);
                                    if (btok.type == 5) {
                                        bctok = (CommentToken)btok;
                                        if (bctok.subtype == 8 || bctok.subtype == 9) {
                                            ctok = bctok;
                                        }
                                    }
                                }
                                ++i;
                            }
                            if (ctok != null) {
                                commentString = ctok.string;
                                if (deleting) {
                                    commentString = "`^" + commentString;
                                }
                                deleting = WriteTLAFile.UnmatchedDelete(commentString);
                                commentString = WriteTLAFile.RemoveDeletions(commentString);
                                while (deleting && ctok != null && Misc.isBlank(commentString)) {
                                    bpos = ctok.belowAlign;
                                    ctok = null;
                                    if (bpos.line == -1) continue;
                                    btok = bpos.toToken(spec2);
                                    if (btok.type != 5) continue;
                                    bctok = (CommentToken)btok;
                                    if (bctok.subtype != 8 && bctok.subtype != 9) continue;
                                    ctok = bctok;
                                    ++multiBelow;
                                    commentString = ctok.string;
                                    deleting = WriteTLAFile.UnmatchedDelete("`^" + commentString);
                                    commentString = WriteTLAFile.RemoveDeletions("`^" + commentString);
                                }
                            }
                            if (ctok != null && Misc.isBlank(commentString)) {
                                commentString = WriteTLAFile.SpacesString(ctok.string.length());
                            }
                        } else {
                            commentString = WriteTLAFile.RemoveDeletions(ctok.string);
                            commentString = String.valueOf(commentString) + WriteTLAFile.SpacesString(ctok.string.length() - commentString.length());
                        }
                        if (ctok != null) {
                            commentString = WriteTLAFile.ReplaceQuoteTildes(commentString);
                            switch (ctok.rsubtype) {
                                case 1: {
                                    outLine = String.valueOf(outLine) + "(*" + commentString + "*)";
                                    break block0;
                                }
                                case 2: {
                                    outLine = String.valueOf(outLine) + "\\*" + commentString;
                                    break block0;
                                }
                                case 3: {
                                    outLine = String.valueOf(outLine) + "(*" + commentString;
                                    break block0;
                                }
                                case 4: {
                                    outLine = String.valueOf(outLine) + commentString + "*)";
                                    break block0;
                                }
                                case 5: {
                                    outLine = String.valueOf(outLine) + commentString;
                                    break block0;
                                }
                            }
                            Debug.ReportBug("Bad CommentToken subtype found.");
                            break;
                        }
                        nullComment = true;
                        break;
                    }
                    default: {
                        Debug.ReportBug("Bad token type found.");
                    }
                }
                ++item;
            }
            if (!nullComment || spec2[line].length != 1) {
                writer.putLine(outLine);
            }
            ++line;
        }
        writer.close();
    }

    private static String SpacesString(int n) {
        int i = 0;
        String result = "";
        while (i < n) {
            result = String.valueOf(result) + " ";
            ++i;
        }
        return result;
    }

    private static boolean UnmatchedDelete(String str) {
        return str.lastIndexOf("^'") < str.lastIndexOf("`^");
    }

    private static String RemoveDeletions(String str) {
        String rest = str;
        String start = "";
        int nextDel = rest.indexOf("`^");
        while (nextDel != -1) {
            start = String.valueOf(start) + rest.substring(0, nextDel);
            int nextEnd = (rest = rest.substring(nextDel)).indexOf("^'");
            if (nextEnd == -1) {
                nextDel = -1;
                rest = "";
                continue;
            }
            rest = rest.substring(nextEnd + 2);
            nextDel = rest.indexOf("`^");
        }
        return String.valueOf(start) + rest;
    }

    private static String ReplaceQuoteTildes(String str) {
        String result = str;
        int nextRepl = result.indexOf("`~");
        while (nextRepl != -1) {
            result = String.valueOf(result.substring(0, nextRepl)) + "  " + result.substring(nextRepl + 2);
            nextRepl = result.indexOf("`~");
        }
        nextRepl = result.indexOf("~'");
        while (nextRepl != -1) {
            result = String.valueOf(result.substring(0, nextRepl)) + "  " + result.substring(nextRepl + 2);
            nextRepl = result.indexOf("~'");
        }
        nextRepl = result.indexOf("`.");
        while (nextRepl != -1) {
            result = String.valueOf(result.substring(0, nextRepl)) + "  " + result.substring(nextRepl + 2);
            nextRepl = result.indexOf("`.");
        }
        nextRepl = result.indexOf(".'");
        while (nextRepl != -1) {
            result = String.valueOf(result.substring(0, nextRepl)) + "  " + result.substring(nextRepl + 2);
            nextRepl = result.indexOf(".'");
        }
        return result;
    }
}

