/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.Context;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.SymbolTable;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import tla2sany.xml.SymbolContext;
import util.UniqueString;

public class APSubstInNode
extends LevelNode {
    private Subst[] substs;
    private LevelNode body;
    private ModuleNode instantiatingModule;
    private ModuleNode instantiatedModule;

    private APSubstInNode(TreeNode treeNode, Subst[] subs, LevelNode expr, ModuleNode ingmn, ModuleNode edmn, Errors errors) {
        super(30, treeNode);
        this.substs = subs;
        this.body = expr;
        this.instantiatingModule = ingmn;
        this.instantiatedModule = edmn;
        if (this.body == null) {
            errors.addError(ErrorCode.SUSPECTED_UNREACHABLE_CHECK, treeNode.getLocation(), "Substitution error, probably due to error in module being instantiated.");
        }
    }

    public APSubstInNode(TreeNode treeNode, SubstInNode subst, LevelNode expr, ModuleNode ingmn, ModuleNode edmn, Errors errors) {
        this(treeNode, subst.getSubsts(), expr, ingmn, edmn, errors);
    }

    public APSubstInNode(TreeNode treeNode, SymbolTable instancerST, Vector<OpDeclNode> instanceeDecls, ModuleNode ingmn, ModuleNode edmn, Errors errors) throws AbortException {
        super(30, treeNode);
        this.instantiatingModule = ingmn;
        this.instantiatedModule = edmn;
        this.constructSubst(instanceeDecls, instancerST, treeNode, errors);
        this.body = null;
    }

    public final Subst[] getSubsts() {
        return this.substs;
    }

    public final LevelNode getBody() {
        return this.body;
    }

    public final void setBody(LevelNode expr) {
        this.body = expr;
    }

    public final ModuleNode getInstantiatingModule() {
        return this.instantiatingModule;
    }

    public final ModuleNode getInstantiatedModule() {
        return this.instantiatedModule;
    }

    public final OpDeclNode getSubFor(int i) {
        return this.substs[i].getOp();
    }

    public final ExprOrOpArgNode getSubWith(int i) {
        return this.substs[i].getExpr();
    }

    final void constructSubst(Vector<OpDeclNode> instanceeDecls, SymbolTable instancerST, TreeNode treeNode, Errors errors) throws AbortException {
        Vector<Subst> vtemp = new Vector<Subst>();
        int i = 0;
        while (i < instanceeDecls.size()) {
            OpDeclNode decl = instanceeDecls.elementAt(i);
            SymbolNode symb = instancerST.resolveSymbol(decl.getName());
            if (symb != null) {
                if (decl.getKind() == 3 || decl.getKind() == 2 && decl.getArity() == 0) {
                    vtemp.addElement(new Subst(decl, new OpApplNode(symb, new ExprOrOpArgNode[0], treeNode, this.instantiatingModule, errors), null, true));
                } else {
                    vtemp.addElement(new Subst(decl, new OpArgNode(symb, treeNode, this.instantiatingModule), null, true));
                }
            }
            ++i;
        }
        this.substs = new Subst[vtemp.size()];
        i = 0;
        while (i < vtemp.size()) {
            this.substs[i] = (Subst)vtemp.elementAt(i);
            ++i;
        }
    }

    final void addExplicitSubstitute(Context instanceCtxt, UniqueString lhs, TreeNode stn, ExprOrOpArgNode sub, Errors errors) {
        int index = 0;
        while (index < this.substs.length) {
            if (lhs == this.substs[index].getOp().getName()) break;
            ++index;
        }
        if (index < this.substs.length) {
            if (!this.substs[index].isImplicit()) {
                errors.addError(ErrorCode.SUSPECTED_UNREACHABLE_CHECK, stn.getLocation(), "Multiple substitutions for symbol '" + lhs.toString() + "' in substitution.");
            } else {
                this.substs[index].setExpr(sub, false);
                this.substs[index].setExprSTN(stn);
            }
        } else {
            SymbolNode lhsSymbol = instanceCtxt.getSymbol(lhs);
            if (!(lhsSymbol instanceof OpDeclNode)) {
                return;
            }
            if (lhsSymbol != null) {
                int newlength = this.substs.length + 1;
                Subst[] newSubsts = new Subst[newlength];
                Subst newSubst = new Subst((OpDeclNode)lhsSymbol, sub, stn, false);
                System.arraycopy(this.substs, 0, newSubsts, 0, newlength - 1);
                newSubsts[newlength - 1] = newSubst;
                this.substs = newSubsts;
            } else {
                errors.addError(ErrorCode.SUSPECTED_UNREACHABLE_CHECK, stn.getLocation(), "Illegal identifier '" + lhs + "' in LHS of substitution.");
            }
        }
    }

    final void matchAll(Vector<OpDeclNode> decls, Errors errors) {
        int i = 0;
        while (i < decls.size()) {
            UniqueString opName = decls.elementAt(i).getName();
            int j = 0;
            while (j < this.substs.length) {
                if (this.substs[j].getOp().getName() == opName) break;
                ++j;
            }
            if (j >= this.substs.length) {
                errors.addError(ErrorCode.SUSPECTED_UNREACHABLE_CHECK, this.stn.getLocation(), "Substitution missing for symbol " + opName + " declared at " + decls.elementAt(i).getTreeNode().getLocation() + " \nand instantiated in module " + this.instantiatingModule.getName() + ".");
            }
            ++i;
        }
    }

    @Override
    public final boolean levelCheck(int itr, Errors errors) {
        if (this.levelChecked >= itr) {
            return this.levelCorrect;
        }
        this.levelChecked = itr;
        this.levelCorrect = true;
        if (!this.body.levelCheck(itr, errors)) {
            this.levelCorrect = false;
        }
        int i = 0;
        while (i < this.substs.length) {
            if (!this.getSubWith(i).levelCheck(itr, errors)) {
                this.levelCorrect = false;
            }
            ++i;
        }
        this.level = this.body.getLevel();
        HashSet<SymbolNode> lpSet = this.body.getLevelParams();
        int i2 = 0;
        while (i2 < this.substs.length) {
            if (lpSet.contains(this.getSubFor(i2))) {
                this.level = Math.max(this.level, this.getSubWith(i2).getLevel());
            }
            ++i2;
        }
        Iterator<SymbolNode> iter = lpSet.iterator();
        while (iter.hasNext()) {
            this.levelParams.addAll(Subst.paramSet(iter.next(), this.substs));
        }
        HashSet<SymbolNode> apSet = this.body.getAllParams();
        iter = apSet.iterator();
        while (iter.hasNext()) {
            this.allParams.addAll(Subst.allParamSet(iter.next(), this.substs));
        }
        boolean isConstant = this.instantiatedModule.isConstant(errors);
        this.levelConstraints = Subst.getSubLCSet(this.body, this.substs, isConstant, itr, errors);
        this.argLevelConstraints = Subst.getSubALCSet(this.body, this.substs, itr, errors);
        this.argLevelParams = Subst.getSubALPSet(this.body, this.substs);
        return this.levelCorrect;
    }

    @Override
    public final String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*APSubstInNode: " + super.toString(depth, errors) + "\n  instantiating module: " + this.instantiatingModule.getName() + ", instantiated module: " + this.instantiatedModule.getName() + Strings.indent(2, "\nSubstitutions:");
        if (this.substs != null) {
            int i = 0;
            while (i < this.substs.length) {
                ret = String.valueOf(ret) + Strings.indent(2, Strings.indent(2, "\nSubst:" + (this.substs[i] != null ? Strings.indent(2, this.substs[i].toString(depth - 1, errors)) : "<null>")));
                ++i;
            }
        } else {
            ret = String.valueOf(ret) + Strings.indent(2, "<null>");
        }
        ret = String.valueOf(ret) + Strings.indent(2, "\nBody:" + Strings.indent(2, this.body == null ? "<null>" : this.body.toString(depth - 1, errors)));
        return ret;
    }

    @Override
    public SemanticNode[] getChildren() {
        SemanticNode[] res = new SemanticNode[this.substs.length + 1];
        res[0] = this.body;
        int i = 0;
        while (i < this.substs.length) {
            res[i + 1] = this.substs[i].getExpr();
            ++i;
        }
        return res;
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.substs != null) {
            int i = 0;
            while (i < this.substs.length) {
                if (this.substs[i] != null) {
                    this.substs[i].walkGraph(semNodesTable, visitor);
                }
                ++i;
            }
        }
        if (this.body != null) {
            this.body.walkGraph(semNodesTable, visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element sbts = doc.createElement("substs");
        int i = 0;
        while (i < this.substs.length) {
            sbts.appendChild(this.substs[i].export(doc, context, filter));
            ++i;
        }
        Element bdy = doc.createElement("body");
        bdy.appendChild(this.body.export(doc, context, filter));
        Element from = doc.createElement("instFrom");
        Element fromchild = this.instantiatingModule.export(doc, context, filter);
        from.appendChild(fromchild);
        Element to = doc.createElement("instTo");
        Element tochild = this.instantiatedModule.export(doc, context, filter);
        to.appendChild(tochild);
        Element ret = doc.createElement("APSubstInNode");
        ret.appendChild(sbts);
        ret.appendChild(bdy);
        ret.appendChild(from);
        ret.appendChild(to);
        return ret;
    }
}

