/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.parser;

import tla2sany.st.SyntaxTreeConstants;
import util.UniqueString;

public class Operator
implements SyntaxTreeConstants {
    private UniqueString Id;
    private int Low;
    private int High;
    public int Associativity;
    public int Fix;
    private static Operator voidOperator = null;

    public static synchronized Operator VoidOperator() {
        if (voidOperator == null) {
            voidOperator = new Operator(UniqueString.uniqueStringOf("$$_void"), 0, 0, 0, 3);
        }
        return voidOperator;
    }

    public Operator(UniqueString id, int l, int h, int a, int f) {
        this.Id = id;
        this.Low = l;
        this.High = h;
        this.Associativity = a;
        this.Fix = f;
    }

    public Operator(String id, int l, int h, int a, int f) {
        this(UniqueString.uniqueStringOf(id), l, h, a, f);
    }

    public String toString() {
        switch (this.Fix) {
            case 0: {
                return String.valueOf(this.Id.toString()) + ", nofix";
            }
            case 1: {
                return String.valueOf(this.Id.toString()) + ", prefix";
            }
            case 2: {
                return String.valueOf(this.Id.toString()) + ", postfix";
            }
            case 3: {
                return String.valueOf(this.Id.toString()) + ", infix";
            }
            case 4: {
                return String.valueOf(this.Id.toString()) + ", nfix";
            }
        }
        return null;
    }

    public final boolean isPrefix() {
        return this.Fix == 1;
    }

    public final boolean isInfix() {
        return this.Fix == 3 || this.Fix == 4;
    }

    public final boolean isPostfix() {
        return this.Fix == 2;
    }

    public final boolean isNfix() {
        return this.Fix == 4;
    }

    public final boolean isPrefixDecl() {
        return this.Fix == 1 && this.Id.toString().endsWith(".");
    }

    public final boolean assocLeft() {
        return this.Associativity == 1;
    }

    public final boolean assocRight() {
        return this.Associativity == 2;
    }

    static final boolean succ(Operator left, Operator right) {
        return left.Low > right.High;
    }

    static final boolean prec(Operator left, Operator right) {
        return left.High < right.Low;
    }

    static final boolean samePrec(Operator left, Operator right) {
        return left.High == right.High && left.Low == right.Low;
    }

    public final UniqueString getIdentifier() {
        return this.Id;
    }
}

