/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.api;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import tla2sany.api.DefaultResolver;
import tla2sany.api.ModuleSourceCode;
import tla2sany.api.Resolver;

public class StringResolver
implements Resolver {
    private final DefaultResolver innerResolver = new DefaultResolver(new Path[0]);
    private final Map<String, String> stringModules;

    @Override
    public ModuleSourceCode resolve(String moduleName) {
        String stringModule = this.stringModules.get(moduleName);
        if (stringModule == null) {
            return this.innerResolver.resolve(moduleName);
        }
        return new ModuleSourceCode(stringModule.getBytes(), ModuleSourceCode.ModuleOrigin.IN_MEMORY_STRING, null);
    }

    public StringResolver(String moduleName, String moduleContents) {
        this.stringModules = new HashMap<String, String>();
        this.stringModules.put(moduleName, moduleContents);
    }

    public StringResolver(Map<String, String> modules) {
        this.stringModules = modules;
    }
}

