/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.OpDefNode;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.impl.EvaluatingValue;
import tlc2.value.impl.Value;
import util.Assert;

public class PriorityEvaluatingValue
extends EvaluatingValue {
    private static final Comparator<EvaluatingValue> comparator = new Comparator<EvaluatingValue>(){

        @Override
        public int compare(EvaluatingValue o1, EvaluatingValue o2) {
            return Integer.compare(o1.priority, o2.priority);
        }
    };
    private final ArrayList<EvaluatingValue> handles = new ArrayList();

    public PriorityEvaluatingValue(Method md, int minLevel, int priority, OpDefNode opDef, EvaluatingValue ev) {
        super(md, minLevel, priority, opDef);
        if (ev.opDef != this.opDef || ev.minLevel != this.minLevel) {
            Assert.fail(1000);
        }
        this.handles.add(this);
        this.handles.add(ev);
        this.handles.sort(comparator);
    }

    public void add(EvaluatingValue ev) {
        if (ev.opDef != this.opDef || ev.minLevel != this.minLevel) {
            Assert.fail(1000);
        }
        this.handles.add(ev);
        this.handles.sort(comparator);
    }

    @Override
    public Value eval(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        try {
            for (EvaluatingValue ev : this.handles) {
                Object invoke = ev.mh.invoke(tool, args, c, s0, s1, control, cm);
                if (invoke == null) continue;
                return (Value)invoke;
            }
            return tool.eval(this.opDef.getBody(), c, s0, s1, control, cm);
        }
        catch (Throwable e) {
            Assert.fail(2154, new String[]{this.md.toString(), e.getMessage()});
            return null;
        }
    }
}

