/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import sun.misc.Unsafe;
import util.Assert;
import util.TLCRuntime;

public final class LongArray {
    private final Unsafe unsafe;
    private final long baseAddress;
    private final long length;
    private static final int logAddressSize = 3;

    LongArray(long positions) {
        this.length = positions;
        this.unsafe = LongArray.getUnsafe();
        Assert.check(this.unsafe.addressSize() == 8, 1000);
        this.baseAddress = this.unsafe.allocateMemory(positions << 3);
    }

    LongArray(Collection<Long> from) {
        this(from.size());
        Iterator<Long> itr = from.iterator();
        long i = 0L;
        while (itr.hasNext()) {
            Long next = itr.next();
            this.set(i++, next);
        }
    }

    public static boolean isSupported() {
        if (TLCRuntime.ARCH.x86_64 != TLCRuntime.getInstance().getArchitecture()) {
            return false;
        }
        try {
            return LongArray.getUnsafe() != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static Unsafe getUnsafe() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Trying to use Sun VM specific sun.misc.Unsafe implementation but no Sun based VM detected.", e);
        }
    }

    public final void zeroMemory() throws IOException {
        this.unsafe.setMemory(this.baseAddress, this.length * 8L, (byte)0);
    }

    public final void zeroMemory(final int numThreads) throws IOException {
        final long segmentSize = (long)Math.floor(this.length / (long)numThreads);
        ExecutorService es = Executors.newFixedThreadPool(numThreads);
        try {
            try {
                ArrayList<1> tasks = new ArrayList<1>(numThreads);
                int i = 0;
                while (i < numThreads) {
                    final int offset = i++;
                    tasks.add(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            long lowerBound = segmentSize * (long)offset;
                            long upperBound = offset == numThreads - 1 ? LongArray.this.length : (long)(1 + offset) * segmentSize;
                            long pos = lowerBound;
                            while (pos < upperBound) {
                                LongArray.this.set(pos, 0L);
                                ++pos;
                            }
                            return true;
                        }
                    });
                }
                List invokeAll = es.invokeAll(tasks);
                Assert.check(!invokeAll.isEmpty(), 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                es.shutdown();
            }
        }
        finally {
            es.shutdown();
        }
    }

    private final long log2phy(long logicalAddress) {
        return this.baseAddress + (logicalAddress << 3);
    }

    private final void rangeCheck(long position) {
        assert (position >= 0L && position < this.length);
    }

    public final boolean trySet(long position, long expected, long value) {
        this.rangeCheck(position);
        return this.unsafe.compareAndSwapLong(null, this.log2phy(position), expected, value);
    }

    public final void set(long position, long value) {
        this.rangeCheck(position);
        this.unsafe.putAddress(this.log2phy(position), value);
    }

    public final long get(long position) {
        this.rangeCheck(position);
        return this.unsafe.getAddress(this.log2phy(position));
    }

    public final void swap(long position1, long position2) {
        this.rangeCheck(position1);
        this.rangeCheck(position2);
        long tmp = this.get(position1);
        this.set(position1, this.get(position2));
        this.set(position2, tmp);
    }

    void swapCopy(long position1, long position2) {
        long tmp = this.unsafe.getAddress(this.log2phy(position1));
        this.unsafe.copyMemory(this.log2phy(position2), this.log2phy(position1), 8L);
        this.unsafe.putAddress(this.log2phy(position2), tmp);
    }

    public final long size() {
        return this.length;
    }

    public String toString() {
        return this.toString(0L, this.length - 1L);
    }

    public String toString(long start, long end) {
        long iMax = end;
        if (iMax == -1L) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        long i = start;
        while (true) {
            long lng;
            if ((lng = this.get(i)) == 0L) {
                b.append("e");
            } else {
                b.append(lng);
            }
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static void main(String[] args) throws IOException {
        long elements = 1L << Integer.valueOf(args[0]);
        System.out.format("Allocating LongArray with %,d elements.\n", elements);
        LongArray longArray = new LongArray(elements);
        longArray.zeroMemory();
    }
}

