/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import tlc2.tool.ITool;
import tlc2.tool.TLCStateMut;
import tlc2.tool.impl.FastTool;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.Value;
import util.SimpleFilenameToStream;
import util.ToolIO;
import util.UniqueString;

@State(value=Scope.Benchmark)
public class ModuleOverwritesBenchmark {
    private static final String BASE_PATH = System.getProperty(String.valueOf(ModuleOverwritesBenchmark.class.getName()) + ".base");
    private static final ITool tool;
    private static final TLCStateMut state;

    static {
        String dir = String.valueOf(BASE_PATH) + File.separator + "ModuleOverwrites";
        System.err.println(dir);
        ToolIO.setUserDir(dir);
        tool = new FastTool("", "ModuleOverwrites", "ModuleOverwrites", new SimpleFilenameToStream());
        state = (TLCStateMut)tool.getInitStates().elementAt(0);
    }

    @Benchmark
    public boolean aNoModuleOverwrite() {
        ModuleOverwritesBenchmark.shuffleValues();
        return tool.isValid(tool.getInvariants()[0], state);
    }

    @Benchmark
    public boolean bModuleOverwrite() {
        ModuleOverwritesBenchmark.shuffleValues();
        return tool.isValid(tool.getInvariants()[1], state);
    }

    @Benchmark
    public boolean cModuleOverwriteLinear() {
        ModuleOverwritesBenchmark.shuffleValues();
        return tool.isValid(tool.getInvariants()[2], state);
    }

    private static final void shuffleValues() {
        FcnRcdValue frv = (FcnRcdValue)state.getVals().get(UniqueString.uniqueStringOf("t"));
        List<Value> values = Arrays.asList(frv.values);
        Collections.shuffle(values);
        int i = 0;
        while (i < values.size()) {
            frv.values[i] = values.get(i);
            ++i;
        }
    }
}

